/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.AspectManager;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.id.GUID;

public class LifecycleBinding {
    protected String name = GUID.asString();
    protected AspectManager manager;
    private String classes;
    private String expr;
    private String callbackBean;
    private ControllerState state;
    private String installMethod = "install";
    private String uninstallMethod = "uninstall";

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String classes) {
        this.expr = classes;
    }

    public void setCallbackBean(String name) {
        this.callbackBean = name;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public void setState(ControllerState state) {
        this.state = state;
    }

    public void setInstallMethod(String installMethod) {
        this.installMethod = installMethod;
    }

    public void setUninstallMethod(String uninstallMethod) {
        this.uninstallMethod = uninstallMethod;
    }

    public void start() throws Exception {
        if (this.expr == null && this.classes == null) {
            throw new IllegalArgumentException("Null classes and null expr");
        }
        if (this.expr != null && this.classes != null) {
            throw new IllegalArgumentException("Both classes and expr were set");
        }
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.callbackBean == null) {
            throw new IllegalArgumentException("Null callback bean");
        }
        if (this.state == null) {
            throw new IllegalArgumentException("Null controller state");
        }
        LifecycleCallbackBinding binding = new LifecycleCallbackBinding(this.name, this.classes, this.expr, (Object)this.state);
        binding.addLifecycleCallback(this.callbackBean, this.installMethod, this.uninstallMethod);
        this.manager.addLifecycleBinding(binding);
    }

    public void stop() throws Exception {
        this.manager.removeLifecycleBinding(this.name);
    }
}

