/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.microcontainer.beans.PrecedenceDefEntry;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecedenceDef {
    private AspectManager manager;
    private List<PrecedenceDefEntry> entries;
    private String name = GUID.asString();

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public List<PrecedenceDefEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<PrecedenceDefEntry> precedenceEntries) {
        this.entries = precedenceEntries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.entries == null) {
            throw new IllegalArgumentException("Null entries");
        }
        if (this.entries.size() == 0) {
            throw new IllegalArgumentException("No entries");
        }
        org.jboss.aop.advice.PrecedenceDefEntry[] pentries = new org.jboss.aop.advice.PrecedenceDefEntry[this.entries.size()];
        int i = 0;
        for (PrecedenceDefEntry entry : this.entries) {
            pentries[i++] = new org.jboss.aop.advice.PrecedenceDefEntry(entry.getAspectName(), entry.getAspectMethod());
        }
        this.manager.addPrecedence(new org.jboss.aop.advice.PrecedenceDef(this.name, pentries));
    }

    public void stop() {
        this.manager.removePrecedence(this.name);
    }
}

