/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class GenericBeanAspectFactory
extends GenericAspectFactory {
    private static final Logger log = Logger.getLogger(GenericBeanAspectFactory.class);
    protected BeanFactory factory;
    protected String name;
    protected String classname;
    protected Element element;
    protected KernelControllerContext context;

    public GenericBeanAspectFactory(String name, GenericBeanFactory factory, Element element) {
        super(null, element);
        this.name = name;
        this.element = element;
        this.setBeanFactory(factory);
    }

    public void setBeanFactory(GenericBeanFactory factory) {
        if (factory != null) {
            this.classname = factory.getBean();
        }
        this.factory = factory;
    }

    public String getAspectName() {
        return this.name;
    }

    public String getName() {
        return this.classname;
    }

    public String getClassname() {
        return this.classname;
    }

    public Object createPerVM() {
        return this.doCreate(null, null, null);
    }

    public Object createPerClass(Advisor advisor) {
        return this.doCreate(advisor, null, null);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        return this.doCreate(advisor, instanceAdvisor, null);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        return this.doCreate(advisor, null, jp);
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        return this.doCreate(advisor, instanceAdvisor, jp);
    }

    void setKernelControllerContext(KernelControllerContext context) {
        this.context = context;
    }

    protected Object doCreate(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        try {
            Object object;
            log.debug((Object)("Creating advice " + this.name));
            if (((GenericBeanFactory)this.factory).getClassLoader() == null) {
                ((GenericBeanFactory)this.factory).setClassLoader((ClassLoaderMetaData)new PushedClassLoaderMetaData());
            }
            if ((object = this.factory.createBean()) instanceof XmlLoadable) {
                ((XmlLoadable)object).importXml(this.element);
            }
            this.configureInstance(object, advisor, instanceAdvisor, jp);
            return object;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private class PushedClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;

        private PushedClassLoaderMetaData() {
        }

        public ValueMetaData getClassLoader() {
            ClassLoader cl = GenericBeanAspectFactory.this.getLoader();
            if (cl == null && ((GenericBeanFactory)GenericBeanAspectFactory.this.factory).getClassLoader() == this && GenericBeanAspectFactory.this.context != null) {
                try {
                    cl = GenericBeanAspectFactory.this.context.getClassLoader();
                }
                catch (Throwable t) {
                    this.log.trace((Object)("Unable to retrieve classloader from " + GenericBeanAspectFactory.this.context));
                }
            }
            if (cl == null) {
                try {
                    cl = Configurator.getClassLoader((ClassLoaderMetaData)((GenericBeanFactory)GenericBeanAspectFactory.this.factory).getClassLoader());
                }
                catch (Throwable e) {
                    this.log.trace((Object)("Unable to retrieve classloader from " + GenericBeanAspectFactory.this.factory));
                }
            }
            return new AbstractValueMetaData((Object)cl);
        }
    }
}

