/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.microcontainer.annotations.DisabledType;
import org.jboss.aop.microcontainer.beans.AspectManagerFactory;
import org.jboss.aop.microcontainer.integration.DisableAOPHelper;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.CommonLevelsUtil;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPConstructorJoinpoint
extends BasicConstructorJoinPoint {
    private static final List<ScopeLevel> levels = new ArrayList<ScopeLevel>(CommonLevelsUtil.getSubLevels((ScopeLevel)CommonLevels.INSTANCE));
    private AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
    private MetaData metaData;

    public AOPConstructorJoinpoint(org.jboss.reflect.spi.ConstructorInfo constructorInfo, Object metaData) {
        super(constructorInfo);
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (!(metaData instanceof MetaData)) {
            throw new IllegalArgumentException(metaData + " is not metadata");
        }
        this.metaData = (MetaData)MetaData.class.cast(metaData);
    }

    protected boolean bypassAOP(MetaData metaData) {
        return DisableAOPHelper.isAOPDisabled(metaData, DisabledType.POINTCUTS);
    }

    public Object dispatch() throws Throwable {
        if (this.bypassAOP(this.metaData)) {
            return super.dispatch();
        }
        Class clazz = this.constructorInfo.getDeclaringClass().getType();
        AspectManager manager = AspectManagerFactory.getAspectManager(this.metaData);
        boolean hasInstanceMetaData = this.rootHasSubInstanceMetaData(this.metaData);
        ContainerCache cache = ContainerCache.initialise((AspectManager)manager, (Class)clazz, (MetaData)this.metaData, (boolean)hasInstanceMetaData);
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        Object target = this.createTarget(cache, params);
        params.setProxiedClass(target.getClass());
        params.setMetaData(this.metaData);
        params.setTarget(target);
        params.setContainerCache(cache);
        params.setMetaDataHasInstanceLevelData(hasInstanceMetaData);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    private boolean rootHasSubInstanceMetaData(MetaData metaData) {
        if (metaData == null) {
            return false;
        }
        if (this.checkForMetaDataAtSubInstanceLevel(metaData)) {
            return true;
        }
        return this.rootHasMethodWithSubInstanceMetaData(metaData);
    }

    private boolean rootHasMethodWithSubInstanceMetaData(MetaData metaData) {
        for (ClassInfo info = this.constructorInfo.getDeclaringClass(); info != null; info = info.getSuperclass()) {
            MethodInfo[] methods = info.getDeclaredMethods();
            if (methods == null) continue;
            for (MethodInfo mi : methods) {
                if (!this.methodHasSubInstanceMetaData(metaData, mi)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean methodHasSubInstanceMetaData(MetaData metaData, MethodInfo mi) {
        MethodSignature sig = new MethodSignature(mi);
        MetaData methodMD = metaData.getComponentMetaData((Signature)sig);
        return this.checkForMetaDataAtSubInstanceLevel(methodMD);
    }

    private boolean checkForMetaDataAtSubInstanceLevel(MetaData metaData) {
        if (metaData != null) {
            for (ScopeLevel level : levels) {
                if (!this.hasMetaDataAtLevel(metaData, level)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasMetaDataAtLevel(MetaData metaData, ScopeLevel level) {
        MetaData levelMetaData = metaData.getScopeMetaData(level);
        if (levelMetaData != null && !levelMetaData.isEmpty()) {
            int annotationsSize;
            Object[] allMetaData = levelMetaData.getMetaData();
            Annotation[] annotations = levelMetaData.getAnnotations();
            int allSize = allMetaData.length;
            int n = annotationsSize = annotations != null ? annotations.length : 0;
            if (allSize > annotationsSize) {
                return true;
            }
            if (annotationsSize > 0) {
                return true;
            }
        }
        return false;
    }

    private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable {
        Advisor advisor = cache.getAdvisor();
        if (advisor != null) {
            Interceptor[] interceptors;
            ConstructorInfo aopinfo = this.findAopConstructorInfo(advisor);
            Interceptor[] interceptorArray = interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
            if (interceptors != null) {
                ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
                inv.setArguments(this.getArguments());
                return inv.invokeNext();
            }
            if (this.getConstructorInfo().getParameterTypes().length > 0) {
                Constructor<?> constructor = null;
                if (aopinfo == null) {
                    Constructor<?>[] ctors;
                    Class clazz = advisor.getClazz();
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!this.matchConstructor(ctor)) continue;
                        constructor = ctor;
                        break;
                    }
                } else {
                    constructor = aopinfo.getConstructor();
                }
                params.setCtor((Class[])constructor.getParameterTypes(), this.getArguments());
            }
        }
        return super.dispatch();
    }

    private ConstructorInfo findAopConstructorInfo(Advisor advisor) {
        ConstructorInfo[] infos = advisor.getConstructorInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!this.matchConstructor(infos[i].getConstructor())) continue;
            return infos[i];
        }
        return null;
    }

    private boolean matchConstructor(Constructor<?> ctor) {
        Class<?>[] ctorParams;
        TypeInfo[] params = this.constructorInfo.getParameterTypes();
        if (params.length == (ctorParams = ctor.getParameterTypes()).length) {
            boolean match = true;
            for (int p = 0; p < params.length; ++p) {
                if (params[p].getName().equals(ctorParams[p].getName())) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    static {
        levels.remove(CommonLevels.JOINPOINT);
    }
}

