/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deploymentfactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.test.BaseTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentFactoryTest
extends BaseTestCase {
    public AbstractDeploymentFactoryTest(String name) {
        super(name);
    }

    protected static void assertDefault(ContextInfo contextInfo) {
        AbstractDeploymentFactoryTest.assertDefaultPath(contextInfo);
        AbstractDeploymentFactoryTest.assertDefaultMetaDataPath(contextInfo);
        AbstractDeploymentFactoryTest.assertDefaultClassPath(contextInfo.getClassPath());
    }

    protected static void assertDefaultPath(ContextInfo contextInfo) {
        AbstractDeploymentFactoryTest.assertEquals((String)"", (String)contextInfo.getPath());
    }

    protected static void assertDefaultNonPath(ContextInfo contextInfo) {
        AbstractDeploymentFactoryTest.assertDefaultMetaDataPath(contextInfo);
        AbstractDeploymentFactoryTest.assertDefaultClassPath(contextInfo.getClassPath());
    }

    protected static void assertDefaultMetaDataPath(ContextInfo contextInfo) {
        AbstractDeploymentFactoryTest.assertNull((Object)contextInfo.getMetaDataPath());
    }

    protected static void assertDefaultClassPath(List<ClassPathEntry> classPath) {
        AbstractDeploymentFactoryTest.assertNotNull(classPath);
        AbstractDeploymentFactoryTest.assertEquals((int)1, (int)classPath.size());
        ClassPathEntry entry = classPath.get(0);
        AbstractDeploymentFactoryTest.assertNotNull((Object)entry);
        AbstractDeploymentFactoryTest.assertEquals((String)"", (String)entry.getPath());
        AbstractDeploymentFactoryTest.assertNull((Object)entry.getSuffixes());
    }

    protected StructureMetaData assertStructureMetaData(PredeterminedManagedObjectAttachments attachments) {
        AbstractDeploymentFactoryTest.assertNotNull((Object)attachments);
        Attachments x = attachments.getPredeterminedManagedObjects();
        AbstractDeploymentFactoryTest.assertNotNull((Object)x);
        StructureMetaData structure = (StructureMetaData)x.getAttachment(StructureMetaData.class);
        AbstractDeploymentFactoryTest.assertNotNull((Object)structure);
        return structure;
    }

    protected void assertContexts(PredeterminedManagedObjectAttachments attachments, ContextInfo ... expected) {
        StructureMetaData structure = this.assertStructureMetaData(attachments);
        this.assertContexts(structure, expected);
    }

    protected void assertContexts(StructureMetaData structure, ContextInfo ... expected) {
        AbstractDeploymentFactoryTest.assertNotNull((Object)structure);
        ArrayList<ContextInfo> contexts = new ArrayList<ContextInfo>();
        if (expected != null) {
            for (ContextInfo context : expected) {
                contexts.add(context);
            }
        }
        AbstractDeploymentFactoryTest.assertEquals(contexts, (Object)structure.getContexts());
    }

    protected abstract DeploymentFactory createDeploymentFactory();

    protected abstract Deployment createDeployment();

    public void testCreateClassPathEntryPath() {
        DeploymentFactory factory = this.createDeploymentFactory();
        ClassPathEntry entry = DeploymentFactory.createClassPathEntry((String)"path");
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractDeploymentFactoryTest.assertNull((Object)entry.getSuffixes());
    }

    public void testCreateClassPathEntryPathErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        try {
            DeploymentFactory.createClassPathEntry(null);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testCreateClassPathEntryPathAndSuffixes() {
        DeploymentFactory factory = this.createDeploymentFactory();
        ClassPathEntry entry = DeploymentFactory.createClassPathEntry((String)"path", (String)"suffixes");
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractDeploymentFactoryTest.assertEquals((String)"suffixes", (String)entry.getSuffixes());
        entry = DeploymentFactory.createClassPathEntry((String)"path", null);
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractDeploymentFactoryTest.assertNull((Object)entry.getSuffixes());
    }

    public void testCreateClassPathEntryPathAndSuffixesErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        try {
            DeploymentFactory.createClassPathEntry(null, (String)"suffixes");
            AbstractDeploymentFactoryTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testCreateClassPathPath() {
        DeploymentFactory factory = this.createDeploymentFactory();
        List<ClassPathEntry> expected = Collections.singletonList(DeploymentFactory.createClassPathEntry((String)"path"));
        List classPath = DeploymentFactory.createClassPath((String)"path");
        AbstractDeploymentFactoryTest.assertEquals(expected, (Object)classPath);
    }

    public void testCreateClassPathPathErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        try {
            DeploymentFactory.createClassPath(null);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testCreateClassPathPathAndSuffixes() {
        DeploymentFactory factory = this.createDeploymentFactory();
        List<ClassPathEntry> expected = Collections.singletonList(DeploymentFactory.createClassPathEntry((String)"path", (String)"suffixes"));
        List classPath = DeploymentFactory.createClassPath((String)"path", (String)"suffixes");
        AbstractDeploymentFactoryTest.assertEquals(expected, (Object)classPath);
    }

    public void testCreateClassPathPathAndSuffixesErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        try {
            DeploymentFactory.createClassPath(null, (String)"suffixes");
            AbstractDeploymentFactoryTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddContextPath() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        ContextInfo context = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path");
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)context.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context);
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context);
    }

    public void testAddContextPathErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        try {
            factory.addContext(null, "path");
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        try {
            factory.addContext((PredeterminedManagedObjectAttachments)deployment, null);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddContextPathAndClassPath() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        List classPath = DeploymentFactory.createClassPath((String)"ClassPath");
        ContextInfo context = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path", classPath);
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)context.getPath());
        AbstractDeploymentFactoryTest.assertDefaultMetaDataPath(context);
        AbstractDeploymentFactoryTest.assertEquals((Object)classPath, (Object)context.getClassPath());
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context);
        deployment = this.createDeployment();
        classPath = null;
        context = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path", classPath);
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)context.getPath());
        AbstractDeploymentFactoryTest.assertDefaultMetaDataPath(context);
        AbstractDeploymentFactoryTest.assertNull((Object)context.getClassPath());
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context);
    }

    public void testAddContextPathAndClassPathErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        List classPath = DeploymentFactory.createClassPath((String)"ClassPath");
        try {
            factory.addContext(null, "path", classPath);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        try {
            factory.addContext((PredeterminedManagedObjectAttachments)deployment, null, classPath);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddContextPathAndMetaDataAndClassPath() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        List classPath = DeploymentFactory.createClassPath((String)"ClassPath");
        ContextInfo context = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path", "metaDataPath", classPath);
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)context.getPath());
        AbstractDeploymentFactoryTest.assertEquals((String)"metaDataPath", (String)context.getMetaDataPath());
        AbstractDeploymentFactoryTest.assertEquals((Object)classPath, (Object)context.getClassPath());
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context);
        classPath = null;
        deployment = this.createDeployment();
        context = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path", "metaDataPath", classPath);
        AbstractDeploymentFactoryTest.assertEquals((String)"path", (String)context.getPath());
        AbstractDeploymentFactoryTest.assertEquals((String)"metaDataPath", (String)context.getMetaDataPath());
        AbstractDeploymentFactoryTest.assertNull((Object)context.getClassPath());
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context);
    }

    public void testAddContextPathAndMetaDataPathAndAndClassPathErrors() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        List classPath = DeploymentFactory.createClassPath((String)"ClassPath");
        try {
            factory.addContext(null, "path", "metaData", classPath);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        try {
            factory.addContext((PredeterminedManagedObjectAttachments)deployment, null, "metaData", classPath);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        try {
            factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path", null, classPath);
            AbstractDeploymentFactoryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractDeploymentFactoryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddContexts() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        ContextInfo context1 = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path1");
        AbstractDeploymentFactoryTest.assertEquals((String)"path1", (String)context1.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context1);
        ContextInfo context2 = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path2");
        AbstractDeploymentFactoryTest.assertEquals((String)"path2", (String)context2.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context1);
        ContextInfo context3 = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path3");
        AbstractDeploymentFactoryTest.assertEquals((String)"path3", (String)context3.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context1);
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, context1, context2, context3);
    }

    public void testAddContextsToContext() {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        ContextInfo parent = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "parent");
        AbstractDeploymentFactoryTest.assertEquals((String)"parent", (String)parent.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(parent);
        ContextInfo context1 = factory.addContext((PredeterminedManagedObjectAttachments)parent, "path1");
        AbstractDeploymentFactoryTest.assertEquals((String)"path1", (String)context1.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context1);
        ContextInfo context2 = factory.addContext((PredeterminedManagedObjectAttachments)parent, "path2");
        AbstractDeploymentFactoryTest.assertEquals((String)"path2", (String)context2.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context2);
        ContextInfo context3 = factory.addContext((PredeterminedManagedObjectAttachments)parent, "path3");
        AbstractDeploymentFactoryTest.assertEquals((String)"path3", (String)context3.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context3);
        this.assertContexts((PredeterminedManagedObjectAttachments)deployment, parent);
        this.assertContexts((PredeterminedManagedObjectAttachments)parent, context1, context2, context3);
    }

    public void testSerialization() throws Exception {
        DeploymentFactory factory = this.createDeploymentFactory();
        Deployment deployment = this.createDeployment();
        List classPath = DeploymentFactory.createClassPath((String)"ClassPath");
        ContextInfo context1 = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path1", "metaDataPath", classPath);
        AbstractDeploymentFactoryTest.assertEquals((String)"path1", (String)context1.getPath());
        AbstractDeploymentFactoryTest.assertEquals((String)"metaDataPath", (String)context1.getMetaDataPath());
        AbstractDeploymentFactoryTest.assertEquals((Object)classPath, (Object)context1.getClassPath());
        StructureMetaData structure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)deployment);
        this.assertContexts(structure, context1);
        deployment = (Deployment)this.serializeDeserialize((Serializable)deployment, Deployment.class);
        structure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)deployment);
        this.assertContexts(structure, context1);
        ContextInfo context2 = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "path2");
        AbstractDeploymentFactoryTest.assertEquals((String)"path2", (String)context2.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(context2);
        structure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)deployment);
        this.assertContexts(structure, context1, context2);
        deployment = (Deployment)this.serializeDeserialize((Serializable)deployment, Deployment.class);
        structure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)deployment);
        this.assertContexts(structure, context1, context2);
        ContextInfo testContext = structure.getContext("path2");
        ContextInfo child1 = factory.addContext((PredeterminedManagedObjectAttachments)testContext, "child1");
        AbstractDeploymentFactoryTest.assertEquals((String)"child1", (String)child1.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(child1);
        ContextInfo child2 = factory.addContext((PredeterminedManagedObjectAttachments)testContext, "child2");
        AbstractDeploymentFactoryTest.assertEquals((String)"child2", (String)child2.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(child2);
        ContextInfo child3 = factory.addContext((PredeterminedManagedObjectAttachments)testContext, "child3");
        AbstractDeploymentFactoryTest.assertEquals((String)"child3", (String)child3.getPath());
        AbstractDeploymentFactoryTest.assertDefaultNonPath(child3);
        this.assertContexts(structure, context1, context2);
        StructureMetaData childStructure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)testContext);
        this.assertContexts(childStructure, child1, child2, child3);
        structure = (StructureMetaData)this.serializeDeserialize((Serializable)structure, StructureMetaData.class);
        this.assertContexts(structure, context1, context2);
        testContext = structure.getContext("path2");
        AbstractDeploymentFactoryTest.assertEquals((Object)context2, (Object)testContext);
        childStructure = this.assertStructureMetaData((PredeterminedManagedObjectAttachments)testContext);
        this.assertContexts(childStructure, child1, child2, child3);
    }
}

