/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.deployers.plugins.classloading.ClassLoading;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.spi.deployer.helpers.AbstractTopLevelClassLoaderDeployer;
import org.jboss.deployers.structure.spi.DeploymentContext;

public abstract class AbstractTopLevelClassLoaderSystemDeployer
extends AbstractTopLevelClassLoaderDeployer {
    private ClassLoading classLoading;
    private ClassLoaderSystem system;
    private MBeanServer mbeanServer;

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
    }

    public ClassLoaderSystem getSystem() {
        return this.system;
    }

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader createTopLevelClassLoader(DeploymentContext context) throws Exception {
        ClassLoaderDomain domain;
        if (this.classLoading == null) {
            throw new IllegalStateException("The classLoading has not been set");
        }
        if (this.system == null) {
            throw new IllegalStateException("The system has not been set");
        }
        Module module = (Module)context.getTransientAttachments().getAttachment(Module.class);
        if (module == null) {
            throw new IllegalStateException("Deployment Context has no module: " + context);
        }
        ClassLoaderPolicy policy = this.createTopLevelClassLoaderPolicy(context, module);
        AbstractTopLevelClassLoaderSystemDeployer abstractTopLevelClassLoaderSystemDeployer = this;
        synchronized (abstractTopLevelClassLoaderSystemDeployer) {
            String domainName = module.getDomainName();
            domain = this.system.getDomain(domainName);
            if (domain == null) {
                ClassLoaderDomain parent = null;
                String parentDomain = module.getParentDomain();
                if (parentDomain != null) {
                    parent = this.system.getDomain(parentDomain);
                }
                ParentPolicy parentPolicy = module.getParentPolicy();
                domain = this.system.createAndRegisterDomain(domainName, parentPolicy, (Loader)parent);
            }
        }
        ClassLoader classLoader = this.system.registerClassLoaderPolicy(domain, policy);
        try {
            this.registerClassLoaderWithMBeanServer(classLoader);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unable to register classloader with mbeanserver: " + classLoader), t);
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTopLevelClassLoader(DeploymentContext context) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        try {
            this.unregisterClassLoaderFromMBeanServer(classLoader);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unable to unregister classloader from mbeanserver: " + classLoader), t);
        }
        try {
            this.system.unregisterClassLoader(classLoader);
        }
        finally {
            Module module = (Module)context.getTransientAttachments().getAttachment(Module.class);
            if (module == null) {
                throw new IllegalStateException("Deployment Context has no module: " + context);
            }
            this.cleanup(context, module);
            module.reset();
        }
    }

    protected void registerClassLoaderWithMBeanServer(ClassLoader classLoader) throws Exception {
        if (this.mbeanServer == null) {
            return;
        }
        if (!(classLoader instanceof RealClassLoader)) {
            return;
        }
        RealClassLoader jmxClassLoader = (RealClassLoader)classLoader;
        ObjectName name = jmxClassLoader.getObjectName();
        if (this.mbeanServer.isRegistered(name)) {
            return;
        }
        this.mbeanServer.registerMBean(classLoader, name);
    }

    protected void unregisterClassLoaderFromMBeanServer(ClassLoader classLoader) throws Exception {
        if (this.mbeanServer == null) {
            return;
        }
        if (!(classLoader instanceof RealClassLoader)) {
            return;
        }
        RealClassLoader jmxClassLoader = (RealClassLoader)classLoader;
        ObjectName name = jmxClassLoader.getObjectName();
        if (!this.mbeanServer.isRegistered(name)) {
            return;
        }
        this.mbeanServer.unregisterMBean(name);
    }

    protected abstract ClassLoaderPolicy createTopLevelClassLoaderPolicy(DeploymentContext var1, Module var2) throws Exception;

    protected void cleanup(DeploymentContext context, Module module) throws Exception {
    }
}

