/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.plugins.classloading.Domain;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
import org.jboss.deployers.structure.spi.classloading.ExportAll;
import org.jboss.deployers.structure.spi.classloading.Version;

public class ClassLoading {
    private Map<String, Domain> domains = new ConcurrentHashMap<String, Domain>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentUnit(DeploymentUnit deploymentUnit) {
        Domain domain;
        String domainName;
        if (deploymentUnit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        ClassLoaderMetaData metadata = (ClassLoaderMetaData)deploymentUnit.getAttachment(ClassLoaderMetaData.class);
        if (metadata == null) {
            metadata = new ClassLoaderMetaData();
            metadata.setName(deploymentUnit.getName());
            metadata.setExportAll(ExportAll.NON_EMPTY);
            metadata.setImportAll(true);
            metadata.setVersion(Version.DEFAULT_VERSION);
            deploymentUnit.addAttachment(ClassLoaderMetaData.class, (Object)metadata);
        }
        if ((domainName = metadata.getDomain()) == null) {
            domainName = "<DEFAULT>";
            metadata.setDomain(domainName);
        }
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            domain = this.domains.get(domainName);
            if (domain == null) {
                domain = new Domain(domainName);
                this.domains.put(domainName, domain);
            }
        }
        domain.addDeploymentUnit(deploymentUnit, metadata);
    }

    public void removeDeploymentUnit(DeploymentUnit deploymentUnit) {
        if (deploymentUnit == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        Module module = (Module)deploymentUnit.getAttachment(Module.class);
        if (module == null) {
            throw new IllegalStateException("Deployment Unit has no module: " + deploymentUnit);
        }
        module.release();
    }
}

