/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.Capability;
import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
import org.jboss.deployers.structure.spi.classloading.Requirement;

public class Domain {
    private String name;
    private Map<DeploymentUnit, Module> units = new ConcurrentHashMap<DeploymentUnit, Module>();

    public Domain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addDeploymentUnit(DeploymentUnit deploymentUnit, ClassLoaderMetaData metadata) {
        Module module = new Module(this, deploymentUnit, metadata);
        deploymentUnit.addAttachment(Module.class, (Object)module);
        this.units.put(deploymentUnit, module);
        module.createDependencies();
    }

    protected Module getModule(String name) {
        for (Module module : this.units.values()) {
            if (!name.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    protected Object resolve(Controller controller, Module module, Requirement requirement) {
        for (Module other : this.units.values()) {
            ClassLoaderMetaData metadata = other.getMetadata();
            List capabilities = metadata.getCapabilities();
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                if (!capability.resolves(module.getDeploymentUnit(), requirement)) continue;
                return other.getName();
            }
        }
        return null;
    }

    protected void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        DeploymentUnit unit = module.getDeploymentUnit();
        this.units.remove(unit);
    }
}

