/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.plugins.classloading.Domain;
import org.jboss.deployers.plugins.classloading.RequirementDependencyItem;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.Capability;
import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
import org.jboss.deployers.structure.spi.classloading.ExportAll;
import org.jboss.deployers.structure.spi.classloading.PackageCapability;
import org.jboss.deployers.structure.spi.classloading.Requirement;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    private Domain domain;
    private DeploymentUnit deploymentUnit;
    private ClassLoaderMetaData metadata;
    private List<RequirementDependencyItem> requirementDependencies;
    private URL dynamicClassRoot;

    public Module(Domain domain, DeploymentUnit deploymentUnit, ClassLoaderMetaData metadata) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (deploymentUnit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        this.domain = domain;
        this.deploymentUnit = deploymentUnit;
        this.metadata = metadata;
    }

    public String getName() {
        return this.deploymentUnit.getName();
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnit;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public ClassLoaderMetaData getMetadata() {
        return this.metadata;
    }

    public String getDomainName() {
        return this.getDomain().getName();
    }

    public String getParentDomain() {
        String parentDomain = this.getMetadata().getParentDomain();
        if (parentDomain == null && !"<DEFAULT>".equals(this.getDomainName())) {
            return "<DEFAULT>";
        }
        return parentDomain;
    }

    public ExportAll getExportAll() {
        return this.getMetadata().getExportAll();
    }

    public boolean isImportAll() {
        return this.getMetadata().isImportAll();
    }

    public ParentPolicy getParentPolicy() {
        if (this.getMetadata().isJ2seClassLoadingCompliance()) {
            return ParentPolicy.BEFORE;
        }
        return ParentPolicy.AFTER;
    }

    public List<? extends DelegateLoader> getDelegates() {
        if (this.requirementDependencies == null || this.requirementDependencies.isEmpty()) {
            return null;
        }
        ArrayList<DelegateLoader> result = new ArrayList<DelegateLoader>();
        for (RequirementDependencyItem item : this.requirementDependencies) {
            String name = (String)item.getIDependOn();
            Module module = this.domain.getModule(name);
            if (module == null) {
                throw new IllegalStateException("Module not found with name: " + name);
            }
            result.add(module.getDelegateLoader());
        }
        return result;
    }

    public DelegateLoader getDelegateLoader() {
        ClassLoaderPolicy policy = (ClassLoaderPolicy)this.deploymentUnit.getAttachment(ClassLoaderPolicy.class);
        if (policy == null) {
            throw new IllegalStateException("No policy for " + this.deploymentUnit.getName());
        }
        return new FilteredDelegateLoader(policy);
    }

    public String[] getPackageNames() {
        List capabilities = this.metadata.getCapabilities();
        if (capabilities == null) {
            return new String[0];
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        for (Capability capability : capabilities) {
            if (!(capability instanceof PackageCapability)) continue;
            packageNames.add(((PackageCapability)capability).getName());
        }
        return packageNames.toArray(new String[packageNames.size()]);
    }

    public void createDependencies() {
        List requirements = this.metadata.getRequirements();
        if (requirements != null) {
            this.requirementDependencies = new ArrayList<RequirementDependencyItem>();
            for (Requirement requirement : requirements) {
                RequirementDependencyItem item = new RequirementDependencyItem(this, requirement);
                this.requirementDependencies.add(item);
                this.deploymentUnit.addIDependOn((DependencyItem)item);
            }
        }
    }

    protected Object resolve(Controller controller, Requirement requirement) {
        return this.domain.resolve(controller, this, requirement);
    }

    public void reset() {
    }

    public void release() {
        this.domain.removeModule(this);
    }

    public URL getDynamicClassRoot() {
        if (this.dynamicClassRoot == null) {
            try {
                this.dynamicClassRoot = new URL("vfsmemory://" + new GUID());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.dynamicClassRoot;
    }
}

