/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerWrapper
implements Deployer,
ManagedObjectCreator {
    private Logger log;
    private Deployer deployer;
    private ManagedObjectCreator managedObjectCreator;

    public DeployerWrapper(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
        if (deployer instanceof ManagedObjectCreator) {
            this.managedObjectCreator = (ManagedObjectCreator)deployer;
        }
        this.log = Logger.getLogger(deployer.getClass());
    }

    public ManagedObjectCreator getManagedObjectCreator() {
        return this.managedObjectCreator;
    }

    public void setManagedObjectCreator(ManagedObjectCreator managedObjectCreator) {
        this.managedObjectCreator = managedObjectCreator;
    }

    public String getType() {
        return this.deployer.getType();
    }

    public int getRelativeOrder() {
        return this.deployer.getRelativeOrder();
    }

    public void setRelativeOrder(int order) {
        this.deployer.setRelativeOrder(order);
    }

    public boolean isAllInputs() {
        return this.deployer.isAllInputs();
    }

    public boolean isComponentsOnly() {
        return this.deployer.isComponentsOnly();
    }

    public boolean isWantComponents() {
        return this.deployer.isWantComponents();
    }

    public boolean isTopLevelOnly() {
        return this.deployer.isTopLevelOnly();
    }

    public Class<?> getInput() {
        return this.deployer.getInput();
    }

    public Class<?> getOutput() {
        return this.deployer.getOutput();
    }

    public Set<String> getInputs() {
        Set result = this.deployer.getInputs();
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public Set<String> getOutputs() {
        Set result = this.deployer.getOutputs();
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public DeploymentStage getStage() {
        return this.deployer.getStage();
    }

    public boolean isParentFirst() {
        return this.deployer.isParentFirst();
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Deploying: " + unit.getName()));
            this.deployer.deploy(unit);
            this.log.trace((Object)("Deployed:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.debug((Object)("Error during deploy: " + unit.getName()), t);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error during deploy: " + unit.getName()), (Throwable)t);
        }
    }

    public void undeploy(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Undeploying: " + unit.getName()));
            this.deployer.undeploy(unit);
            this.log.trace((Object)("Undeployed:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.error((Object)("Error during undeploy: " + unit.getName()), t);
        }
    }

    public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        try {
            ManagedObjectCreator creator = this.getManagedObjectCreator();
            if (creator != null) {
                creator.build(unit, managedObjects);
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error building managed objects for " + unit.getName()), (Throwable)t);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Deployer)) {
            return false;
        }
        if (obj instanceof DeployerWrapper) {
            obj = ((DeployerWrapper)obj).deployer;
        }
        return this.deployer.equals(obj);
    }

    public int hashCode() {
        return this.deployer.hashCode();
    }

    public String toString() {
        return this.deployer.toString();
    }
}

