/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.IncompleteDeployments;
import org.jboss.deployers.client.spi.MissingDependency;
import org.jboss.deployers.plugins.deployers.DeployerWrapper;
import org.jboss.deployers.plugins.deployers.DeploymentControllerContext;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.plugins.sort.DeployerSorterFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployersImpl
implements Deployers,
ControllerContextActions {
    private static final Logger log = Logger.getLogger(DeployersImpl.class);
    private AbstractController controller;
    private MutableMetaDataRepository repository;
    private Map<String, DeploymentStage> stages = new ConcurrentHashMap<String, DeploymentStage>();
    private Set<DeployerWrapper> deployers = new HashSet<DeployerWrapper>();
    private Map<String, List<Deployer>> deployersByStage = new HashMap<String, List<Deployer>>();
    private ScopeBuilder scopeBuilder;

    public DeployersImpl(AbstractController controller) {
        this(controller, null);
    }

    public DeployersImpl(AbstractController controller, Set<Deployer> deployers) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.addDeploymentStage(DeploymentStages.NOT_INSTALLED);
        this.addDeploymentStage(DeploymentStages.PARSE);
        this.addDeploymentStage(DeploymentStages.DESCRIBE);
        this.addDeploymentStage(DeploymentStages.CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.POST_CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.REAL);
        this.addDeploymentStage(DeploymentStages.INSTALLED);
        if (deployers != null) {
            this.setDeployers(deployers);
        }
    }

    public Set<DeployerWrapper> getDeployerWrappers() {
        return this.deployers;
    }

    public void setDeployers(Set<Deployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        HashSet<DeployerWrapper> oldDeployers = new HashSet<DeployerWrapper>(this.deployers);
        oldDeployers.removeAll(deployers);
        for (Deployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<Deployer> newDeployers = new HashSet<Deployer>(deployers);
        newDeployers.removeAll(this.deployers);
        for (Deployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            throw new IllegalArgumentException("Deployer has no stage: " + deployer);
        }
        this.addDeploymentStage(stage);
        DeployerWrapper wrapper = new DeployerWrapper(deployer);
        if (this.deployers.contains(wrapper)) {
            return;
        }
        String stageName = stage.getName();
        List<Object> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            deployers = Collections.emptyList();
        }
        deployers = this.insert(deployers, wrapper);
        this.deployersByStage.put(stageName, deployers);
        this.deployers.add(wrapper);
        StringBuilder builder = new StringBuilder();
        builder.append("Added deployer ").append(deployer).append(" for stage ").append(stageName).append('\n');
        for (Deployer temp : this.getDeployersList(stageName)) {
            builder.append(temp);
            builder.append("{inputs=").append(temp.getInputs());
            builder.append(" outputs=").append(temp.getOutputs());
            builder.append("}\n");
        }
        log.debug((Object)builder);
    }

    public synchronized void removeDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployers.remove(new DeployerWrapper(deployer));
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            log.warn((Object)("Deployer has no stage: " + deployer));
            return;
        }
        String stageName = stage.getName();
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            return;
        }
        deployers.remove(deployer);
        if (deployers.isEmpty()) {
            this.deployersByStage.remove(stageName);
        }
        log.debug((Object)("Removed deployer " + deployer + " from stage " + stageName));
    }

    protected synchronized void addDeploymentStage(DeploymentStage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Null stage");
        }
        String stageName = stage.getName();
        if (this.stages.containsKey(stageName)) {
            return;
        }
        ControllerState preceeds = null;
        String before = stage.getBefore();
        String after = stage.getAfter();
        if (before != null || after != null) {
            List states = this.controller.getStates();
            for (int i = 0; i < states.size(); ++i) {
                ControllerState state = (ControllerState)states.get(i);
                String stateName = state.getStateString();
                if (before != null && before.equals(stateName)) {
                    preceeds = state;
                    break;
                }
                if (after == null || !after.equals(stateName) || i >= states.size() - 1) continue;
                preceeds = (ControllerState)states.get(i + 1);
                break;
            }
        }
        this.controller.addState(new ControllerState(stageName), preceeds);
        this.stages.put(stageName, stage);
        log.debug((Object)("Added stage " + stageName + " before " + preceeds));
    }

    public ScopeBuilder getScopeBuilder() {
        return this.scopeBuilder;
    }

    public void setScopeBuilder(ScopeBuilder scopeBuilder) {
        this.scopeBuilder = scopeBuilder;
    }

    public MutableMetaDataRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MutableMetaDataRepository repository) {
        this.repository = repository;
    }

    public void start() {
        if (this.repository == null && this.controller instanceof KernelController) {
            KernelController kernelController = (KernelController)this.controller;
            this.repository = kernelController.getKernel().getMetaDataRepository().getMetaDataRepository();
        }
    }

    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        for (DeployerWrapper deployer : this.deployers) {
            deployer.build(context.getDeploymentUnit(), managedObjects);
        }
        return managedObjects;
    }

    public ManagedObjectCreator getDeployerManagedObjectBuilder(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        ManagedObjectCreator result = null;
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            result = wrapper.getManagedObjectCreator();
        }
        return result;
    }

    public void setDeployerManagedObjectBuilder(Deployer deployer, ManagedObjectCreator managedObjectCreator) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            wrapper.setManagedObjectCreator(managedObjectCreator);
        }
    }

    public void process(List<DeploymentContext> deploy, List<DeploymentContext> undeploy) {
        if (undeploy != null && !undeploy.isEmpty()) {
            ArrayList<DeploymentControllerContext> toUndeploy = new ArrayList<DeploymentControllerContext>();
            for (int i = undeploy.size() - 1; i >= 0; --i) {
                DeploymentContext context = undeploy.get(i);
                context.setState(DeploymentState.UNDEPLOYING);
                log.debug((Object)("Undeploying " + context.getName()));
                DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
                if (deploymentControllerContext == null) {
                    log.warn((Object)("DeploymentContext has no DeploymentControllerContext during undeploy request, ignoring: " + context));
                    continue;
                }
                toUndeploy.add(deploymentControllerContext);
            }
            List states = this.controller.getStates();
            for (int i = states.size() - 1; i >= 0; --i) {
                ControllerState state = (ControllerState)states.get(i);
                for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                    DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                    if (ControllerState.ERROR.equals((Object)context.getState())) continue;
                    try {
                        this.controller.change((ControllerContext)deploymentControllerContext, state);
                    }
                    catch (Throwable t) {
                        log.warn((Object)"Error during undeploy", t);
                        context.setState(DeploymentState.ERROR);
                        context.setProblem(t);
                    }
                }
            }
            for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                context.getTransientAttachments().removeAttachment(ControllerContext.class);
                try {
                    this.controller.uninstall(deploymentControllerContext.getName());
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, null);
                    DeployersImpl.removeClassLoader(context);
                    DeployersImpl.cleanup(context);
                    log.debug((Object)("Fully Undeployed " + context.getName()));
                }
                catch (Throwable t) {
                    log.warn((Object)"Error during uninstall", t);
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                }
            }
        }
        if (deploy != null && !deploy.isEmpty()) {
            for (DeploymentContext context : deploy) {
                DeploymentControllerContext deploymentControllerContext = new DeploymentControllerContext(context, this);
                try {
                    this.controller.install((ControllerContext)deploymentControllerContext);
                    context.setState(DeploymentState.DEPLOYING);
                    log.debug((Object)("Deploying " + context.getName()));
                    context.getTransientAttachments().addAttachment(ControllerContext.class, (Object)deploymentControllerContext);
                    if (this.scopeBuilder != null) {
                        context.getTransientAttachments().addAttachment(ScopeBuilder.class, (Object)this.scopeBuilder);
                    }
                    if (this.repository == null) continue;
                    context.getTransientAttachments().addAttachment(MutableMetaDataRepository.class, (Object)this.repository);
                }
                catch (Throwable t) {
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                }
            }
            List states = this.controller.getStates();
            for (ControllerState state : states) {
                for (DeploymentContext context : deploy) {
                    DeploymentControllerContext deploymentControllerContext;
                    if (DeploymentState.ERROR.equals((Object)context.getState())) continue;
                    deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
                    try {
                        this.controller.change((ControllerContext)deploymentControllerContext, state);
                    }
                    catch (Throwable t) {
                        context.setState(DeploymentState.ERROR);
                        context.setProblem(t);
                    }
                }
            }
        }
    }

    private static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable result = original;
        for (Throwable cause = result.getCause(); cause != null; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    public void checkComplete(Collection<DeploymentContext> errors, Collection<DeploymentContext> missingDeployer) throws DeploymentException {
        IncompleteDeployments incomplete;
        HashMap<String, Throwable> deploymentsInError = null;
        HashSet<String> deploymentsMissingDeployer = null;
        HashMap<String, Throwable> contextsInError = null;
        HashMap contextsMissingDependencies = null;
        if (errors != null && !errors.isEmpty()) {
            deploymentsInError = new HashMap<String, Throwable>();
            for (DeploymentContext context : errors) {
                deploymentsInError.put(context.getName(), DeployersImpl.getRootCause(context.getProblem()));
            }
        }
        if (missingDeployer != null && !missingDeployer.isEmpty()) {
            deploymentsMissingDeployer = new HashSet<String>();
            for (DeploymentContext context : missingDeployer) {
                deploymentsMissingDeployer.add(context.getName());
            }
        }
        if (this.controller != null) {
            List states = this.controller.getStates();
            Set notInstalled = this.controller.getNotInstalled();
            if (!notInstalled.isEmpty()) {
                Iterator i = notInstalled.iterator();
                while (i.hasNext()) {
                    ControllerContext context = (ControllerContext)i.next();
                    if (!context.getState().equals((Object)context.getRequiredState())) continue;
                    i.remove();
                }
                if (!notInstalled.isEmpty()) {
                    contextsInError = new HashMap<String, Throwable>();
                    contextsMissingDependencies = new HashMap();
                    for (ControllerContext context : notInstalled) {
                        if (context.getState().equals((Object)ControllerState.ERROR)) {
                            contextsInError.put(context.getName().toString(), DeployersImpl.getRootCause(context.getError()));
                            continue;
                        }
                        String name = context.getName().toString();
                        HashSet<MissingDependency> dependencies = new HashSet<MissingDependency>();
                        DependencyInfo dependsInfo = context.getDependencyInfo();
                        for (DependencyItem item : dependsInfo.getIDependOn(null)) {
                            int actual;
                            String actualStateString;
                            String dependency;
                            if (item.isResolved()) continue;
                            ControllerState actualState = null;
                            Object iDependOn = item.getIDependOn();
                            if (iDependOn == null) {
                                dependency = "<UNKNOWN>";
                                actualStateString = "** UNRESOLVED " + item.toHumanReadableString() + " **";
                            } else {
                                dependency = iDependOn.toString();
                                ControllerContext other = this.controller.getContext(item.getIDependOn(), null);
                                if (other == null) {
                                    actualStateString = "** NOT FOUND **";
                                } else {
                                    actualState = other.getState();
                                    actualStateString = actualState.getStateString();
                                }
                            }
                            ControllerState requiredState = item.getWhenRequired();
                            String requiredStateString = requiredState.getStateString();
                            int required = states.indexOf(requiredState);
                            if (required <= (actual = actualState == null ? -1 : states.indexOf(actualState))) continue;
                            MissingDependency missing = new MissingDependency(name, dependency, requiredStateString, actualStateString);
                            dependencies.add(missing);
                        }
                        contextsMissingDependencies.put(name, dependencies);
                    }
                }
            }
        }
        if ((incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    public void checkComplete(DeploymentContext context) throws DeploymentException {
        IncompleteDeployments incomplete;
        Map<String, Throwable> deploymentsInError = null;
        Set<String> deploymentsMissingDeployer = null;
        Map contextsInError = null;
        Map contextsMissingDependencies = null;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Throwable problem = context.getProblem();
        if (problem != null) {
            deploymentsInError = Collections.singletonMap(context.getName(), problem);
        }
        if (!context.isDeployed()) {
            deploymentsMissingDeployer = Collections.singleton(context.getName());
        }
        if ((incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        block11: {
            DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
            String stageName = toState.getStateString();
            DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
            try {
                List<Deployer> theDeployers = this.getDeployersList(stageName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Deployers for " + stageName + " " + theDeployers));
                }
                if (theDeployers.isEmpty()) break block11;
                try {
                    for (int i = 0; i < theDeployers.size(); ++i) {
                        Deployer deployer = theDeployers.get(i);
                        if (deployer.isParentFirst()) {
                            this.doInstallParentFirst(deployer, deploymentContext);
                            continue;
                        }
                        this.doInstallParentLast(deployer, deploymentContext);
                    }
                }
                catch (Throwable t) {
                    deploymentContext.setState(DeploymentState.ERROR);
                    deploymentContext.setProblem(t);
                    for (int j = i - 1; j >= 0; --j) {
                        Deployer deployer = theDeployers.get(j);
                        if (deployer.isParentFirst()) {
                            this.doUninstallParentLast(deployer, deploymentContext, true, true);
                            continue;
                        }
                        this.doUninstallParentFirst(deployer, deploymentContext, true, true);
                    }
                    DeployersImpl.setState(deploymentContext, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                    throw t;
                }
            }
            finally {
                if (ControllerState.INSTALLED.equals((Object)toState) && DeploymentState.DEPLOYING.equals((Object)deploymentContext.getState())) {
                    log.debug((Object)("Fully Deployed " + context.getName()));
                    DeployersImpl.setState(deploymentContext, DeploymentState.DEPLOYED, null);
                }
            }
        }
    }

    protected void doInstallParentFirst(Deployer deployer, DeploymentContext context) throws Throwable {
        List children;
        DeploymentUnit unit;
        List currentComponents = context.getComponents();
        ArrayList components = null;
        if (currentComponents != null && !currentComponents.isEmpty()) {
            components = new ArrayList(currentComponents);
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                deployer.deploy(unit);
            }
            catch (DeploymentException e) {
                context.setState(DeploymentState.ERROR);
                context.setProblem((Throwable)e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = (DeploymentContext)components.get(i);
                    try {
                        this.doInstallParentFirst(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = (DeploymentContext)components.get(j);
                            this.doUninstallParentLast(deployer, component, false, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, false);
                throw e;
            }
        }
        if ((children = context.getChildren()) != null) {
            try {
                for (int i = 0; i < children.size(); ++i) {
                    DeploymentContext child = (DeploymentContext)children.get(i);
                    try {
                        this.doInstallParentFirst(deployer, child);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            child = (DeploymentContext)children.get(j);
                            this.doUninstallParentLast(deployer, child, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, true);
                throw e;
            }
        }
    }

    protected void doInstallParentLast(Deployer deployer, DeploymentContext context) throws Throwable {
        DeploymentUnit unit;
        List children = context.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DeploymentContext child = (DeploymentContext)children.get(i);
            try {
                this.doInstallParentLast(deployer, child);
                continue;
            }
            catch (DeploymentException e) {
                for (int j = i - 1; j >= 0; --j) {
                    child = (DeploymentContext)children.get(j);
                    this.doUninstallParentFirst(deployer, child, true, true);
                }
                throw e;
            }
        }
        List components = context.getComponents();
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = (DeploymentContext)components.get(i);
                    try {
                        this.doInstallParentLast(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = (DeploymentContext)components.get(j);
                            this.doUninstallParentFirst(deployer, component, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, false);
                throw e;
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                deployer.deploy(unit);
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, true);
                context.setState(DeploymentState.ERROR);
                context.setProblem((Throwable)e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
    }

    public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
        String stageName = fromState.getStateString();
        DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
        List<Deployer> theDeployers = this.getDeployersList(stageName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deployers for " + stageName + " " + theDeployers));
        }
        if (!theDeployers.isEmpty()) {
            for (int i = theDeployers.size() - 1; i >= 0; --i) {
                Deployer deployer = theDeployers.get(i);
                if (deployer.isParentFirst()) {
                    this.doUninstallParentLast(deployer, deploymentContext, true, true);
                    continue;
                }
                this.doUninstallParentFirst(deployer, deploymentContext, true, true);
            }
        }
    }

    protected void doUninstallParentLast(Deployer deployer, DeploymentContext context, boolean doChildren, boolean doComponents) {
        DeploymentUnit unit;
        List components;
        int i;
        List children;
        if (doChildren && (children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = (DeploymentContext)children.get(i);
                this.doUninstallParentLast(deployer, child, true, true);
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = (DeploymentContext)components.get(i);
                this.doUninstallParentLast(deployer, component, false, true);
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            deployer.undeploy(unit);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
    }

    protected void doUninstallParentFirst(Deployer deployer, DeploymentContext context, boolean doContext, boolean doComponents) {
        List children;
        int i;
        List components;
        if (doContext) {
            DeploymentUnit unit = context.getDeploymentUnit();
            if (this.isRelevant(deployer, unit, context.isTopLevel(), context.isComponent())) {
                deployer.undeploy(unit);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = (DeploymentContext)components.get(i);
                this.doUninstallParentFirst(deployer, component, true, true);
            }
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = (DeploymentContext)children.get(i);
                this.doUninstallParentFirst(deployer, child, true, true);
            }
        }
    }

    protected synchronized List<Deployer> getDeployersList(String stageName) {
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null || deployers.isEmpty()) {
            return Collections.emptyList();
        }
        return deployers;
    }

    protected boolean isRelevant(Deployer deployer, DeploymentUnit unit, boolean isTopLevel, boolean isComponent) {
        Class input;
        if (deployer.isTopLevelOnly() && !isTopLevel) {
            return false;
        }
        if (deployer.isComponentsOnly() && !isComponent) {
            return false;
        }
        if (!deployer.isWantComponents() && isComponent) {
            return false;
        }
        return deployer.isAllInputs() || (input = deployer.getInput()) == null || unit.getAttachment(input) != null;
    }

    protected List<Deployer> insert(List<Deployer> original, Deployer newDeployer) {
        DeployerSorter sorter = DeployerSorterFactory.newSorter();
        return sorter.sortDeployers(original, newDeployer);
    }

    private static void setState(DeploymentContext context, DeploymentState state, DeploymentState ifState) {
        List children;
        if (ifState == null || ifState.equals((Object)context.getState())) {
            context.setState(state);
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.setState(child, state, ifState);
            }
        }
    }

    private static void removeClassLoader(DeploymentContext context) {
        context.removeClassLoader();
        List children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.removeClassLoader(child);
            }
        }
    }

    private static void cleanup(DeploymentContext context) {
        List components;
        context.cleanup();
        List children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.cleanup(child);
            }
        }
        if ((components = context.getComponents()) != null && !components.isEmpty()) {
            for (DeploymentContext component : components) {
                DeployersImpl.cleanup(component);
            }
        }
    }
}

