/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDeployerImpl
implements MainDeployer,
MainDeployerStructure {
    private static final Logger log = Logger.getLogger(MainDeployerImpl.class);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Deployers deployers;
    private StructuralDeployers structuralDeployers;
    private ManagedDeploymentCreator mgtDeploymentCreator = null;
    private Map<String, DeploymentContext> topLevelDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> allDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> errorDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> missingDeployers = new ConcurrentHashMap<String, DeploymentContext>();
    private List<DeploymentContext> undeploy = new CopyOnWriteArrayList<DeploymentContext>();
    private List<DeploymentContext> deploy = new CopyOnWriteArrayList<DeploymentContext>();

    public synchronized Deployers getDeployers() {
        return this.deployers;
    }

    public synchronized void setDeployers(Deployers deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        this.deployers = deployers;
    }

    public synchronized StructuralDeployers getStructuralDeployers() {
        return this.structuralDeployers;
    }

    public synchronized void setStructuralDeployers(StructuralDeployers deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        this.structuralDeployers = deployers;
    }

    public ManagedDeploymentCreator getMgtDeploymentCreator() {
        return this.mgtDeploymentCreator;
    }

    public void setMgtDeploymentCreator(ManagedDeploymentCreator mgtDeploymentCreator) {
        this.mgtDeploymentCreator = mgtDeploymentCreator;
    }

    public Deployment getDeployment(String name) {
        DeploymentContext context = this.getTopLevelDeploymentContext(name);
        if (context == null) {
            return null;
        }
        return context.getDeployment();
    }

    public DeploymentContext getDeploymentContext(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.allDeployments.get(name);
    }

    public DeploymentContext getDeploymentContext(String name, boolean errorNotFound) throws DeploymentException {
        DeploymentContext context = this.getDeploymentContext(name);
        if (errorNotFound && context == null) {
            throw new DeploymentException("Context " + name + " not found");
        }
        return context;
    }

    public DeploymentUnit getDeploymentUnit(String name) {
        DeploymentContext context = this.getDeploymentContext(name);
        if (context == null) {
            return null;
        }
        return context.getDeploymentUnit();
    }

    public DeploymentUnit getDeploymentUnit(String name, boolean errorNotFound) throws DeploymentException {
        DeploymentUnit unit = this.getDeploymentUnit(name);
        if (errorNotFound && unit == null) {
            throw new DeploymentException("Unit " + name + " not found");
        }
        return unit;
    }

    public DeploymentContext getTopLevelDeploymentContext(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.topLevelDeployments.get(name);
    }

    public Collection<DeploymentContext> getAll() {
        return Collections.unmodifiableCollection(this.allDeployments.values());
    }

    public Collection<DeploymentContext> getErrors() {
        return Collections.unmodifiableCollection(this.errorDeployments.values());
    }

    public Collection<DeploymentContext> getMissingDeployer() {
        return Collections.unmodifiableCollection(this.missingDeployers.values());
    }

    public Collection<Deployment> getTopLevel() {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (DeploymentContext context : this.topLevelDeployments.values()) {
            Deployment deployment = context.getDeployment();
            if (deployment != null) {
                result.add(deployment);
                continue;
            }
            throw new IllegalStateException("Context has no deployment? " + context.getName());
        }
        return result;
    }

    public synchronized void addDeployment(Deployment deployment) throws DeploymentException {
        if (deployment == null) {
            throw new DeploymentException("Null context");
        }
        if (this.shutdown.get()) {
            throw new DeploymentException("The main deployer is shutdown");
        }
        String name = deployment.getName();
        log.debug((Object)("Add deployment: " + name));
        DeploymentContext previous = this.topLevelDeployments.get(name);
        boolean topLevelFound = false;
        if (previous != null) {
            log.debug((Object)("Removing previous deployment: " + previous.getName()));
            this.removeContext(previous);
            topLevelFound = true;
        }
        if (!topLevelFound && (previous = this.allDeployments.get(name)) != null) {
            throw new IllegalStateException("Deployment already exists as a subdeployment: " + name);
        }
        try {
            DeploymentContext context = this.determineStructure(deployment);
            if (DeploymentState.ERROR.equals((Object)context.getState())) {
                this.errorDeployments.put(name, context);
            }
            this.topLevelDeployments.put(name, context);
            this.addContext(context);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining deployment structure for " + name), (Throwable)t);
        }
    }

    public synchronized boolean removeDeployment(Deployment deployment) throws DeploymentException {
        if (deployment == null) {
            throw new DeploymentException("Null deployment");
        }
        return this.removeDeployment(deployment.getName());
    }

    public synchronized boolean removeDeployment(String name) throws DeploymentException {
        if (name == null) {
            throw new DeploymentException("Null name");
        }
        if (this.shutdown.get()) {
            throw new IllegalStateException("The main deployer is shutdown");
        }
        log.debug((Object)("Remove deployment context: " + name));
        DeploymentContext context = this.topLevelDeployments.remove(name);
        if (context == null) {
            return false;
        }
        this.removeContext(context);
        return true;
    }

    public void deploy(Deployment deployment) throws DeploymentException {
        this.addDeployment(deployment);
        this.process();
        this.checkComplete(deployment);
    }

    public boolean undeploy(Deployment deployment) throws DeploymentException {
        if (deployment == null) {
            throw new DeploymentException("Null deployment");
        }
        return this.undeploy(deployment.getName());
    }

    public boolean undeploy(String name) throws DeploymentException {
        boolean result = this.removeDeployment(name);
        this.process();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The main deployer is shutdown");
        }
        ArrayList<DeploymentContext> undeployContexts = null;
        ArrayList<DeploymentContext> deployContexts = null;
        MainDeployerImpl mainDeployerImpl = this;
        synchronized (mainDeployerImpl) {
            if (this.deployers == null) {
                throw new IllegalStateException("No deployers");
            }
            if (!this.undeploy.isEmpty()) {
                undeployContexts = new ArrayList<DeploymentContext>(this.undeploy.size());
                for (int i = this.undeploy.size() - 1; i >= 0; --i) {
                    undeployContexts.add(this.undeploy.get(i));
                }
                this.undeploy.clear();
            }
            if (!this.deploy.isEmpty()) {
                deployContexts = new ArrayList<DeploymentContext>(this.deploy);
                this.deploy.clear();
            }
            if (undeployContexts == null && deployContexts == null) {
                log.debug((Object)"Asked to process() when there is nothing to do.");
                return;
            }
        }
        try {
            this.deployers.process(deployContexts, undeployContexts);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error in process()", t);
        }
    }

    public void shutdown() {
        while (!this.topLevelDeployments.isEmpty()) {
            for (DeploymentContext context : this.topLevelDeployments.values()) {
                this.topLevelDeployments.remove(context.getName());
                this.removeContext(context);
            }
            this.process();
        }
        this.shutdown.set(true);
    }

    public void checkComplete() throws DeploymentException {
        if (this.deployers == null) {
            throw new IllegalStateException("Null deployers");
        }
        this.deployers.checkComplete(this.errorDeployments.values(), this.missingDeployers.values());
    }

    public void checkComplete(Deployment deployment) throws DeploymentException {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.checkComplete(deployment.getName());
    }

    public void checkComplete(String name) throws DeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        DeploymentContext context = this.getDeploymentContext(name);
        if (context == null) {
            throw new DeploymentException("Deployment not found " + name);
        }
        if (this.deployers == null) {
            throw new IllegalStateException("Null deployers");
        }
        this.deployers.checkComplete(context);
    }

    public DeploymentState getDeploymentState(String name) {
        DeploymentContext context = this.getDeploymentContext(name);
        if (context == null) {
            return DeploymentState.UNDEPLOYED;
        }
        return context.getState();
    }

    public ManagedDeployment getManagedDeployment(String name) throws DeploymentException {
        DeploymentContext context = this.getDeploymentContext(name);
        if (context == null) {
            throw new IllegalArgumentException("Context not found: " + name);
        }
        Map<String, ManagedObject> rootMOs = this.getManagedObjects(context);
        ManagedDeployment root = this.mgtDeploymentCreator.build(context.getDeploymentUnit(), rootMOs, null);
        for (DeploymentContext childContext : context.getChildren()) {
            this.processManagedDeployment(childContext, root);
        }
        return root;
    }

    public Map<String, ManagedObject> getManagedObjects(String name) throws DeploymentException {
        DeploymentContext context = this.getDeploymentContext(name);
        if (context == null) {
            throw new IllegalArgumentException("Context not found: " + name);
        }
        return this.getManagedObjects(context);
    }

    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (this.deployers == null) {
            throw new IllegalStateException("No deployers");
        }
        return this.deployers.getManagedObjects(context);
    }

    public Graph<Map<String, ManagedObject>> getDeepManagedObjects(String name) throws DeploymentException {
        DeploymentContext context = this.getDeploymentContext(name);
        Graph managedObjectsGraph = new Graph();
        Vertex parent = new Vertex(context.getName());
        managedObjectsGraph.setRootVertex(parent);
        Map<String, ManagedObject> managedObjects = this.getManagedObjects(context);
        parent.setData(managedObjects);
        this.processManagedObjects(context, (Graph<Map<String, ManagedObject>>)managedObjectsGraph, (Vertex<Map<String, ManagedObject>>)parent);
        return managedObjectsGraph;
    }

    protected void processManagedObjects(DeploymentContext context, Graph<Map<String, ManagedObject>> graph, Vertex<Map<String, ManagedObject>> parent) throws DeploymentException {
        List children = context.getChildren();
        for (DeploymentContext child : children) {
            Vertex vertex = new Vertex(child.getName());
            Map<String, ManagedObject> managedObjects = this.getManagedObjects(context);
            vertex.setData(managedObjects);
            graph.addEdge(parent, vertex, 0);
            this.processManagedObjects(child, graph, (Vertex<Map<String, ManagedObject>>)vertex);
        }
    }

    protected void processManagedDeployment(DeploymentContext context, ManagedDeployment parent) throws DeploymentException {
        DeploymentUnit unit = context.getDeploymentUnit();
        Map<String, ManagedObject> MOs = this.getManagedObjects(context);
        ManagedDeployment md = this.mgtDeploymentCreator.build(unit, MOs, parent);
        for (DeploymentContext childContext : context.getChildren()) {
            this.processManagedDeployment(childContext, md);
        }
    }

    private DeploymentContext determineStructure(Deployment deployment) throws DeploymentException {
        DeploymentContext result;
        StructuralDeployers structuralDeployers = this.getStructuralDeployers();
        if (structuralDeployers != null && (result = structuralDeployers.determineStructure(deployment)) != null) {
            return result;
        }
        throw new DeploymentException("No structural deployers.");
    }

    private void addContext(DeploymentContext context) {
        List children;
        this.allDeployments.put(context.getName(), context);
        if (context.getState() == DeploymentState.ERROR) {
            log.debug((Object)("Not scheduling addition of context already in error: " + context.getName() + " reason=" + context.getProblem()));
            return;
        }
        context.setState(DeploymentState.DEPLOYING);
        DeploymentContext parent = context.getParent();
        log.debug((Object)("Scheduling deployment: " + context.getName() + " parent=" + parent));
        if (context.isTopLevel()) {
            this.deploy.add(context);
        }
        if ((children = context.getChildren()) != null) {
            for (DeploymentContext child : children) {
                this.addContext(child);
            }
        }
    }

    private void removeContext(DeploymentContext context) {
        List children;
        String name = context.getName();
        this.allDeployments.remove(name);
        this.errorDeployments.remove(name);
        this.missingDeployers.remove(name);
        if (context.getState() == DeploymentState.ERROR) {
            log.debug((Object)("Not scheduling removal of context already in error: " + name));
            return;
        }
        context.setState(DeploymentState.UNDEPLOYING);
        DeploymentContext parent = context.getParent();
        log.debug((Object)("Scheduling undeployment: " + name + " parent=" + parent));
        if (context.isTopLevel()) {
            this.undeploy.add(context);
        }
        if ((children = context.getChildren()) != null) {
            for (DeploymentContext child : children) {
                this.removeContext(child);
            }
        }
    }
}

