/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers;

import java.util.Set;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.plugins.deployers.DeployerWrapper;
import org.jboss.deployers.plugins.deployers.DeployersImpl;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.plugins.managed.DefaultManagedDeploymentCreator;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.deployers.structure.spi.StructureBuilder;
import org.jboss.deployers.structure.spi.helpers.AbstractStructuralDeployers;
import org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder;
import org.jboss.test.BaseTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployerTest
extends BaseTestCase {
    DeploymentFactory factory = new DeploymentFactory();

    public AbstractDeployerTest(String name) {
        super(name);
    }

    protected DeployerClient createMainDeployer() {
        return this.createMainDeployer(null);
    }

    protected DeployerClient createMainDeployer(Deployer ... deployers) {
        MainDeployerImpl mainDeployer = new MainDeployerImpl();
        StructuralDeployers structure = this.createStructuralDeployers();
        mainDeployer.setStructuralDeployers(structure);
        Deployers theDeployers = this.createDeployers();
        mainDeployer.setDeployers(theDeployers);
        ManagedDeploymentCreator mdc = this.createManagedDeploymentCreator();
        mainDeployer.setMgtDeploymentCreator(mdc);
        if (deployers != null) {
            for (Deployer deployer : deployers) {
                this.addDeployer((DeployerClient)mainDeployer, deployer);
            }
        }
        return mainDeployer;
    }

    protected StructureBuilder createStructureBuilder() {
        return new AbstractStructureBuilder();
    }

    protected ManagedDeploymentCreator createManagedDeploymentCreator() {
        return new DefaultManagedDeploymentCreator();
    }

    protected StructuralDeployers createStructuralDeployers() {
        StructureBuilder builder = this.createStructureBuilder();
        AbstractStructuralDeployers structure = new AbstractStructuralDeployers();
        structure.setStructureBuilder(builder);
        return structure;
    }

    protected Deployers createDeployers() {
        AbstractController controller = new AbstractController();
        return new DeployersImpl(controller);
    }

    protected void addDeployer(DeployerClient main, Deployer deployer) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        DeployersImpl deployersImpl = (DeployersImpl)mainDeployerImpl.getDeployers();
        deployersImpl.addDeployer(deployer);
    }

    protected void removeDeployer(DeployerClient main, Deployer deployer) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        DeployersImpl deployersImpl = (DeployersImpl)mainDeployerImpl.getDeployers();
        deployersImpl.removeDeployer(deployer);
    }

    protected void setDeployers(DeployerClient main, Set<Deployer> deployers) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        DeployersImpl deployersImpl = (DeployersImpl)mainDeployerImpl.getDeployers();
        deployersImpl.setDeployers(deployers);
    }

    protected Set<DeployerWrapper> getDeployers(DeployerClient main) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        DeployersImpl deployersImpl = (DeployersImpl)mainDeployerImpl.getDeployers();
        return deployersImpl.getDeployerWrappers();
    }

    protected DeploymentContext getDeploymentContext(DeployerClient main, String name) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        return mainDeployerImpl.getDeploymentContext(name);
    }

    protected DeploymentContext assertDeploymentContext(DeployerClient main, String name) {
        DeploymentContext context = this.getDeploymentContext(main, name);
        AbstractDeployerTest.assertNotNull((String)(name + " not found"), (Object)context);
        return context;
    }

    protected DeploymentUnit getDeploymentUnit(DeployerClient main, String name) {
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)main;
        return mainDeployerImpl.getDeploymentUnit(name);
    }

    protected DeploymentUnit assertDeploymentUnit(DeployerClient main, String name) {
        DeploymentUnit unit = this.getDeploymentUnit(main, name);
        AbstractDeployerTest.assertNotNull((String)(name + " not found"), (Object)unit);
        return unit;
    }

    @Deprecated
    protected DeploymentUnit deploy(DeployerClient main, Deployment deployment) throws Exception {
        main.deploy(new Deployment[]{deployment});
        return this.assertDeploymentUnit(main, deployment.getName());
    }

    protected DeploymentUnit assertDeploy(DeployerClient main, Deployment deployment) throws Exception {
        main.deploy(new Deployment[]{deployment});
        return this.assertDeploymentUnit(main, deployment.getName());
    }

    protected DeploymentUnit addDeployment(DeployerClient main, Deployment deployment) throws Exception {
        main.addDeployment(deployment);
        main.process();
        return this.assertDeploymentUnit(main, deployment.getName());
    }

    protected void assertUndeploy(DeployerClient main, Deployment deployment) throws Exception {
        main.undeploy(new Deployment[]{deployment});
    }

    protected Deployment createSimpleDeployment(String name) {
        AbstractDeployment unit = this.createAbstractDeployment(name);
        this.factory.addContext((PredeterminedManagedObjectAttachments)unit, "");
        return unit;
    }

    protected AbstractDeployment createAbstractDeployment(String name) {
        return new AbstractDeployment(name);
    }

    protected ContextInfo addChild(PredeterminedManagedObjectAttachments parent, String name) {
        return this.factory.addContext(parent, name);
    }

    protected void configureLogging() {
    }
}

