/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.classloading.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.plugins.classloading.AbstractClassLoaderDesribeDeployer;
import org.jboss.deployers.plugins.classloading.ClassLoading;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.deployers.structure.spi.classloading.VersionRange;
import org.jboss.deployers.structure.spi.classloading.helpers.ModuleCapabilityImpl;
import org.jboss.deployers.structure.spi.classloading.helpers.PackageCapabilityImpl;
import org.jboss.deployers.structure.spi.classloading.helpers.RequireModuleImpl;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.classloading.support.MockTopLevelClassLoaderSystemDeployer;
import org.jboss.test.deployers.classloading.support.a.A;
import org.jboss.test.deployers.classloading.support.b.B;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassLoaderDependenciesUnitTestCase
extends AbstractDeployerTest {
    public static final String NameA = "A";
    public static final String NameB = "B";
    public static final List<String> NONE = Collections.emptyList();
    public static final List<String> A = MockClassLoaderDependenciesUnitTestCase.makeList("A");
    public static final List<String> B = MockClassLoaderDependenciesUnitTestCase.makeList("B");
    public static final List<String> AB = MockClassLoaderDependenciesUnitTestCase.makeList("A", "B");
    public static final List<String> BA = MockClassLoaderDependenciesUnitTestCase.makeList("B", "A");
    public static final List<String> BAA = MockClassLoaderDependenciesUnitTestCase.makeList("B", "A", "A");
    public static final List<String> BABA = MockClassLoaderDependenciesUnitTestCase.makeList("B", "A", "B", "A");
    private AbstractClassLoaderDesribeDeployer deployer1;
    private MockTopLevelClassLoaderSystemDeployer deployer2;

    private static <T> List<T> makeList(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(MockClassLoaderDependenciesUnitTestCase.class);
    }

    public MockClassLoaderDependenciesUnitTestCase(String name) {
        super(name);
    }

    public void testSimpleClassLoader() throws Exception {
        DeployerClient deployer = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(NameA);
        MockClassLoaderDependenciesUnitTestCase.addMetaData(deployment, null, A.class);
        DeploymentUnit unit = this.assertDeploy(deployer, deployment);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        ClassLoader cl = unit.getClassLoader();
        this.assertLoadClass(cl, A.class);
        this.assertUndeploy(deployer, deployment);
        this.assertLoadClass(cl, A.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.undeployed);
    }

    public void testADependsUponModuleBCorrectWay() throws Exception {
        DeployerClient deployer = this.getMainDeployer();
        Deployment deploymentB = this.createSimpleDeployment(NameB);
        MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentB, null, B.class);
        DeploymentUnit unitB = this.assertDeploy(deployer, deploymentB);
        ClassLoader clB = unitB.getClassLoader();
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(B, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        Deployment deploymentA = this.createSimpleDeployment(NameA);
        ClassLoaderMetaData classLoaderMetaData = MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentA, null, A.class);
        MockClassLoaderDependenciesUnitTestCase.addRequireModule(classLoaderMetaData, NameB, null);
        DeploymentUnit unitA = this.assertDeploy(deployer, deploymentA);
        ClassLoader clA = unitA.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        this.assertUndeploy(deployer, deploymentA);
        this.assertLoadClassIllegal(clA, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        this.assertUndeploy(deployer, deploymentB);
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
    }

    public void testADependsUponModuleBWrongWay() throws Exception {
        DeployerClient deployer = this.getMainDeployer();
        Deployment deploymentA = this.createSimpleDeployment(NameA);
        ClassLoaderMetaData classLoaderMetaData = MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentA, null, A.class);
        MockClassLoaderDependenciesUnitTestCase.addRequireModule(classLoaderMetaData, NameB, null);
        DeploymentUnit unitA = this.addDeployment(deployer, deploymentA);
        this.assertNoClassLoader(unitA);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        Deployment deploymentB = this.createSimpleDeployment(NameB);
        MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentB, null, B.class);
        DeploymentUnit unitB = this.assertDeploy(deployer, deploymentB);
        ClassLoader clB = unitB.getClassLoader();
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        ClassLoader clA = unitA.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        this.assertUndeploy(deployer, deploymentA);
        this.assertLoadClassIllegal(clA, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        this.assertUndeploy(deployer, deploymentB);
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
    }

    public void testADependsUponModuleBRedeployA() throws Exception {
        DeployerClient deployer = this.getMainDeployer();
        Deployment deploymentA = this.createSimpleDeployment(NameA);
        ClassLoaderMetaData classLoaderMetaData = MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentA, null, A.class);
        MockClassLoaderDependenciesUnitTestCase.addRequireModule(classLoaderMetaData, NameB, null);
        DeploymentUnit unitA = this.addDeployment(deployer, deploymentA);
        this.assertNoClassLoader(unitA);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        Deployment deploymentB = this.createSimpleDeployment(NameB);
        MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentB, null, B.class);
        DeploymentUnit unitB = this.assertDeploy(deployer, deploymentB);
        ClassLoader clB = unitB.getClassLoader();
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        ClassLoader clA = unitA.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        this.assertUndeploy(deployer, deploymentA);
        this.assertLoadClassIllegal(clA, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        unitA = this.assertDeploy(deployer, deploymentA);
        clA = unitA.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BAA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(A, this.deployer2.undeployed);
    }

    public void testADependsUponModuleBRedeployB() throws Exception {
        DeployerClient deployer = this.getMainDeployer();
        Deployment deploymentA = this.createSimpleDeployment(NameA);
        ClassLoaderMetaData classLoaderMetaData = MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentA, null, A.class);
        MockClassLoaderDependenciesUnitTestCase.addRequireModule(classLoaderMetaData, NameB, null);
        DeploymentUnit unitA = this.addDeployment(deployer, deploymentA);
        this.assertNoClassLoader(unitA);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        Deployment deploymentB = this.createSimpleDeployment(NameB);
        MockClassLoaderDependenciesUnitTestCase.addMetaData(deploymentB, null, B.class);
        DeploymentUnit unitB = this.assertDeploy(deployer, deploymentB);
        ClassLoader clB = unitB.getClassLoader();
        this.assertLoadClass(clB, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        ClassLoader clA = unitA.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        this.enableTrace("org.jboss.deployers");
        this.enableTrace("org.jboss.dependency");
        this.assertUndeploy(deployer, deploymentB);
        this.assertLoadClassIllegal(clA, B.class);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
        unitB = this.assertDeploy(deployer, deploymentB);
        clA = unitA.getClassLoader();
        clB = unitB.getClassLoader();
        this.assertLoadClass(clA, B.class, clB);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(BABA, this.deployer2.deployed);
        MockClassLoaderDependenciesUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
    }

    protected Class assertLoadClass(ClassLoader start, Class reference) throws Exception {
        return this.assertLoadClass(start, reference, start);
    }

    protected Class assertLoadClass(ClassLoader start, Class reference, ClassLoader expected) throws Exception {
        Class<?> clazz = start.loadClass(reference.getName());
        if (expected != null) {
            MockClassLoaderDependenciesUnitTestCase.assertEquals((Object)expected, (Object)clazz.getClassLoader());
        }
        return clazz;
    }

    protected void assertLoadClassFail(ClassLoader start, Class reference) throws Exception {
        try {
            start.loadClass(reference.getName());
            MockClassLoaderDependenciesUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            MockClassLoaderDependenciesUnitTestCase.checkThrowable(ClassNotFoundException.class, (Throwable)e);
        }
    }

    protected void assertLoadClassIllegal(ClassLoader start, Class reference) throws Exception {
        try {
            start.loadClass(reference.getName());
            MockClassLoaderDependenciesUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            MockClassLoaderDependenciesUnitTestCase.checkThrowable(IllegalStateException.class, (Throwable)e);
        }
    }

    protected void assertNoClassLoader(DeploymentUnit unit) throws Exception {
        try {
            unit.getClassLoader();
            MockClassLoaderDependenciesUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            MockClassLoaderDependenciesUnitTestCase.checkThrowable(IllegalStateException.class, (Throwable)e);
        }
    }

    protected static ClassLoaderMetaData addMetaData(Deployment deployment, Version version, Class ... packages) {
        ClassLoaderMetaData classLoaderMetaData = MockClassLoaderDependenciesUnitTestCase.createMetaData(deployment, version, packages);
        MockClassLoaderDependenciesUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, classLoaderMetaData);
        return classLoaderMetaData;
    }

    protected static ClassLoaderMetaData createMetaData(Deployment deployment, Version version, Class ... packages) {
        ClassLoaderMetaData classLoaderMetaData = new ClassLoaderMetaData();
        classLoaderMetaData.setName(deployment.getName());
        ArrayList<ModuleCapabilityImpl> capabilities = new ArrayList<ModuleCapabilityImpl>();
        ModuleCapabilityImpl capability = new ModuleCapabilityImpl(deployment.getName(), version);
        capabilities.add(capability);
        if (packages != null) {
            for (Class pkg : packages) {
                capability = new PackageCapabilityImpl(pkg.getName());
                capabilities.add(capability);
            }
        }
        classLoaderMetaData.setCapabilities(capabilities);
        return classLoaderMetaData;
    }

    protected static void addRequireModule(ClassLoaderMetaData classLoaderMetaData, String moduleName, VersionRange versionRange) {
        ArrayList<RequireModuleImpl> requirements = classLoaderMetaData.getRequirements();
        if (requirements == null) {
            requirements = new ArrayList<RequireModuleImpl>();
            classLoaderMetaData.setRequirements(requirements);
        }
        RequireModuleImpl requirement = new RequireModuleImpl(moduleName, versionRange);
        requirements.add(requirement);
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, ClassLoaderMetaData md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(ClassLoaderMetaData.class, (Object)md);
    }

    protected DeployerClient getMainDeployer() {
        ClassLoading classLoading = new ClassLoading();
        DefaultClassLoaderSystem system = new DefaultClassLoaderSystem();
        system.getDefaultDomain().setParentPolicy(ParentPolicy.BEFORE_BUT_JAVA_ONLY);
        this.deployer1 = new AbstractClassLoaderDesribeDeployer();
        this.deployer1.setClassLoading(classLoading);
        this.deployer2 = new MockTopLevelClassLoaderSystemDeployer();
        this.deployer2.setClassLoading(classLoading);
        this.deployer2.setSystem((ClassLoaderSystem)system);
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2});
    }
}

