/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.support;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.deployer.support.TestComponentMetaData;
import org.jboss.test.deployers.deployer.support.TestComponentMetaDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestComponentDeployer
extends AbstractComponentDeployer<TestComponentMetaDataContainer, TestComponentMetaData> {
    public TestComponentDeployer(int order) {
        this.setDeploymentVisitor(new TestComponentMetaDataContainerVisitor());
        this.setComponentVisitor(new TestComponentMetaDataVisitor());
        this.setRelativeOrder(order);
    }

    protected static void addTestComponent(DeploymentUnit unit, TestComponentMetaData test) {
        DeploymentUnit component = unit.addComponent(test.name);
        component.addAttachment(TestComponentMetaData.class, (Object)test);
    }

    protected static void removeTestComponent(DeploymentUnit unit, TestComponentMetaData test) {
        unit.removeComponent(test.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestComponentMetaDataVisitor
    implements DeploymentVisitor<TestComponentMetaData> {
        public Class<TestComponentMetaData> getVisitorType() {
            return TestComponentMetaData.class;
        }

        public void deploy(DeploymentUnit unit, TestComponentMetaData deployment) throws DeploymentException {
            TestComponentDeployer.addTestComponent(unit, deployment);
        }

        public void undeploy(DeploymentUnit unit, TestComponentMetaData deployment) {
            TestComponentDeployer.removeTestComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestComponentMetaDataContainerVisitor
    implements DeploymentVisitor<TestComponentMetaDataContainer> {
        public Class<TestComponentMetaDataContainer> getVisitorType() {
            return TestComponentMetaDataContainer.class;
        }

        public void deploy(DeploymentUnit unit, TestComponentMetaDataContainer deployment) throws DeploymentException {
            try {
                List<TestComponentMetaData> tests = deployment.componentMetaData;
                if (tests == null || tests.isEmpty()) {
                    return;
                }
                for (TestComponentMetaData test : tests) {
                    TestComponentDeployer.addTestComponent(unit, test);
                }
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment), (Throwable)t);
            }
        }

        public void undeploy(DeploymentUnit unit, TestComponentMetaDataContainer deployment) {
            List<TestComponentMetaData> tests = deployment.componentMetaData;
            if (tests == null) {
                return;
            }
            for (TestComponentMetaData test : tests) {
                unit.removeComponent(test.name);
            }
        }
    }
}

