/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.support;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.deployer.support.TestDeployment1;
import org.jboss.test.deployers.deployer.support.TestMetaData1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDeploymentDeployer1
extends AbstractComponentDeployer<TestDeployment1, TestMetaData1> {
    public TestDeploymentDeployer1() {
        this.setDeploymentVisitor(new TestDeploymentVisitor());
        this.setComponentVisitor(new TestMetaDataVisitor());
    }

    protected static void addTestComponent(DeploymentUnit unit, TestMetaData1 test) {
        DeploymentUnit component = unit.addComponent(test.getName());
        component.addAttachment(TestMetaData1.class, (Object)test);
    }

    protected static void removeTestComponent(DeploymentUnit unit, TestMetaData1 test) {
        unit.removeComponent(test.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestMetaDataVisitor
    implements DeploymentVisitor<TestMetaData1> {
        public Class<TestMetaData1> getVisitorType() {
            return TestMetaData1.class;
        }

        public void deploy(DeploymentUnit unit, TestMetaData1 deployment) throws DeploymentException {
            TestDeploymentDeployer1.addTestComponent(unit, deployment);
        }

        public void undeploy(DeploymentUnit unit, TestMetaData1 deployment) {
            TestDeploymentDeployer1.removeTestComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestDeploymentVisitor
    implements DeploymentVisitor<TestDeployment1> {
        public Class<TestDeployment1> getVisitorType() {
            return TestDeployment1.class;
        }

        public void deploy(DeploymentUnit unit, TestDeployment1 deployment) throws DeploymentException {
            try {
                List<TestMetaData1> tests = deployment.getBeans();
                if (tests == null || tests.isEmpty()) {
                    return;
                }
                for (TestMetaData1 test : tests) {
                    TestDeploymentDeployer1.addTestComponent(unit, test);
                }
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment), (Throwable)t);
            }
        }

        public void undeploy(DeploymentUnit unit, TestDeployment1 deployment) {
            List<TestMetaData1> tests = deployment.getBeans();
            if (tests == null) {
                return;
            }
            for (TestMetaData1 test : tests) {
                unit.removeComponent(test.getName());
            }
        }
    }
}

