/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.support;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.deployer.support.TestDeployment2;
import org.jboss.test.deployers.deployer.support.TestMetaData2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDeploymentDeployer2
extends AbstractComponentDeployer<TestDeployment2, TestMetaData2> {
    public TestDeploymentDeployer2() {
        this.setDeploymentVisitor(new TestDeploymentVisitor());
        this.setComponentVisitor(new TestMetaDataVisitor());
    }

    protected static void addTestComponent(DeploymentUnit unit, TestMetaData2 test) {
        DeploymentUnit component = unit.addComponent(test.getName());
        component.addAttachment(TestMetaData2.class, (Object)test);
    }

    protected static void removeTestComponent(DeploymentUnit unit, TestMetaData2 test) {
        unit.removeComponent(test.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestMetaDataVisitor
    implements DeploymentVisitor<TestMetaData2> {
        public Class<TestMetaData2> getVisitorType() {
            return TestMetaData2.class;
        }

        public void deploy(DeploymentUnit unit, TestMetaData2 deployment) throws DeploymentException {
            TestDeploymentDeployer2.addTestComponent(unit, deployment);
        }

        public void undeploy(DeploymentUnit unit, TestMetaData2 deployment) {
            TestDeploymentDeployer2.removeTestComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestDeploymentVisitor
    implements DeploymentVisitor<TestDeployment2> {
        public Class<TestDeployment2> getVisitorType() {
            return TestDeployment2.class;
        }

        public void deploy(DeploymentUnit unit, TestDeployment2 deployment) throws DeploymentException {
            try {
                List<TestMetaData2> tests = deployment.getBeans();
                if (tests == null || tests.isEmpty()) {
                    return;
                }
                for (TestMetaData2 test : tests) {
                    TestDeploymentDeployer2.addTestComponent(unit, test);
                }
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment), (Throwable)t);
            }
        }

        public void undeploy(DeploymentUnit unit, TestDeployment2 deployment) {
            List<TestMetaData2> tests = deployment.getBeans();
            if (tests == null) {
                return;
            }
            for (TestMetaData2 test : tests) {
                unit.removeComponent(test.getName());
            }
        }
    }
}

