/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFlowDeployer
extends AbstractRealDeployer {
    private static int order = 0;
    private Map<String, Integer> deployed = new HashMap<String, Integer>();
    private Map<String, Integer> undeployed = new HashMap<String, Integer>();
    private String name;

    public static void reset() {
        order = 0;
    }

    public TestFlowDeployer(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void clear() {
        this.deployed.clear();
        this.undeployed.clear();
    }

    public int getDeployOrder() {
        if (this.deployed.isEmpty()) {
            return -1;
        }
        return Collections.max(this.deployed.values());
    }

    public int getUndeployOrder() {
        if (this.undeployed.isEmpty()) {
            return -1;
        }
        return Collections.max(this.undeployed.values());
    }

    public Set<String> getDeployedUnits() {
        return this.deployed.keySet();
    }

    public Set<String> getUndeployedUnits() {
        return this.undeployed.keySet();
    }

    public Map<String, Integer> getDeployed() {
        return this.deployed;
    }

    public Map<String, Integer> getUndeployed() {
        return this.undeployed;
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        unit.getTypes().add(this.getType());
        this.deployed.put(unit.getName(), ++order);
    }

    public void internalUndeploy(DeploymentUnit unit) {
        this.undeployed.put(unit.getName(), ++order);
    }
}

