/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestClassLoaderDeployer;

public class DeployerClassLoaderUnitTestCase
extends AbstractDeployerTest {
    public static Test suite() {
        return new TestSuite(DeployerClassLoaderUnitTestCase.class);
    }

    public DeployerClassLoaderUnitTestCase(String name) {
        super(name);
    }

    public void testClassLoader() throws Exception {
        TestClassLoaderDeployer deployer = new TestClassLoaderDeployer();
        DeployerClient main = this.createMainDeployer(new Deployer[]{deployer});
        Deployment deployment = this.createSimpleDeployment("single");
        main.addDeployment(deployment);
        main.process();
        DeploymentContext context = this.assertDeploymentContext(main, "single");
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)context.getState());
        DeployerClassLoaderUnitTestCase.assertEquals((Object)deployer.cl, (Object)context.getClassLoader());
        main.removeDeployment(deployment);
        main.process();
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)context.getState());
        DeployerClassLoaderUnitTestCase.assertNull((Object)context.getClassLoader());
    }

    public void testSubdeploymentClassLoader() throws Exception {
        TestClassLoaderDeployer deployer = new TestClassLoaderDeployer();
        DeployerClient main = this.createMainDeployer(new Deployer[]{deployer});
        Deployment deployment = this.createSimpleDeployment("top");
        DeploymentFactory factory = new DeploymentFactory();
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "sub");
        main.addDeployment(deployment);
        main.process();
        DeploymentContext top = this.assertDeploymentContext(main, "top");
        DeploymentContext sub = this.assertDeploymentContext(main, "top/sub");
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)top.getState());
        DeployerClassLoaderUnitTestCase.assertEquals((Object)deployer.cl, (Object)top.getClassLoader());
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)sub.getState());
        DeployerClassLoaderUnitTestCase.assertEquals((Object)deployer.cl, (Object)sub.getClassLoader());
        main.removeDeployment(deployment);
        main.process();
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)top.getState());
        DeployerClassLoaderUnitTestCase.assertNull((Object)top.getClassLoader());
        DeployerClassLoaderUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)sub.getState());
        DeployerClassLoaderUnitTestCase.assertNull((Object)sub.getClassLoader());
    }
}

