/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestDependencyMetaData;
import org.jboss.test.deployers.deployer.support.TestDescribeDeployer;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerDependencyUnitTestCase
extends AbstractDeployerTest {
    private static final DeploymentFactory factory = new DeploymentFactory();
    private TestDescribeDeployer deployer1 = new TestDescribeDeployer();
    private TestSimpleDeployer3 deployer2 = new TestSimpleDeployer3(DeploymentStages.CLASSLOADER);
    private TestSimpleDeployer3 deployer3 = new TestSimpleDeployer3(DeploymentStages.INSTALLED);
    public static List<String> NONE = Collections.emptyList();
    public static List<String> A = DeployerDependencyUnitTestCase.makeList("A");
    public static List<String> B = DeployerDependencyUnitTestCase.makeList("B");
    public static List<String> AB = DeployerDependencyUnitTestCase.makeList("A", "B");
    public static List<String> BA = DeployerDependencyUnitTestCase.makeList("B", "A");
    public static List<String> ABA = DeployerDependencyUnitTestCase.makeList("A", "B", "A");
    public static List<String> ABB = DeployerDependencyUnitTestCase.makeList("A", "B", "B");
    public static List<String> BAA = DeployerDependencyUnitTestCase.makeList("B", "A", "A");
    public static List<String> BABA = DeployerDependencyUnitTestCase.makeList("B", "A", "B", "A");
    public static List<String> AC = DeployerDependencyUnitTestCase.makeList("A", "A/C");
    public static List<String> ACB = DeployerDependencyUnitTestCase.makeList("A", "A/C", "B");
    public static List<String> BAC = DeployerDependencyUnitTestCase.makeList("B", "A", "A/C");
    public static List<String> CAB = DeployerDependencyUnitTestCase.makeList("A/C", "A", "B");
    public static List<String> BCA = DeployerDependencyUnitTestCase.makeList("B", "A/C", "A");

    private static <T> List<T> makeList(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(DeployerDependencyUnitTestCase.class);
    }

    public DeployerDependencyUnitTestCase(String name) {
        super(name);
    }

    public void testADependsOnBAtClassLoaderCorrectOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderWrongOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderUndeployANoB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderUndeployB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderRedeployB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(b);
        main.process();
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ABB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BABA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BABA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderRedeployA() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(a);
        main.process();
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ABA, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer3.undeployed);
    }

    public void testADependsOnBAtClassLoaderWhichFailsInInstall() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        DeployerDependencyUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)b, (Deployer)this.deployer3);
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallCorrectOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallWrongOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallUndeployANoB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallUndeployB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallRedeployB() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(b);
        main.process();
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ABB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(ABB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BABA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallRedeployA() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(a);
        main.process();
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ABA, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(ABA, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAA, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(A, this.deployer3.undeployed);
    }

    public void testADependsOnBAtInstallWhichFailsInInstall() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestDependencyMetaData depA = new TestDependencyMetaData("A");
        depA.addDependencyItem("B", DeploymentStages.INSTALLED);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, depA);
        main.addDeployment(a);
        Deployment b = this.createSimpleDeployment("B");
        DeployerDependencyUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)b, (Deployer)this.deployer3);
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(AB, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
    }

    public void testChildOfADependsOnBAtClassLoaderWrongOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        ContextInfo c = factory.addContext((PredeterminedManagedObjectAttachments)a, "C");
        TestDependencyMetaData depC = new TestDependencyMetaData("A");
        depC.addDependencyItem("B", DeploymentStages.CLASSLOADER);
        DeployerDependencyUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)c, depC);
        main.addDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(AC, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        Deployment b = this.createSimpleDeployment("B");
        main.addDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ACB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(NONE, this.deployer3.undeployed);
        main.removeDeployment(b);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ACB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(B, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(CAB, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(CAB, this.deployer3.undeployed);
        main.removeDeployment(a);
        main.process();
        DeployerDependencyUnitTestCase.assertEquals(ACB, this.deployer1.deployed);
        DeployerDependencyUnitTestCase.assertEquals(BCA, this.deployer1.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer2.deployed);
        DeployerDependencyUnitTestCase.assertEquals(CAB, this.deployer2.undeployed);
        DeployerDependencyUnitTestCase.assertEquals(BAC, this.deployer3.deployed);
        DeployerDependencyUnitTestCase.assertEquals(CAB, this.deployer3.undeployed);
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, TestDependencyMetaData md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(TestDependencyMetaData.class, (Object)md);
    }

    protected static void makeFail(PredeterminedManagedObjectAttachments attachments, Deployer deployer) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment("fail", (Object)deployer);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2, this.deployer3});
    }
}

