/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestFlowDeployer;

public class DeployerFlowUnitTestCase
extends AbstractDeployerTest {
    public static Test suite() {
        return new TestSuite(DeployerFlowUnitTestCase.class);
    }

    public DeployerFlowUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestFlowDeployer.reset();
    }

    public void testSimpleInputOutputCorrectOrder() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("correctOrder");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
    }

    public void testSimpleInputOutputWrongOrder() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("wrongOrder");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
    }

    public void testInputOutputLoop() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setInputs(new String[]{"input1"});
        deployer1.setOutputs(new String[]{"output1"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"output1"});
        deployer2.setOutputs(new String[]{"output2"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"output2"});
        deployer3.setOutputs(new String[]{"input1"});
        try {
            this.addDeployer(main, (Deployer)deployer3);
            DeployerFlowUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            DeployerFlowUnitTestCase.checkThrowable(IllegalStateException.class, (Throwable)t);
        }
    }

    public void testInputOutputTransient() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test"});
        deployer2.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("transient");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
    }

    public void testInputOutputTransient2() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setInputs(new String[]{"test"});
        deployer1.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("transient2");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
    }

    public void testInputOutputMultipleTransient() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer4 = new TestFlowDeployer("4");
        deployer4.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer4);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test"});
        deployer2.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"test"});
        deployer3.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("transient");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer4.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getUndeployOrder());
    }

    public void testMultipleOutput() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test1", "test2"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer3);
        Deployment deployment = this.createSimpleDeployment("MultipleOutput");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
    }

    public void testMultipleInput() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"test1", "test2"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setOutputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("MultipleInput");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
    }

    public void testChain() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"test1"});
        deployer2.setOutputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("Chain");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
    }

    public void testComplicated() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer6 = new TestFlowDeployer("6");
        deployer6.setInputs(new String[]{"test1", "test3"});
        this.addDeployer(main, (Deployer)deployer6);
        TestFlowDeployer deployer5 = new TestFlowDeployer("5");
        deployer5.setInputs(new String[]{"test3"});
        deployer5.setOutputs(new String[]{"test3"});
        this.addDeployer(main, (Deployer)deployer5);
        TestFlowDeployer deployer4 = new TestFlowDeployer("4");
        deployer4.setInputs(new String[]{"test2"});
        deployer4.setOutputs(new String[]{"test3"});
        this.addDeployer(main, (Deployer)deployer4);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setOutputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("Complicated");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer6.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer6.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)13, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)14, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)15, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)16, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)17, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)18, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer6.getUndeployOrder());
    }

    public void testIntermediateIsRelativelySorted() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer2 = new TestFlowDeployer("A");
        deployer2.setInputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("B");
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer1 = new TestFlowDeployer("C");
        deployer1.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("IntermediateIsRelativelySorted");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer3.getUndeployOrder());
    }

    public void testTransitionOrdering() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("A");
        deployer1.setInputs(new String[]{"3"});
        deployer1.setOutputs(new String[]{"4"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("B");
        deployer2.setInputs(new String[]{"1"});
        deployer2.setOutputs(new String[]{"2"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("C");
        deployer3.setInputs(new String[]{"2"});
        deployer3.setOutputs(new String[]{"3"});
        this.addDeployer(main, (Deployer)deployer3);
        Deployment deployment = this.createSimpleDeployment("TransitionOrdering");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer3.getUndeployOrder());
    }

    public void testSymetricDots() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setInputs(new String[]{"X"});
        deployer1.setOutputs(new String[]{"B"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setInputs(new String[]{"X"});
        deployer2.setOutputs(new String[]{"X"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setInputs(new String[]{"A"});
        deployer3.setOutputs(new String[]{"X"});
        this.addDeployer(main, (Deployer)deployer3);
        Deployment deployment = this.createSimpleDeployment("SymetricDots");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
    }

    public void testDoubleCycle() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer2 = new TestFlowDeployer("A");
        deployer2.setInputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer3 = new TestFlowDeployer("B");
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer6 = new TestFlowDeployer("C");
        deployer6.setInputs(new String[]{"2ndcycle"});
        this.addDeployer(main, (Deployer)deployer6);
        TestFlowDeployer deployer1 = new TestFlowDeployer("D");
        deployer1.setOutputs(new String[]{"test1"});
        this.addDeployer(main, (Deployer)deployer1);
        TestFlowDeployer deployer4 = new TestFlowDeployer("E");
        this.addDeployer(main, (Deployer)deployer4);
        TestFlowDeployer deployer5 = new TestFlowDeployer("F");
        deployer5.setInputs(new String[]{"test1"});
        deployer5.setOutputs(new String[]{"test2"});
        this.addDeployer(main, (Deployer)deployer5);
        TestFlowDeployer deployer7 = new TestFlowDeployer("G");
        this.addDeployer(main, (Deployer)deployer7);
        TestFlowDeployer deployer8 = new TestFlowDeployer("H");
        deployer8.setOutputs(new String[]{"2ndcycle"});
        this.addDeployer(main, (Deployer)deployer8);
        Deployment deployment = this.createSimpleDeployment("DoubleCycle");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer8.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer7.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer8.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer6.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer7.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer8.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer7.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)16, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)15, (int)deployer8.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)14, (int)deployer6.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)13, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer7.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)17, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)18, (int)deployer8.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)19, (int)deployer6.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)20, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)21, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)22, (int)deployer5.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)23, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)24, (int)deployer7.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)16, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)15, (int)deployer8.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)14, (int)deployer6.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)13, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer4.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer5.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer7.getUndeployOrder());
    }

    public void testOrderedThenFlowWithPassThrough() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestFlowDeployer deployer4 = new TestFlowDeployer("4");
        deployer4.setInputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer4);
        TestFlowDeployer deployer3 = new TestFlowDeployer("3");
        deployer3.setRelativeOrder(3);
        deployer3.setInputs(new String[]{"test"});
        deployer3.setOutputs(new String[]{"test"});
        this.addDeployer(main, (Deployer)deployer3);
        TestFlowDeployer deployer2 = new TestFlowDeployer("2");
        deployer2.setRelativeOrder(2);
        this.addDeployer(main, (Deployer)deployer2);
        TestFlowDeployer deployer1 = new TestFlowDeployer("1");
        deployer1.setRelativeOrder(1);
        this.addDeployer(main, (Deployer)deployer1);
        Deployment deployment = this.createSimpleDeployment("orderedThenFlowWithPassThrough");
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)-1, (int)deployer4.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)3, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)4, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerFlowUnitTestCase.assertEquals((int)9, (int)deployer1.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)10, (int)deployer2.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)11, (int)deployer3.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)12, (int)deployer4.getDeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)8, (int)deployer1.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)7, (int)deployer2.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)6, (int)deployer3.getUndeployOrder());
        DeployerFlowUnitTestCase.assertEquals((int)5, (int)deployer4.getUndeployOrder());
    }
}

