/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer;

public class DeployerOrderingUnitTestCase
extends AbstractDeployerTest {
    public static Test suite() {
        return new TestSuite(DeployerOrderingUnitTestCase.class);
    }

    public DeployerOrderingUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestSimpleDeployer.reset();
    }

    public void testCorrectOrder() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestSimpleDeployer deployer1 = new TestSimpleDeployer(1);
        this.addDeployer(main, (Deployer)deployer1);
        TestSimpleDeployer deployer2 = new TestSimpleDeployer(2);
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("correctOrder");
        main.addDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)5, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)6, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
    }

    public void testWrongOrder() throws Exception {
        DeployerClient main = this.createMainDeployer();
        TestSimpleDeployer deployer1 = new TestSimpleDeployer(1);
        this.addDeployer(main, (Deployer)deployer1);
        TestSimpleDeployer deployer2 = new TestSimpleDeployer(2);
        this.addDeployer(main, (Deployer)deployer2);
        Deployment deployment = this.createSimpleDeployment("wrongOrder");
        main.addDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)-1, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)-1, (int)deployer2.getUndeployOrder());
        main.removeDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)1, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)2, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
        main.addDeployment(deployment);
        main.process();
        DeployerOrderingUnitTestCase.assertEquals((int)5, (int)deployer1.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)6, (int)deployer2.getDeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)4, (int)deployer1.getUndeployOrder());
        DeployerOrderingUnitTestCase.assertEquals((int)3, (int)deployer2.getUndeployOrder());
    }
}

