/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer;

public class DeployerProtocolUnitTestCase
extends AbstractDeployerTest {
    private TestSimpleDeployer deployer = new TestSimpleDeployer();

    public static Test suite() {
        return new TestSuite(DeployerProtocolUnitTestCase.class);
    }

    public DeployerProtocolUnitTestCase(String name) {
        super(name);
    }

    public void testDeploy() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("deploy");
        main.addDeployment(context);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(context.getName());
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        HashSet<String> types = new HashSet<String>();
        types.add("test");
    }

    public void testUndeploy() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("undeploy");
        main.addDeployment(context);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(context.getName());
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.removeDeployment(context.getName());
        main.process();
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testRedeploy() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("redeploy");
        main.addDeployment(context);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(context.getName());
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.removeDeployment(context.getName());
        main.process();
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
        this.deployer.clear();
        main.addDeployment(context);
        main.process();
        expected.clear();
        expected.add(context.getName());
        DeployerProtocolUnitTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer});
    }
}

