/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer;

public class DeployerWidthFirstUnitTestCase
extends AbstractDeployerTest {
    private TestSimpleDeployer deployer1 = new TestSimpleDeployer(1);
    private TestSimpleDeployer deployer2 = new TestSimpleDeployer(2);

    public static Test suite() {
        return new TestSuite(DeployerWidthFirstUnitTestCase.class);
    }

    public DeployerWidthFirstUnitTestCase(String name) {
        super(name);
    }

    public void testDeployWidthFirst() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context1 = this.createSimpleDeployment("deploy1");
        main.addDeployment(context1);
        Deployment context2 = this.createSimpleDeployment("deploy2");
        main.addDeployment(context2);
        main.process();
        Map<String, Integer> deployed1 = this.deployer1.getDeployed();
        Map<String, Integer> deployed2 = this.deployer2.getDeployed();
        int c1d1 = deployed1.get(context1.getName());
        int c1d2 = deployed2.get(context1.getName());
        int c2d1 = deployed1.get(context2.getName());
        int c2d2 = deployed2.get(context2.getName());
        DeployerWidthFirstUnitTestCase.assertFalse((c1d1 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c1d2 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c2d1 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c2d2 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertTrue((String)"Deployer1 should be before Deployer2", (c1d1 < c1d2 && c1d1 < c2d2 && c2d1 < c1d2 && c2d1 < c2d2 ? 1 : 0) != 0);
    }

    public void testUndeployWidthFirst() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context1 = this.createSimpleDeployment("deploy1");
        main.addDeployment(context1);
        Deployment context2 = this.createSimpleDeployment("deploy2");
        main.addDeployment(context2);
        main.process();
        main.removeDeployment(context1.getName());
        main.removeDeployment(context2.getName());
        main.process();
        Map<String, Integer> undeployed1 = this.deployer1.getUndeployed();
        Map<String, Integer> undeployed2 = this.deployer2.getUndeployed();
        int c1d1 = undeployed1.get(context1.getName());
        int c1d2 = undeployed2.get(context1.getName());
        int c2d1 = undeployed1.get(context2.getName());
        int c2d2 = undeployed2.get(context2.getName());
        DeployerWidthFirstUnitTestCase.assertFalse((c1d1 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c1d2 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c2d1 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertFalse((c2d2 == -1 ? 1 : 0) != 0);
        DeployerWidthFirstUnitTestCase.assertTrue((String)"Deployer2 should be before Deployer1", (c1d2 < c1d1 && c1d2 < c2d1 && c2d2 < c1d1 && c2d2 < c2d1 ? 1 : 0) != 0);
    }

    protected DeployerClient getMainDeployer() {
        this.deployer1 = new TestSimpleDeployer(DeploymentStages.POST_CLASSLOADER);
        this.deployer2 = new TestSimpleDeployer(DeploymentStages.REAL);
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2});
    }
}

