/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer;

public class DeployersImplUnitTestCase
extends AbstractDeployerTest {
    public static Test suite() {
        return new TestSuite(DeployersImplUnitTestCase.class);
    }

    public DeployersImplUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAddNullDeployer() throws Exception {
        DeployerClient main = this.createMainDeployer();
        try {
            this.addDeployer(main, null);
            DeployersImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            DeployersImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testAddDeployers() throws Exception {
        DeployerClient main = this.createMainDeployer();
        this.assertEmpty(this.getDeployers(main));
        TestSimpleDeployer deployer = new TestSimpleDeployer();
        HashSet<TestSimpleDeployer> expected = new HashSet<TestSimpleDeployer>();
        expected.add(deployer);
        this.addDeployer(main, (Deployer)deployer);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        deployer = new TestSimpleDeployer();
        expected.add(deployer);
        this.addDeployer(main, (Deployer)deployer);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        this.addDeployer(main, (Deployer)deployer);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
    }

    public void testRemoveNullDeployer() throws Exception {
        DeployerClient main = this.createMainDeployer();
        try {
            this.removeDeployer(main, null);
            DeployersImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            DeployersImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testRemoveDeployers() throws Exception {
        DeployerClient main = this.createMainDeployer();
        this.assertEmpty(this.getDeployers(main));
        TestSimpleDeployer deployer1 = new TestSimpleDeployer("1");
        TestSimpleDeployer deployer2 = new TestSimpleDeployer("2");
        HashSet<TestSimpleDeployer> expected = new HashSet<TestSimpleDeployer>();
        expected.add(deployer1);
        expected.add(deployer2);
        this.addDeployer(main, (Deployer)deployer1);
        this.addDeployer(main, (Deployer)deployer2);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        TestSimpleDeployer notPresent = new TestSimpleDeployer();
        this.removeDeployer(main, (Deployer)notPresent);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        this.removeDeployer(main, (Deployer)deployer1);
        expected.remove((Object)deployer1);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        this.removeDeployer(main, (Deployer)deployer2);
        expected.remove((Object)deployer2);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
    }

    public void testSetNullDeployers() throws Exception {
        DeployerClient main = this.createMainDeployer();
        try {
            this.setDeployers(main, null);
            DeployersImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            DeployersImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testSetDeployers() throws Exception {
        DeployerClient main = this.createMainDeployer();
        this.assertEmpty(this.getDeployers(main));
        TestSimpleDeployer deployer1 = new TestSimpleDeployer();
        TestSimpleDeployer deployer2 = new TestSimpleDeployer();
        Set<Object> expected = new HashSet<Deployer>();
        expected.add((Deployer)deployer1);
        expected.add((Deployer)deployer2);
        this.setDeployers(main, expected);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        expected = new HashSet();
        expected.add((Deployer)deployer1);
        this.setDeployers(main, expected);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        expected = new HashSet();
        expected.add((Deployer)deployer1);
        this.setDeployers(main, expected);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
        expected = Collections.emptySet();
        this.setDeployers(main, expected);
        DeployersImplUnitTestCase.assertEquals(expected, this.getDeployers(main));
    }
}

