/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestComponentDeployer;
import org.jboss.test.deployers.deployer.support.TestComponentMetaData;
import org.jboss.test.deployers.deployer.support.TestComponentMetaDataContainer;
import org.jboss.test.deployers.deployer.support.TestComponentRealDeployer;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicAllOrNothingUnitTestCase
extends AbstractDeployerTest {
    private TestSimpleDeployer deployer1 = new TestSimpleDeployer(1);
    private TestSimpleDeployer deployer2 = new TestSimpleDeployer(2);
    private TestComponentDeployer deployer3 = new TestComponentDeployer(3);
    private TestComponentRealDeployer deployer4 = new TestComponentRealDeployer(4);
    private static String parentName = "parent";
    private static String childPath = "child";
    private static String childName = parentName + "/" + childPath;
    private static String child1Path = "child1";
    private static String child1Name = parentName + "/" + child1Path;
    private static String child2Path = "child2";
    private static String child2Name = parentName + "/" + child2Path;
    private static Set<String> expectedNothing = Collections.emptySet();
    private static Set<String> expectedParent = HeuristicAllOrNothingUnitTestCase.makeSet(parentName);
    private static Set<String> expectedParentChild = HeuristicAllOrNothingUnitTestCase.makeSet(parentName, childName);
    private static Set<String> expectedParentChild1 = HeuristicAllOrNothingUnitTestCase.makeSet(parentName, child1Name);
    private static Set<String> expectedParentChild1Child2 = HeuristicAllOrNothingUnitTestCase.makeSet(parentName, child1Name, child2Name);
    private static TestComponentMetaData parentmd1 = new TestComponentMetaData(parentName + ".1", false);
    private static TestComponentMetaData parentmd1fail = new TestComponentMetaData(parentName + ".1", true);
    private static TestComponentMetaData parentmd2 = new TestComponentMetaData(parentName + ".2", false);
    private static TestComponentMetaData parentmd2fail = new TestComponentMetaData(parentName + ".2", true);
    private static TestComponentMetaData child1md1 = new TestComponentMetaData(child1Name + ".1", false);
    private static TestComponentMetaData child1md1fail = new TestComponentMetaData(child1Name + ".1", true);
    private static TestComponentMetaData child1md2 = new TestComponentMetaData(child1Name + ".2", false);
    private static TestComponentMetaData child1md2fail = new TestComponentMetaData(child1Name + ".2", true);
    private static TestComponentMetaData child2md1 = new TestComponentMetaData(child2Name + ".1", false);
    private static TestComponentMetaData child2md1fail = new TestComponentMetaData(child2Name + ".1", true);
    private static TestComponentMetaData child2md2 = new TestComponentMetaData(child2Name + ".2", false);
    private static TestComponentMetaData child2md2fail = new TestComponentMetaData(child2Name + ".2", true);
    private static TestComponentMetaDataContainer parentmd = new TestComponentMetaDataContainer(parentmd1, parentmd2);
    private static TestComponentMetaDataContainer parentmdfail1 = new TestComponentMetaDataContainer(parentmd1fail, parentmd2);
    private static TestComponentMetaDataContainer parentmdfail2 = new TestComponentMetaDataContainer(parentmd1, parentmd2fail);
    private static TestComponentMetaDataContainer child1md = new TestComponentMetaDataContainer(child1md1, child1md2);
    private static TestComponentMetaDataContainer child1mdfail1 = new TestComponentMetaDataContainer(child1md1fail, child1md2);
    private static TestComponentMetaDataContainer child1mdfail2 = new TestComponentMetaDataContainer(child1md1, child1md2fail);
    private static TestComponentMetaDataContainer child2md = new TestComponentMetaDataContainer(child2md1, child2md2);
    private static TestComponentMetaDataContainer child2mdfail1 = new TestComponentMetaDataContainer(child2md1fail, child2md2);
    private static TestComponentMetaDataContainer child2mdfail2 = new TestComponentMetaDataContainer(child2md1, child2md2fail);
    private static Set<TestComponentMetaData> expectedNone = Collections.emptySet();
    private static Set<TestComponentMetaData> expectedPmd1Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1fail);
    private static Set<TestComponentMetaData> expectedPmd1 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2fail);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1fail);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2fail);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2C2md1Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2, child2md1fail);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2C2md1 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2, child2md1);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2C2md1C2md2Fail = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2, child2md1, child2md2fail);
    private static Set<TestComponentMetaData> expectedPmd1Pmd2C1md1C1md2C2md1C2md2 = HeuristicAllOrNothingUnitTestCase.makeSet(parentmd1, parentmd2, child1md1, child1md2, child2md1, child2md2);

    private static <T> Set<T> makeSet(T ... objects) {
        HashSet<T> result = new HashSet<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(HeuristicAllOrNothingUnitTestCase.class);
    }

    public HeuristicAllOrNothingUnitTestCase(String name) {
        super(name);
    }

    public void testDeployParentNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(deployment.getName());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentOneChildNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(childName));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentOneChildFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentOneChildFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, "child");
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentOneChildFailInChildDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentOneChildFailInChildDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInChild1Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInChild1Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParent, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInChild2Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenFailInChild2Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2C2md1C2md2, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNone, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsParentComponent1Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmdfail1);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedNone, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsParentComponent2Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmdfail2);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsChild1Component1Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1mdfail1);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsChild1Component2Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1mdfail2);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsChild2Component1Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2mdfail1);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2C2md1Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    public void testDeployParentMultipleChildrenAndComponentsChild2Component2Fails() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicAllOrNothingUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2mdfail2);
        main.addDeployment(deployment);
        main.process();
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer2.getUndeployedUnits());
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2C2md1C2md2Fail, this.deployer4.deployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals(expectedPmd1Pmd2C1md1C1md2C2md1, this.deployer4.undeployed);
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicAllOrNothingUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
        main.removeDeployment(deployment);
        main.process();
        main.checkComplete();
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, TestComponentMetaDataContainer md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(TestComponentMetaDataContainer.class, (Object)md);
    }

    protected static void makeFail(PredeterminedManagedObjectAttachments attachments, Deployer deployer) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment("fail", (Object)deployer);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2});
    }

    protected DeployerClient getMainDeployerWithComponentDeployers() {
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2, this.deployer3, this.deployer4});
    }
}

