/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestDeploymentContextComparator;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicDeploymentRelativeOrderUnitTestCase
extends AbstractDeployerTest {
    private static final DeploymentFactory factory = new DeploymentFactory();
    private TestSimpleDeployer3 deployer1 = new TestSimpleDeployer3(DeploymentStages.REAL);
    private static String P = "Parent";
    private static String C1 = P + "/" + "C1";
    private static String C2 = P + "/" + "C2";
    private static List<String> NONE = Collections.emptyList();
    private static List<String> PC1C2 = HeuristicDeploymentRelativeOrderUnitTestCase.makeList(P, C1, C2);
    private static List<String> PC2C1 = HeuristicDeploymentRelativeOrderUnitTestCase.makeList(P, C2, C1);
    private static List<String> C2C1P = HeuristicDeploymentRelativeOrderUnitTestCase.makeList(C2, C1, P);
    private static List<String> C1C2P = HeuristicDeploymentRelativeOrderUnitTestCase.makeList(C1, C2, P);

    private static <T> List<T> makeList(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(HeuristicDeploymentRelativeOrderUnitTestCase.class);
    }

    public HeuristicDeploymentRelativeOrderUnitTestCase(String name) {
        super(name);
    }

    public void testNoRelativeOrderUsesSimpleName() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment parent = this.createSimpleDeployment("Parent");
        factory.addContext((PredeterminedManagedObjectAttachments)parent, "C1");
        factory.addContext((PredeterminedManagedObjectAttachments)parent, "C2");
        main.addDeployment(parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC1C2, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        main.removeDeployment(parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC1C2, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(C2C1P, this.deployer1.undeployed);
    }

    public void testRelativeOrder() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment parent = this.createSimpleDeployment("Parent");
        ContextInfo c1 = factory.addContext((PredeterminedManagedObjectAttachments)parent, "C1");
        c1.setRelativeOrder(2);
        ContextInfo c2 = factory.addContext((PredeterminedManagedObjectAttachments)parent, "C2");
        c2.setRelativeOrder(1);
        main.addDeployment(parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC2C1, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        main.removeDeployment(parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC2C1, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(C1C2P, this.deployer1.undeployed);
    }

    public void testComparator() throws Exception {
        DeployerClient main = this.getMainDeployer();
        AbstractDeployment parent = new AbstractDeployment("Parent");
        ContextInfo p = factory.addContext((PredeterminedManagedObjectAttachments)parent, "");
        p.setComparatorClassName(TestDeploymentContextComparator.class.getName());
        factory.addContext((PredeterminedManagedObjectAttachments)parent, "C1");
        factory.addContext((PredeterminedManagedObjectAttachments)parent, "C2");
        main.addDeployment((Deployment)parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC2C1, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(NONE, this.deployer1.undeployed);
        main.removeDeployment((Deployment)parent);
        main.process();
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(PC2C1, this.deployer1.deployed);
        HeuristicDeploymentRelativeOrderUnitTestCase.assertEquals(C1C2P, this.deployer1.undeployed);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer1});
    }
}

