/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.deployer.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.TestComponentDeployer;
import org.jboss.test.deployers.deployer.support.TestComponentMetaData;
import org.jboss.test.deployers.deployer.support.TestComponentMetaDataContainer;
import org.jboss.test.deployers.deployer.support.TestSimpleDeployer2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicRussionDollUnitTestCase
extends AbstractDeployerTest {
    private TestComponentDeployer deployer0 = new TestComponentDeployer(1);
    private TestSimpleDeployer2 deployer1 = new TestSimpleDeployer2(true, 2);
    private TestSimpleDeployer2 deployer2 = new TestSimpleDeployer2(false, 3);
    private static String parentName = "parent";
    private static String childPath = "child";
    private static String childName = parentName + "/" + childPath;
    private static String child1Path = "child1";
    private static String child1Name = parentName + "/" + child1Path;
    private static String child2Path = "child2";
    private static String child2Name = parentName + "/" + child2Path;
    private static TestComponentMetaData parentmd1 = new TestComponentMetaData(parentName + ".1", false);
    private static TestComponentMetaData parentmd2 = new TestComponentMetaData(parentName + ".2", false);
    private static TestComponentMetaData childmd1 = new TestComponentMetaData(childName + ".1", false);
    private static TestComponentMetaData childmd2 = new TestComponentMetaData(childName + ".2", false);
    private static TestComponentMetaData child1md1 = new TestComponentMetaData(child1Name + ".1", false);
    private static TestComponentMetaData child1md2 = new TestComponentMetaData(child1Name + ".2", false);
    private static TestComponentMetaData child2md1 = new TestComponentMetaData(child2Name + ".1", false);
    private static TestComponentMetaData child2md2 = new TestComponentMetaData(child2Name + ".2", false);
    private static List<String> expectedNothing = Collections.emptyList();
    private static List<String> expectedParent = HeuristicRussionDollUnitTestCase.makeList(parentName);
    private static List<String> expectedParentMD12 = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name);
    private static List<String> expectedPMD21 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name);
    private static List<String> expectedMD12Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, parentName);
    private static List<String> expectedMD21Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, parentName);
    private static List<String> expectedChild = HeuristicRussionDollUnitTestCase.makeList(childName);
    private static List<String> expectedMD12Child = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.childmd1.name, HeuristicRussionDollUnitTestCase.childmd2.name, childName);
    private static List<String> expectedMD21C = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.childmd2.name, HeuristicRussionDollUnitTestCase.childmd1.name);
    private static List<String> expectedPMD21ChildMD21 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, childName, HeuristicRussionDollUnitTestCase.childmd2.name, HeuristicRussionDollUnitTestCase.childmd1.name);
    private static List<String> expectedChild1 = HeuristicRussionDollUnitTestCase.makeList(child1Name);
    private static List<String> expectedMD12Child1 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child1md1.name, HeuristicRussionDollUnitTestCase.child1md2.name, child1Name);
    private static List<String> expectedMD21C1 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child1md2.name, HeuristicRussionDollUnitTestCase.child1md1.name);
    private static List<String> expectedParentChild = HeuristicRussionDollUnitTestCase.makeList(parentName, childName);
    private static List<String> expectedParentMD12Child = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, childName);
    private static List<String> expectedParentMD12ChildMD12 = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, childName, HeuristicRussionDollUnitTestCase.childmd1.name, HeuristicRussionDollUnitTestCase.childmd2.name);
    private static List<String> expectedChildParent = HeuristicRussionDollUnitTestCase.makeList(childName, parentName);
    private static List<String> expectedMD12ChildMD12Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.childmd1.name, HeuristicRussionDollUnitTestCase.childmd2.name, childName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, parentName);
    private static List<String> expectedMD21ChildMD21Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.childmd2.name, HeuristicRussionDollUnitTestCase.childmd1.name, childName, HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, parentName);
    private static List<String> expectedChild1Parent = HeuristicRussionDollUnitTestCase.makeList(child1Name, parentName);
    private static List<String> expectedMD21Child1MD21Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child1md2.name, HeuristicRussionDollUnitTestCase.child1md1.name, child1Name, HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, parentName);
    private static List<String> expectedParentChild1 = HeuristicRussionDollUnitTestCase.makeList(parentName, child1Name);
    private static List<String> expectedParentMD12Child1 = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, child1Name);
    private static List<String> expectedParentChild1Child2 = HeuristicRussionDollUnitTestCase.makeList(parentName, child1Name, child2Name);
    private static List<String> expectedParentMD12Child1MD12Child2 = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, child1Name, HeuristicRussionDollUnitTestCase.child1md1.name, HeuristicRussionDollUnitTestCase.child1md2.name, child2Name);
    private static List<String> expectedParentMD12Child1MD12Child2MD12 = HeuristicRussionDollUnitTestCase.makeList(parentName, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, child1Name, HeuristicRussionDollUnitTestCase.child1md1.name, HeuristicRussionDollUnitTestCase.child1md2.name, child2Name, HeuristicRussionDollUnitTestCase.child2md1.name, HeuristicRussionDollUnitTestCase.child2md2.name);
    private static List<String> expectedChild1Child2Parent = HeuristicRussionDollUnitTestCase.makeList(child1Name, child2Name, parentName);
    private static List<String> expectedMD12Child1MD12Child2MD12Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child1md1.name, HeuristicRussionDollUnitTestCase.child1md2.name, child1Name, HeuristicRussionDollUnitTestCase.child2md1.name, HeuristicRussionDollUnitTestCase.child2md2.name, child2Name, HeuristicRussionDollUnitTestCase.parentmd1.name, HeuristicRussionDollUnitTestCase.parentmd2.name, parentName);
    private static List<String> expectedChild2Child1Parent = HeuristicRussionDollUnitTestCase.makeList(child2Name, child1Name, parentName);
    private static List<String> expectedMD21Child2MD21Child1MD21Parent = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child2md2.name, HeuristicRussionDollUnitTestCase.child2md1.name, child2Name, HeuristicRussionDollUnitTestCase.child1md2.name, HeuristicRussionDollUnitTestCase.child1md1.name, child1Name, HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, parentName);
    private static List<String> expectedChild1Child2 = HeuristicRussionDollUnitTestCase.makeList(child1Name, child2Name);
    private static List<String> expectedMD12Child1MD12Child2 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child1md1.name, HeuristicRussionDollUnitTestCase.child1md2.name, child1Name, HeuristicRussionDollUnitTestCase.child2md1.name, HeuristicRussionDollUnitTestCase.child2md2.name, child2Name);
    private static List<String> expectedChild2Child1 = HeuristicRussionDollUnitTestCase.makeList(child2Name, child1Name);
    private static List<String> expectedPMD21Child2MD21Child1MD21 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.parentmd2.name, HeuristicRussionDollUnitTestCase.parentmd1.name, child2Name, HeuristicRussionDollUnitTestCase.child2md2.name, HeuristicRussionDollUnitTestCase.child2md1.name, child1Name, HeuristicRussionDollUnitTestCase.child1md2.name, HeuristicRussionDollUnitTestCase.child1md1.name);
    private static List<String> expectedMD21C2Child1MD21 = HeuristicRussionDollUnitTestCase.makeList(HeuristicRussionDollUnitTestCase.child2md2.name, HeuristicRussionDollUnitTestCase.child2md1.name, child1Name, HeuristicRussionDollUnitTestCase.child1md2.name, HeuristicRussionDollUnitTestCase.child1md1.name);
    private static TestComponentMetaDataContainer parentmd = new TestComponentMetaDataContainer(parentmd1, parentmd2);
    private static TestComponentMetaDataContainer childmd = new TestComponentMetaDataContainer(childmd1, childmd2);
    private static TestComponentMetaDataContainer child1md = new TestComponentMetaDataContainer(child1md1, child1md2);
    private static TestComponentMetaDataContainer child2md = new TestComponentMetaDataContainer(child2md1, child2md2);

    private static <T> List<T> makeList(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(HeuristicRussionDollUnitTestCase.class);
    }

    public HeuristicRussionDollUnitTestCase(String name) {
        super(name);
    }

    public void testDeployParentNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(deployment.getName());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentOneChildNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChildParent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentOneChildFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentOneChildFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, "child");
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChildParent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChildParent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentOneChildFailInChildDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentOneChildFailInChildDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChildParent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentMultipleChildrenNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1Child2Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild2Child1Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1Child2Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild2Child1, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInChild1Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer1);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInChild1Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer2);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild2Child1Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInChild2Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentMultipleChildrenFailInChild2Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment(parentName);
        this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentChild1Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild2Child1Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1Child2, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedChild1, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentWithComponentsFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentWithComponentsFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HashSet<String> expected = new HashSet<String>();
        expected.add(deployment.getName());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedPMD21, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
    }

    public void testDeployParentWithComponentsOneChildNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child, childmd);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12ChildMD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12ChildMD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentWithComponentsOneChildFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child, childmd);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentWithComponentsOneChildFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child, childmd);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12ChildMD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21ChildMD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12ChildMD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedPMD21ChildMD21, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentWithComponentsOneChildFailInChildDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child, childmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentWithComponentsOneChildFailInChildDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child = this.addChild((PredeterminedManagedObjectAttachments)deployment, childPath);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child, childmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12ChildMD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21ChildMD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Child, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21C, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(childName));
    }

    public void testDeployParentWithComponentsMultipleChildrenNoErrors() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1MD12Child2MD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Child1MD12Child2MD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.DEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInParentDeployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer1);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParent, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInParentDeployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer2);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1MD12Child2MD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Child2MD21Child1MD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Child1MD12Child2MD12Parent, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedPMD21Child2MD21Child1MD21, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInChild1Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer1);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInChild1Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child1, (Deployer)this.deployer2);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1MD12Child2MD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Child2MD21Child1MD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Child1, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21C1, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInChild2Deployer1() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer1);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1MD12Child2, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Child1MD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedNothing, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
    }

    public void testDeployParentWithComponentsMultipleChildrenFailInChild2Deployer2() throws Exception {
        DeployerClient main = this.getMainDeployerWithComponentDeployers();
        Deployment deployment = this.createSimpleDeployment(parentName);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)deployment, parentmd);
        ContextInfo child1 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child1Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child1, child1md);
        ContextInfo child2 = this.addChild((PredeterminedManagedObjectAttachments)deployment, child2Path);
        HeuristicRussionDollUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)child2, child2md);
        HeuristicRussionDollUnitTestCase.makeFail((PredeterminedManagedObjectAttachments)child2, (Deployer)this.deployer2);
        main.addDeployment(deployment);
        main.process();
        HeuristicRussionDollUnitTestCase.assertEquals(expectedParentMD12Child1MD12Child2MD12, this.deployer1.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21Child2MD21Child1MD21Parent, this.deployer1.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD12Child1MD12Child2, this.deployer2.getDeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals(expectedMD21C2Child1MD21, this.deployer2.getUndeployedUnits());
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(deployment.getName()));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.UNDEPLOYED, (Object)main.getDeploymentState(child1Name));
        HeuristicRussionDollUnitTestCase.assertEquals((Object)DeploymentState.ERROR, (Object)main.getDeploymentState(child2Name));
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, TestComponentMetaDataContainer md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(TestComponentMetaDataContainer.class, (Object)md);
    }

    protected static void makeFail(PredeterminedManagedObjectAttachments attachments, Deployer deployer) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment("fail", (Object)deployer);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2});
    }

    protected DeployerClient getMainDeployerWithComponentDeployers() {
        return this.createMainDeployer(new Deployer[]{this.deployer0, this.deployer1, this.deployer2});
    }
}

