/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.main.support;

import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.main.support.TestAttachment;

public class DependencyDeployer
extends AbstractRealDeployer {
    private Controller controller;
    private ControllerContextActions actions = new TestControllerContextActions();

    public DependencyDeployer(Controller controller) {
        this.controller = controller;
        this.setUseUnitName(true);
    }

    protected boolean isControllerContextNameCandidate(DeploymentUnit unit) {
        return true;
    }

    protected void addControllerContextName(DeploymentUnit unit) {
        unit.addControllerContextName((Object)("x" + unit.getName()));
    }

    protected void removeControllerContextName(DeploymentUnit unit) {
        unit.removeControllerContextName((Object)("x" + unit.getName()));
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        TestAttachment attachment = (TestAttachment)unit.getAttachment(TestAttachment.class);
        if (attachment != null) {
            Object name = attachment.getName();
            AbstractControllerContext context = new AbstractControllerContext(name, this.actions);
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            Object dependency = attachment.getDependency();
            if (dependency != null) {
                AbstractDependencyItem item = new AbstractDependencyItem(name, dependency, ControllerState.INSTALLED, null);
                dependencyInfo.addIDependOn((DependencyItem)item);
            }
            try {
                this.controller.install((ControllerContext)context);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Unexpected.", (Throwable)t);
            }
        }
    }

    protected void internalUndeploy(DeploymentUnit unit) {
        TestAttachment attachment = (TestAttachment)unit.getAttachment(TestAttachment.class);
        if (attachment != null) {
            this.controller.uninstall(attachment.getName());
        }
    }

    private class TestControllerContextActions
    implements ControllerContextActions {
        private TestControllerContextActions() {
        }

        public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
            context.setState(toState);
        }

        public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
            context.setState(toState);
        }
    }
}

