/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.main.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSimpleDeployer
extends AbstractRealDeployer {
    private List<String> deployed = new CopyOnWriteArrayList<String>();
    private List<String> undeployed = new CopyOnWriteArrayList<String>();
    private List<String> failed = new CopyOnWriteArrayList<String>();
    private String name;

    public TestSimpleDeployer() {
        this(Integer.MAX_VALUE);
        this.name = super.toString();
    }

    public TestSimpleDeployer(String name) {
        this(Integer.MAX_VALUE);
        this.name = name;
    }

    public TestSimpleDeployer(int relativeOrder) {
        this.setRelativeOrder(relativeOrder);
        this.setType("test");
        this.name = "TestSimpleDeployer" + relativeOrder;
    }

    public TestSimpleDeployer(DeploymentStage stage) {
        this.setStage(stage);
        this.setType("test");
        this.name = super.toString();
    }

    public String toString() {
        return this.name;
    }

    public void clear() {
        this.deployed.clear();
        this.undeployed.clear();
        this.failed.clear();
    }

    public List<String> getDeployedUnits() {
        return this.deployed;
    }

    public List<String> getUndeployedUnits() {
        return this.undeployed;
    }

    public List<String> getFailed() {
        return this.failed;
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        this.log.debug((Object)((Object)((Object)this) + " deploy  : " + unit.getName()));
        unit.getTypes().add(this.getType());
        this.deployed.add(unit.getName());
        if (((Object)((Object)this)).equals(unit.getAttachment("fail"))) {
            this.failed.add(unit.getName());
            throw new DeploymentException("Asked to fail");
        }
    }

    public void internalUndeploy(DeploymentUnit unit) {
        this.log.debug((Object)((Object)((Object)this) + " undeploy: " + unit.getName()));
        this.undeployed.add(unit.getName());
    }
}

