/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.main.test;

import junit.framework.Test;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.plugins.deployers.DeployersImpl;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.test.deployers.main.support.DependencyDeployer;
import org.jboss.test.deployers.main.support.TestAttachment;
import org.jboss.test.deployers.main.test.AbstractMainDeployerTest;

public class DeployerCheckCompleteTestCase
extends AbstractMainDeployerTest {
    public DeployerCheckCompleteTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return DeployerCheckCompleteTestCase.suite(DeployerCheckCompleteTestCase.class);
    }

    public void testAllFailure() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment("failure");
        DeployerCheckCompleteTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer);
        main.addDeployment(deployment);
        main.process();
        try {
            main.checkComplete(new Deployment[]{deployment});
            DeployerCheckCompleteTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            this.assertInstanceOf((Object)e, IncompleteDeploymentException.class);
        }
    }

    public void testAllSuccess() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment("failure");
        main.addDeployment(deployment);
        main.process();
        main.checkComplete(new Deployment[]{deployment});
    }

    public void testStructureFailure() throws Exception {
        DeployerClient main = this.getMainDeployer();
        MainDeployerImpl mainImpl = (MainDeployerImpl)main;
        StructuralDeployers sd = new StructuralDeployers(){

            public DeploymentContext determineStructure(Deployment deployment) throws DeploymentException {
                throw new DeploymentException("No such structure deployers.");
            }
        };
        mainImpl.setStructuralDeployers(sd);
        Deployment deployment = this.createSimpleDeployment("failure");
        DeployerCheckCompleteTestCase.makeFail((PredeterminedManagedObjectAttachments)deployment, (Deployer)this.deployer);
        try {
            main.addDeployment(deployment);
        }
        catch (DeploymentException ignored) {
            // empty catch block
        }
        main.process();
        try {
            main.checkComplete();
            DeployerCheckCompleteTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            this.assertInstanceOf((Object)e, IncompleteDeploymentException.class);
        }
    }

    public void testStructureSuccess() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment deployment = this.createSimpleDeployment("failure");
        main.addDeployment(deployment);
        main.process();
        main.checkStructureComplete(new Deployment[]{deployment});
    }

    public void testHalfThenAll() throws Exception {
        DeployerClient main = this.getDependencyMainDeployer();
        Deployment dA = this.createSimpleDeployment("A");
        this.addAttachment(dA, "xB");
        main.addDeployment(dA);
        main.process();
        try {
            main.checkComplete(new Deployment[]{dA});
            DeployerCheckCompleteTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            this.assertInstanceOf((Object)e, IncompleteDeploymentException.class);
        }
        Deployment dB = this.createSimpleDeployment("B");
        this.addAttachment(dB, null);
        main.deploy(new Deployment[]{dB});
        main.checkComplete(new Deployment[]{dA});
    }

    public void testAllThenHalf() throws Exception {
        DeployerClient main = this.getDependencyMainDeployer();
        Deployment dA = this.createSimpleDeployment("A");
        this.addAttachment(dA, "xB");
        main.addDeployment(dA);
        main.process();
        Deployment dB = this.createSimpleDeployment("B");
        this.addAttachment(dB, null);
        main.deploy(new Deployment[]{dB});
        main.checkComplete(new Deployment[]{dA});
        main.undeploy(new Deployment[]{dB});
        try {
            main.checkComplete(new Deployment[]{dA});
            DeployerCheckCompleteTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            this.assertInstanceOf((Object)e, IncompleteDeploymentException.class);
        }
    }

    protected DeployerClient getDependencyMainDeployer() {
        MainDeployerImpl main = new MainDeployerImpl();
        main.setStructuralDeployers(this.createStructuralDeployers());
        AbstractController controller = new AbstractController();
        DeployersImpl deployers = new DeployersImpl(controller);
        deployers.addDeployer((Deployer)new DependencyDeployer((Controller)controller));
        main.setDeployers((Deployers)deployers);
        return main;
    }

    protected void addAttachment(Deployment deployment, Object dependency) {
        MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        mutableAttachments.addAttachment(TestAttachment.class, (Object)new TestAttachment("x" + deployment.getName(), dependency));
    }
}

