/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.main.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.deployers.client.spi.IncompleteDeployments;
import org.jboss.deployers.client.spi.MissingDependency;
import org.jboss.test.deployers.AbstractDeployerTest;

public class DeployerIncompleteDeploymentsTestCase
extends AbstractDeployerTest {
    public DeployerIncompleteDeploymentsTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return DeployerIncompleteDeploymentsTestCase.suite(DeployerIncompleteDeploymentsTestCase.class);
    }

    public void testMessage() throws Exception {
        HashMap<String, Throwable> deploymentsInError = new HashMap<String, Throwable>();
        HashSet<String> deploymentsMissingDeployer = new HashSet<String>();
        HashMap<String, Throwable> contextsInError = new HashMap<String, Throwable>();
        HashMap<String, Set<MissingDependency>> contextsMissingDependencies = new HashMap<String, Set<MissingDependency>>();
        deploymentsInError.put("deployment1", new Throwable("sd1"));
        deploymentsMissingDeployer.add("deployment2");
        contextsInError.put("context1", new Throwable("sc1"));
        contextsMissingDependencies.put("context2", Collections.singleton(new MissingDependency()));
        IncompleteDeployments deployments = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies);
        DeployerIncompleteDeploymentsTestCase.assertTrue((boolean)deployments.isIncomplete());
        DeployerIncompleteDeploymentsTestCase.assertTrue((boolean)deployments.isInvalidDeployment("deployment1"));
        DeployerIncompleteDeploymentsTestCase.assertTrue((boolean)deployments.isInvalidDeployment("deployment2"));
        DeployerIncompleteDeploymentsTestCase.assertTrue((boolean)deployments.isInvalidContext("context1"));
        DeployerIncompleteDeploymentsTestCase.assertTrue((boolean)deployments.isInvalidContext("context2"));
        String deInfo = deployments.getDeploymentsInErrorInfo();
        DeployerIncompleteDeploymentsTestCase.assertNotNull((Object)deInfo);
        DeployerIncompleteDeploymentsTestCase.assertSame((Object)deInfo, (Object)deployments.getDeploymentsInErrorInfo());
        String dmInfo = deployments.getDeploymentsMissingDeployerInfo();
        DeployerIncompleteDeploymentsTestCase.assertNotNull((Object)dmInfo);
        DeployerIncompleteDeploymentsTestCase.assertSame((Object)dmInfo, (Object)deployments.getDeploymentsMissingDeployerInfo());
        String ceInfo = deployments.getContextsInErrorInfo();
        DeployerIncompleteDeploymentsTestCase.assertNotNull((Object)ceInfo);
        DeployerIncompleteDeploymentsTestCase.assertSame((Object)ceInfo, (Object)deployments.getContextsInErrorInfo());
        String cmInfo = deployments.getContextsMissingDependenciesInfo();
        DeployerIncompleteDeploymentsTestCase.assertNotNull((Object)cmInfo);
        DeployerIncompleteDeploymentsTestCase.assertSame((Object)cmInfo, (Object)deployments.getContextsMissingDependenciesInfo());
    }
}

