/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.main.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Test;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.deployers.structure.spi.StructureBuilder;
import org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder;
import org.jboss.test.deployers.main.support.AddDeploymentRunnable;
import org.jboss.test.deployers.main.support.AddProcessRemoveProcessRunnable;
import org.jboss.test.deployers.main.support.DeployRunnable;
import org.jboss.test.deployers.main.support.DeployUndeployRunnable;
import org.jboss.test.deployers.main.support.DeployerTestRunnable;
import org.jboss.test.deployers.main.support.FailedDeployUndeployRunnable;
import org.jboss.test.deployers.main.support.ProcessRunnable;
import org.jboss.test.deployers.main.support.ShutdownRunnable;
import org.jboss.test.deployers.main.support.TestDeployment;
import org.jboss.test.deployers.main.support.UndeployRunnable;
import org.jboss.test.deployers.main.test.AbstractMainDeployerTest;

public class DeployerSingleDeploymentTestCase
extends AbstractMainDeployerTest {
    public DeployerSingleDeploymentTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return DeployerSingleDeploymentTestCase.suite(DeployerSingleDeploymentTestCase.class);
    }

    protected void checkFailedDeployOnStructure(DeployerClient mainDeployer, final int failed, int size) throws Throwable {
        AbstractStructureBuilder builder = new AbstractStructureBuilder();
        StructuralDeployers structuralDeployers = new StructuralDeployers((StructureBuilder)builder){
            final /* synthetic */ StructureBuilder val$builder;
            {
                this.val$builder = structureBuilder;
            }

            public DeploymentContext determineStructure(Deployment deployment) throws DeploymentException {
                String name = deployment.getName();
                if (name.endsWith("deployment" + failed)) {
                    throw new RuntimeException(String.valueOf(failed));
                }
                return this.val$builder.populateContext(deployment, StructureMetaDataFactory.createStructureMetaData());
            }
        };
        ((MainDeployerImpl)mainDeployer).setStructuralDeployers(structuralDeployers);
        Deployment[] deployments = new Deployment[size];
        for (int i = 0; i < size; ++i) {
            deployments[i] = this.createSimpleDeployment("deployment" + i);
        }
        try {
            mainDeployer.deploy(deployments);
            DeployerSingleDeploymentTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            Throwable cause = e.getCause();
            DeployerSingleDeploymentTestCase.assertNotNull((Object)cause);
            String msg = cause.getMessage();
            DeployerSingleDeploymentTestCase.assertEquals((int)failed, (int)Integer.parseInt(msg));
        }
        this.deployer.clear();
    }

    public void testFailedDeployOnStructure() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        this.checkFailedDeployOnStructure(main, 0, 3);
        this.checkFailedDeployOnStructure(main, 1, 3);
        this.checkFailedDeployOnStructure(main, 2, 3);
    }

    protected void checkFailedDeploy(DeployerClient mainDeployer, int failed, int size) throws Throwable {
        Deployment[] deployments = new Deployment[size];
        for (int i = 0; i < size; ++i) {
            deployments[i] = this.createSimpleDeployment("deployment" + i);
            if (i != failed) continue;
            DeployerSingleDeploymentTestCase.makeFail((PredeterminedManagedObjectAttachments)deployments[i], (Deployer)this.deployer);
        }
        try {
            mainDeployer.deploy(deployments);
            DeployerSingleDeploymentTestCase.fail((String)"Should not be here.");
        }
        catch (DeploymentException e) {
            DeployerSingleDeploymentTestCase.assertEquals((int)size, (int)(this.deployer.getUndeployedUnits().size() + this.deployer.getFailed().size()));
            DeployerSingleDeploymentTestCase.assertEquals(Collections.singletonList("deployment" + failed), this.deployer.getFailed());
        }
        this.deployer.clear();
    }

    public void testFailedDeploy() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        this.checkFailedDeploy(main, 0, 3);
        this.checkFailedDeploy(main, 1, 3);
        this.checkFailedDeploy(main, 2, 3);
    }

    public void testRedeploy() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("redeploy");
        main.deploy(new Deployment[]{context});
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(context.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.undeploy(new Deployment[]{context});
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
        this.deployer.clear();
        main.deploy(new Deployment[]{context});
        expected.clear();
        expected.add(context.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
    }

    public void testDeployRemoveProcess() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("drp");
        main.deploy(new Deployment[]{context});
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(context.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.removeDeployment(context);
        main.process();
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testAddProcessUndeploy() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("apu");
        main.addDeployment(context);
        main.process();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(context.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.undeploy(new Deployment[]{context});
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testDeployShutdown() throws Throwable {
        MainDeployer main = (MainDeployer)this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("shutdown");
        main.deploy(new Deployment[]{context});
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(context.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.shutdown();
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testSingleAndMultipleMix() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        Deployment single = this.createSimpleDeployment("single");
        main.deploy(new Deployment[]{single});
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(single.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        Deployment normal = this.createSimpleDeployment("normal");
        main.addDeployment(normal);
        main.process();
        expected.add(normal.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.undeploy(new Deployment[]{single});
        expected.clear();
        expected.add(single.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
        main.removeDeployment(normal.getName());
        main.process();
        expected.add(normal.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testSingleAndMultipleMix2() throws Throwable {
        DeployerClient main = this.getMainDeployer();
        Deployment single = this.createSimpleDeployment("single");
        main.deploy(new Deployment[]{single});
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(single.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        Deployment normal = this.createSimpleDeployment("normal");
        main.addDeployment(normal);
        main.process();
        expected.add(normal.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getDeployedUnits());
        main.removeDeployment(normal.getName());
        main.process();
        expected.clear();
        expected.add(normal.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
        main.undeploy(new Deployment[]{single});
        expected.add(single.getName());
        DeployerSingleDeploymentTestCase.assertEquals(expected, this.deployer.getUndeployedUnits());
    }

    public void testMultiThreads() throws Exception {
        int i;
        DeployerClient main = this.getMainDeployer();
        int n = 30;
        DeployerTestRunnable[] runnables = new DeployerTestRunnable[n];
        for (int i2 = 0; i2 < n; ++i2) {
            runnables[i2] = i2 % 3 == 0 ? new DeployUndeployRunnable(main, this.createSimpleDeployment("deployundeploy" + i2)) : (i2 % 3 == 1 ? new AddProcessRemoveProcessRunnable(main, this.createSimpleDeployment("aprp" + i2)) : new FailedDeployUndeployRunnable(main, this.createSimpleDeployment("failed" + i2), (Deployer)this.deployer));
        }
        Thread[] threads = new Thread[n];
        for (i = 0; i < n; ++i) {
            threads[i] = new Thread(runnables[i]);
            threads[i].start();
        }
        for (i = 0; i < n; ++i) {
            threads[i].join();
            DeployerSingleDeploymentTestCase.assertTrue((String)runnables[i].toString(), (boolean)runnables[i].isValid());
        }
    }

    public void testMultiThreadsAndShutdown() throws Exception {
        int i;
        DeployerClient main = this.getMainDeployer();
        int n = 30;
        int shutdown = new Random().nextInt(n / 2);
        this.log.info((Object)("Shutdown order: " + shutdown));
        DeployerTestRunnable[] runnables = new DeployerTestRunnable[n];
        HashSet<String> names = new HashSet<String>();
        String[] dname = new String[]{"deploy", "add", "undeploy", "error"};
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 == shutdown) {
                runnables[i2] = new ShutdownRunnable(main);
                continue;
            }
            if (i2 % 4 == 3) {
                runnables[i2] = new ProcessRunnable(main);
                continue;
            }
            TestDeployment deployment = new TestDeployment(dname[i2 % 4] + i2, names);
            if (i2 % 4 == 0) {
                runnables[i2] = new DeployRunnable(main, (Deployment)deployment);
                continue;
            }
            if (i2 % 4 == 1) {
                runnables[i2] = new AddDeploymentRunnable(main, (Deployment)deployment);
                continue;
            }
            if (i2 % 4 != 2) continue;
            runnables[i2] = new UndeployRunnable(main, (Deployment)deployment);
        }
        Thread[] threads = new Thread[n];
        for (i = 0; i < n; ++i) {
            threads[i] = new Thread(runnables[i]);
            threads[i].start();
        }
        for (i = 0; i < n; ++i) {
            threads[i].join();
            DeployerSingleDeploymentTestCase.assertTrue((String)runnables[i].toString(), (boolean)runnables[i].isValid());
        }
        this.log.info((Object)("Names: " + names.size() + " - " + names));
    }
}

