/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.managed.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockProfileService {
    private static final Logger log = Logger.getLogger(MockProfileService.class);
    private DeployerClient main;
    private Map<String, ManagedObject> moRegistry = new HashMap<String, ManagedObject>();
    private Map<String, Deployment> deployments = new HashMap<String, Deployment>();
    private Map<String, ManagedDeployment> managedDeployments = new HashMap<String, ManagedDeployment>();
    private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap<String, Set<ManagedProperty>>();
    private Map<String, ManagedObject> runtimeMOs = new HashMap<String, ManagedObject>();

    public MockProfileService(DeployerClient main) {
        this.main = main;
    }

    public void addDeployment(Deployment ctx) throws DeploymentException {
        this.main.addDeployment(ctx);
        this.deployments.put(ctx.getName(), ctx);
    }

    public void process() throws DeploymentException {
        this.main.process();
        for (String name : this.deployments.keySet()) {
            ManagedDeployment md = this.main.getManagedDeployment(name);
            log.info((Object)(name + " ManagedDeployment: " + md));
            Map mos = md.getManagedObjects();
            log.info((Object)(name + " ManagedObjects: " + mos));
            for (ManagedObject mo : mos.values()) {
                this.processManagedObject(mo, md);
            }
            this.managedDeployments.put(name, md);
        }
    }

    public ManagedObject getManagedObject(String name) {
        ManagedObject mo = this.moRegistry.get(name);
        return mo;
    }

    public ManagedDeployment getManagedDeployment(String name) {
        ManagedDeployment md = this.managedDeployments.get(name);
        return md;
    }

    protected void processManagedObject(ManagedObject mo, ManagedDeployment md) {
        String key = mo.getName() + "/" + mo.getNameType();
        log.debug((Object)("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName()));
        Map moAnns = mo.getAnnotations();
        ManagementObject managementObject = (ManagementObject)moAnns.get(ManagementObject.class.getName());
        if (managementObject.isRuntime()) {
            ManagedObject parentMO = this.moRegistry.get(key);
            if (parentMO == null) {
                this.runtimeMOs.put(key, mo);
                return;
            }
            this.mergeRuntimeMO(parentMO, mo);
        } else {
            ManagedObject runtimeMO = this.runtimeMOs.get(key);
            if (runtimeMO != null) {
                this.mergeRuntimeMO(mo, runtimeMO);
            }
        }
        ManagedObject prevMO = this.moRegistry.put(key, mo);
        if (prevMO != null) {
            log.warn((Object)("Duplicate mo for key: " + key + ", prevMO: " + prevMO));
        }
        this.checkForReferences(key, mo);
        ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
        if (mc != null) {
            ComponentType type = new ComponentType(mc.type(), mc.subtype());
            ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
            md.addComponent(mo.getName(), (ManagedComponent)comp);
        }
        for (ManagedProperty prop : mo.getProperties().values()) {
            ArrayValue avalue;
            MetaType etype;
            ArrayMetaType amt;
            MetaType propType;
            ManagementObjectRef ref;
            log.debug((Object)("Checking property: " + prop));
            ManagementObjectID id = (ManagementObjectID)prop.getAnnotations().get(ManagementObjectID.class.getName());
            if (id != null) {
                Object refName = this.getRefName(prop.getValue());
                if (refName == null) {
                    refName = id.name();
                }
                String propKey = refName + "/" + id.type();
                log.debug((Object)("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName()));
                this.moRegistry.put(propKey, mo);
                this.checkForReferences(propKey, mo);
            }
            if ((ref = (ManagementObjectRef)prop.getAnnotations().get(ManagementObjectRef.class.getName())) != null) {
                String targetKey;
                ManagedObject target;
                log.debug((Object)("Property(" + prop.getName() + ") references: " + ref));
                Object refName = this.getRefName(prop.getValue());
                if (refName == null) {
                    refName = ref.name();
                }
                if ((target = this.moRegistry.get(targetKey = refName + "/" + ref.type())) != null) {
                    log.debug((Object)("Resolved property(" + prop.getName() + ") reference to: " + targetKey));
                    prop.setTargetManagedObject(target);
                } else {
                    Set<ManagedProperty> referers = this.unresolvedRefs.get(targetKey);
                    if (referers == null) {
                        referers = new HashSet<ManagedProperty>();
                        this.unresolvedRefs.put(targetKey, referers);
                    }
                    referers.add(prop);
                }
            }
            if ((propType = prop.getMetaType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                GenericValue gv = (GenericValue)prop.getValue();
                ManagedObject propMO = (ManagedObject)gv.getValue();
                this.processManagedObject(propMO, md);
                continue;
            }
            if (propType.isArray()) {
                amt = (ArrayMetaType)propType;
                etype = amt.getElementType();
                if (etype != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
                avalue = (ArrayValue)prop.getValue();
                for (int n = 0; n < avalue.getLength(); ++n) {
                    GenericValue gv = (GenericValue)avalue.getValue(n);
                    ManagedObject propMO = (ManagedObject)gv.getValue();
                    this.processManagedObject(propMO, md);
                }
                continue;
            }
            if (!propType.isCollection() || (etype = (amt = (CollectionMetaType)propType).getElementType()) != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
            avalue = (CollectionValue)prop.getValue();
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                GenericValue gv = (GenericValue)elements[n];
                ManagedObject propMO = (ManagedObject)gv.getValue();
                this.processManagedObject(propMO, md);
            }
        }
    }

    protected Object getRefName(Object value) {
        if (value instanceof MetaValue) {
            MetaValue metaValue = (MetaValue)value;
            if (!metaValue.getMetaType().isSimple()) {
                throw new IllegalArgumentException("Can only get ref from simple value: " + value);
            }
            return ((SimpleValue)metaValue).getValue();
        }
        return value;
    }

    public Map<String, Set<ManagedProperty>> getUnresolvedRefs() {
        return this.unresolvedRefs;
    }

    protected void checkForReferences(String key, ManagedObject mo) {
        Set<ManagedProperty> referers = this.unresolvedRefs.get(key);
        log.debug((Object)("checkForReferences, " + key + " has referers: " + referers));
        if (referers != null) {
            for (ManagedProperty prop : referers) {
                prop.setTargetManagedObject(mo);
            }
            this.unresolvedRefs.remove(key);
        }
    }

    protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO) {
        Map moProps = mo.getProperties();
        Set moOps = mo.getOperations();
        HashMap props = new HashMap(moProps);
        HashSet ops = new HashSet(moOps);
        Map runtimeProps = runtimeMO.getProperties();
        Set runtimeOps = runtimeMO.getOperations();
        if (runtimeProps != null) {
            props.putAll(runtimeProps);
        }
        if (runtimeOps != null) {
            ops.addAll(runtimeOps);
        }
        ManagedObjectImpl moi = (ManagedObjectImpl)mo;
        moi.setProperties(props);
        moi.setOperations(ops);
    }
}

