/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.managed.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.ConnMetaData;
import org.jboss.test.deployers.deployer.support.CustomName;
import org.jboss.test.deployers.deployer.support.DSMetaData;
import org.jboss.test.deployers.deployer.support.DSService;
import org.jboss.test.deployers.deployer.support.LocalDataSourceMetaData;
import org.jboss.test.deployers.deployer.support.MCFDeployer;
import org.jboss.test.deployers.deployer.support.RuntimeComponentMetaData;
import org.jboss.test.deployers.deployer.support.SecMetaData;
import org.jboss.test.deployers.deployer.support.SecurityDeployment;
import org.jboss.test.deployers.deployer.support.SimpleMetaData;
import org.jboss.test.deployers.deployer.support.TestServiceAttributeMetaData;
import org.jboss.test.deployers.deployer.support.TestServiceMetaData;
import org.jboss.test.deployers.deployer.support.TestServiceMetaDataICF;
import org.jboss.test.deployers.deployer.support.XADataSourceMetaData;
import org.jboss.test.deployers.managed.support.MockProfileService;

public class DeployerManagedDeploymentUnitTestCase
extends AbstractDeployerTest {
    private MCFDeployer deployer = new MCFDeployer();

    public static Test suite() {
        return new TestSuite(DeployerManagedDeploymentUnitTestCase.class);
    }

    public DeployerManagedDeploymentUnitTestCase(String name) {
        super(name);
    }

    public void testAnnotationScan() throws Exception {
        ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
        ManagedObject mo = mof.createManagedObject(DSMetaData.class);
        Map props = mo.getProperties();
        this.log.info((Object)("DSMetaData props: " + props));
        DeployerManagedDeploymentUnitTestCase.assertEquals((int)2, (int)props.size());
    }

    public void testComponentNameAndSetValue() throws Exception {
        DeployerClient main = this.getMainDeployer();
        MockProfileService ps = new MockProfileService(main);
        ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
        TestServiceMetaDataICF tsicf = new TestServiceMetaDataICF();
        mof.setInstanceClassFactory(TestServiceMetaData.class, (InstanceClassFactory)tsicf);
        Deployment ctx1 = this.createSimpleDeployment("deployment1");
        MutableAttachments a1 = (MutableAttachments)ctx1.getPredeterminedManagedObjects();
        DSMetaData dsmd = new DSMetaData();
        dsmd.setDiplayName("deployment1 DS");
        LocalDataSourceMetaData ds = new LocalDataSourceMetaData();
        ds.setJndiName("java:DefaultDS1");
        ds.setMaxSize(100);
        ds.setMinSize(10);
        ds.setPassword("password1".toCharArray());
        ds.setUsername("username1");
        SecMetaData smd1 = new SecMetaData();
        smd1.setDomain("java:/jaas/domain1");
        ds.setSecurityMetaData(smd1);
        ArrayList<ConnMetaData> deployments = new ArrayList<ConnMetaData>();
        deployments.add(ds);
        dsmd.setDeployments(deployments);
        a1.addAttachment(DSMetaData.class, (Object)dsmd);
        TestServiceMetaData localMBeans = new TestServiceMetaData();
        localMBeans.setObjectName("jboss.jca:service.SecurityDomain");
        localMBeans.setCode(SimpleMetaData.class.getName());
        ArrayList<TestServiceAttributeMetaData> localMBeanAttrs = new ArrayList<TestServiceAttributeMetaData>();
        localMBeanAttrs.add(new TestServiceAttributeMetaData("java:/jaas/domain1", "domain"));
        localMBeanAttrs.add(new TestServiceAttributeMetaData("java:DefaultDS1", "jndiName"));
        TestServiceAttributeMetaData typeAttribute = new TestServiceAttributeMetaData((Object)SimpleMetaData.SecurityDeploymentType.NONE, "type");
        localMBeanAttrs.add(typeAttribute);
        localMBeans.setAttributes(localMBeanAttrs);
        a1.addAttachment(TestServiceMetaData.class, (Object)localMBeans);
        ps.addDeployment(ctx1);
        Deployment ctx2 = this.createSimpleDeployment("deployment2");
        MutableAttachments a2 = (MutableAttachments)ctx2.getPredeterminedManagedObjects();
        TestServiceMetaData localMBeans2 = new TestServiceMetaData();
        localMBeans2.setCode(RuntimeComponentMetaData.class.getName());
        ArrayList<TestServiceAttributeMetaData> localMBeanAttrs2 = new ArrayList<TestServiceAttributeMetaData>();
        localMBeanAttrs2.add(new TestServiceAttributeMetaData("java:/jaas/domain2", "domain"));
        CustomName customName = new CustomName("runtime-name-1");
        localMBeanAttrs2.add(new TestServiceAttributeMetaData(customName, "customName"));
        localMBeans2.setAttributes(localMBeanAttrs2);
        a2.addAttachment(TestServiceMetaData.class, (Object)localMBeans2);
        ps.addDeployment(ctx2);
        ps.process();
        ManagedObject mo = ps.getManagedObject("java:/jaas/domain1/SecurityDomain");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)mo);
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)localMBeans.getObjectName(), (Object)mo.getComponentName());
        ManagedObject mo2 = ps.getManagedObject("java:/jaas/domain2/SecurityDomain");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)mo2);
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)customName.getName(), (Object)mo2.getComponentName());
        ManagedDeployment md = ps.getManagedDeployment("deployment1");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)md);
        ManagedComponent mc = md.getComponent("java:/jaas/domain1");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)mc);
        ManagedProperty prop = mc.getProperty("security-criteria");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)prop);
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)typeAttribute.getValue(), (Object)((Object)SimpleMetaData.SecurityDeploymentType.NONE));
        prop.setValue((Serializable)((Object)SimpleMetaData.SecurityDeploymentType.APPLICATION));
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)typeAttribute.getValue(), (Object)((Object)SimpleMetaData.SecurityDeploymentType.APPLICATION));
        ManagedProperty targetProp = mc.getProperty("jndi-name");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((Object)targetProp);
        targetProp.setValue((Serializable)((Object)"java:DefaultDS2"));
    }

    public void testManagedDeployment() throws Exception {
        DeployerClient main = this.getMainDeployer();
        MockProfileService ps = new MockProfileService(main);
        ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
        TestServiceMetaDataICF tsicf = new TestServiceMetaDataICF();
        mof.setInstanceClassFactory(TestServiceMetaData.class, (InstanceClassFactory)tsicf);
        Deployment ctx1 = this.createSimpleDeployment("deployment1");
        DSMetaData dsmd = new DSMetaData();
        dsmd.setDiplayName("deployment1 DS");
        LocalDataSourceMetaData ds = new LocalDataSourceMetaData();
        ds.setJndiName("java:DefaultDS1");
        ds.setMaxSize(100);
        ds.setMinSize(10);
        ds.setPassword("password1".toCharArray());
        ds.setUsername("username1");
        SecMetaData smd1 = new SecMetaData();
        smd1.setDomain("java:/jaas/domain1");
        ds.setSecurityMetaData(smd1);
        XADataSourceMetaData xads = new XADataSourceMetaData();
        xads.setJndiName("java:DefaultXADS2");
        ds.setMaxSize(100);
        ds.setMinSize(10);
        ds.setPassword("password2".toCharArray());
        ds.setUsername("username2");
        xads.setXaDataSourceClass("org.jboss.xa.SomeXADS");
        xads.setXaResourceTimeout(300);
        SecMetaData smd2 = new SecMetaData();
        smd2.setDomain("java:/jaas/domain2");
        xads.setSecurityMetaData(smd2);
        ArrayList<ConnMetaData> deployments = new ArrayList<ConnMetaData>();
        deployments.add(ds);
        deployments.add(xads);
        dsmd.setDeployments(deployments);
        MutableAttachments a1 = (MutableAttachments)ctx1.getPredeterminedManagedObjects();
        a1.addAttachment(DSMetaData.class, (Object)dsmd);
        TestServiceMetaData localMBeans = new TestServiceMetaData();
        localMBeans.setCode(DSService.class.getName());
        ArrayList<TestServiceAttributeMetaData> localMBeanAttrs = new ArrayList<TestServiceAttributeMetaData>();
        localMBeanAttrs.add(new TestServiceAttributeMetaData("java:DefaultDS1", "managementName"));
        localMBeans.setAttributes(localMBeanAttrs);
        a1.addAttachment(TestServiceMetaData.class, (Object)localMBeans);
        ps.addDeployment(ctx1);
        Deployment secCtx1 = this.createSimpleDeployment("sec-domain1");
        MutableAttachments sda1 = (MutableAttachments)secCtx1.getPredeterminedManagedObjects();
        SecurityDeployment sd1 = new SecurityDeployment();
        sd1.setDomainName("java:/jaas/domain1");
        sda1.addAttachment(SecurityDeployment.class, (Object)sd1);
        ps.addDeployment(secCtx1);
        Deployment secCtx2 = this.createSimpleDeployment("sec-domain2");
        MutableAttachments sda2 = (MutableAttachments)secCtx2.getPredeterminedManagedObjects();
        SecurityDeployment sd2 = new SecurityDeployment();
        sd2.setDomainName("java:/jaas/domain2");
        sda2.addAttachment(SecurityDeployment.class, (Object)sd2);
        ps.addDeployment(secCtx2);
        ps.process();
        ManagedDeployment mo1 = ps.getManagedDeployment("deployment1");
        this.validateDeployment1(mo1, ps);
        this.assertInstanceOf(mo1, Serializable.class);
        byte[] bytes = this.serialize((Serializable)mo1);
        ManagedDeployment dmo1 = (ManagedDeployment)this.deserialize(bytes);
        this.validateDeployment1(dmo1, ps);
    }

    protected void validateDeployment1(ManagedDeployment mo1, MockProfileService ps) {
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"deployment1 ManagedDeployment", (Object)mo1);
        ManagedProperty deploymentsProp = mo1.getProperty("deployments");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"deployments prop", (Object)deploymentsProp);
        Map mcs1 = mo1.getComponents();
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"deployment1 has 2 ManagedComponent", (int)2, (int)mcs1.size());
        ManagedComponent localDataMO = null;
        ManagedComponent xaDataMO = null;
        for (ManagedComponent mc : mcs1.values()) {
            if (mc.getAttachmentName().equals(LocalDataSourceMetaData.class.getName())) {
                localDataMO = mc;
                continue;
            }
            if (!mc.getAttachmentName().equals(XADataSourceMetaData.class.getName())) continue;
            xaDataMO = mc;
        }
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"LocalDataSourceMetaData MO", localDataMO);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"LocalDataSourceMetaData comp type", (Object)new ComponentType("DataSource", "LocalTx"), (Object)localDataMO.getType());
        Map localDataProps = localDataMO.getProperties();
        this.log.debug((Object)("LocalDataSourceMetaData MO.props: " + localDataProps));
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"LocalDataSourceMetaData MO.props", (Object)localDataProps);
        ManagedProperty localSecDomainProp = localDataMO.getProperty("security-domain");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"localSecDomainProp", (Object)localSecDomainProp);
        GenericValue localSecDomainPropGV = (GenericValue)localSecDomainProp.getValue();
        ManagedObject localSecDomainPropMO = (ManagedObject)localSecDomainPropGV.getValue();
        ManagedProperty localSecDomainRefProp = localSecDomainPropMO.getProperty("domain-name");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"localSecDomainRefProp", (Object)localSecDomainRefProp);
        this.log.debug((Object)("XADataSourceMetaData MO: " + xaDataMO));
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"XADataSourceMetaData", (Object)xaDataMO);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"XADataSourceMetaData comp type", (Object)new ComponentType("DataSource", "XA"), (Object)xaDataMO.getType());
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"XADataSourceMetaData MO.props", (Object)xaDataMO.getProperties());
        ManagedProperty xaSecDomainProp = xaDataMO.getProperty("security-domain");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"xaSecDomainProp", (Object)xaSecDomainProp);
        GenericValue xaSecDomainPropGV = (GenericValue)xaSecDomainProp.getValue();
        ManagedObject xaSecDomainPropMO = (ManagedObject)xaSecDomainPropGV.getValue();
        ManagedProperty xaSecDomainRefProp = xaSecDomainPropMO.getProperty("domain-name");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"xaSecDomainRefProp", (Object)xaSecDomainRefProp);
        Map<String, Set<ManagedProperty>> unresolvedRefs = ps.getUnresolvedRefs();
        this.log.info((Object)("unresolvedRefs: " + unresolvedRefs));
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"Should be 0 ManagementObjectRef", (int)0, (int)unresolvedRefs.size());
        ManagedDeployment secMD1 = ps.getManagedDeployment("sec-domain1");
        ManagedDeployment secMD2 = ps.getManagedDeployment("sec-domain2");
        this.log.info((Object)("sec-domain1 ManagedObjectNames: " + secMD1.getManagedObjectNames()));
        ManagedObject sd1MO = secMD1.getManagedObject("java:/jaas/domain1");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"java:/jaas/domain1 MO", (Object)sd1MO);
        ManagedObject localSecDomainPropTarget = localSecDomainRefProp.getTargetManagedObject();
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)sd1MO, (Object)localSecDomainPropTarget);
        ManagedObject sd2MO = secMD2.getManagedObject("java:/jaas/domain2");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"java:/jaas/domain2 MO", (Object)sd2MO);
        ManagedObject xaSecDomainPropTarget = xaSecDomainRefProp.getTargetManagedObject();
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)sd2MO, (Object)xaSecDomainPropTarget);
        Set localDataOps = localDataMO.getOperations();
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"localDataOps ops count is 4", (int)4, (int)localDataOps.size());
        ManagedOperation flushPool = null;
        ManagedOperation closePool = null;
        ManagedOperation takesString = null;
        ManagedOperation constrainedIntx10 = null;
        for (ManagedOperation op : localDataOps) {
            if (op.getName().equals("flushPool")) {
                flushPool = op;
            }
            if (op.getName().equals("closePool")) {
                closePool = op;
            }
            if (op.getName().equals("takesString")) {
                takesString = op;
            }
            if (!op.getName().equals("constrainedIntx10")) continue;
            constrainedIntx10 = op;
        }
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"flushPool found", flushPool);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"flushPool", (String)flushPool.getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"Flush the connections in the pool", (String)flushPool.getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)ManagedOperation.Impact.WriteOnly, (Object)flushPool.getImpact());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)SimpleMetaType.VOID, (Object)flushPool.getReturnType());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"zero params", (int)0, (int)flushPool.getParameters().length);
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"closePool found", (Object)closePool);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"closePool", (String)closePool.getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"Close the connections in the pool", (String)closePool.getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)ManagedOperation.Impact.WriteOnly, (Object)closePool.getImpact());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)SimpleMetaType.VOID, (Object)closePool.getReturnType());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"zero params", (int)0, (int)closePool.getParameters().length);
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"takesString found", (Object)takesString);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"takesString", (String)takesString.getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"Takes a string and returns it", (String)takesString.getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)ManagedOperation.Impact.ReadOnly, (Object)takesString.getImpact());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)SimpleMetaType.STRING, (Object)takesString.getReturnType());
        ManagedParameter[] takesStringParams = takesString.getParameters();
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"one params", (int)1, (int)takesStringParams.length);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param name", (String)"input", (String)takesStringParams[0].getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param description", (String)"The string to return", (String)takesStringParams[0].getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param type", (Object)SimpleMetaType.STRING, (Object)takesStringParams[0].getMetaType());
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"constrainedIntx10 found", (Object)constrainedIntx10);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"constrainedIntx10", (String)constrainedIntx10.getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"Takes an int and multiples by 10", (String)constrainedIntx10.getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)ManagedOperation.Impact.ReadOnly, (Object)constrainedIntx10.getImpact());
        DeployerManagedDeploymentUnitTestCase.assertEquals((Object)SimpleMetaType.INTEGER, (Object)constrainedIntx10.getReturnType());
        ManagedParameter[] constrainedIntx10Params = constrainedIntx10.getParameters();
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"one params", (int)1, (int)constrainedIntx10Params.length);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param name", (String)"input", (String)constrainedIntx10Params[0].getName());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param description", (String)"The int to multiple", (String)constrainedIntx10Params[0].getDescription());
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param type", (Object)SimpleMetaType.INTEGER, (Object)constrainedIntx10Params[0].getMetaType());
        Comparable min = constrainedIntx10Params[0].getMinimumValue();
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param min is 0", (Object)new Integer(0), (Object)min);
        DeployerManagedDeploymentUnitTestCase.assertEquals((String)"param min is 100", (Object)new Integer(100), (Object)constrainedIntx10Params[0].getMaximumValue());
        ManagedProperty rtp1 = (ManagedProperty)localDataProps.get("runtimeProp1");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"runtimeProp1", (Object)rtp1);
        ManagedProperty rtp2 = (ManagedProperty)localDataProps.get("runtimeProp2");
        DeployerManagedDeploymentUnitTestCase.assertNotNull((String)"runtimeProp2", (Object)rtp2);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer});
    }
}

