/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.managed.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.deployer.support.AllowedDsTypes;
import org.jboss.test.deployers.deployer.support.ConnMetaData;
import org.jboss.test.deployers.deployer.support.DSMetaData;
import org.jboss.test.deployers.deployer.support.LocalDataSourceMetaData;
import org.jboss.test.deployers.deployer.support.XADataSourceMetaData;
import org.jboss.test.deployers.managed.support.TestAttachment;
import org.jboss.test.deployers.managed.support.TestManagedObjectDeployer;
import org.jboss.util.graph.Graph;

public class DeployerManagedObjectUnitTestCase
extends AbstractDeployerTest {
    private TestManagedObjectDeployer deployer = new TestManagedObjectDeployer();

    public static Test suite() {
        return new TestSuite(DeployerManagedObjectUnitTestCase.class);
    }

    public DeployerManagedObjectUnitTestCase(String name) {
        super(name);
    }

    public void testManagedObject() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment context = this.createSimpleDeployment("deploy");
        main.addDeployment(context);
        main.process();
        HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add("TestManagedObjectDeployer");
        DeployerManagedObjectUnitTestCase.assertEquals(expectedTypes, (Object)context.getTypes());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)TestManagedObjectDeployer.lastAttachment);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString1", (Object)TestManagedObjectDeployer.lastAttachment.getProperty("string1"));
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString2", (Object)TestManagedObjectDeployer.lastAttachment.getProperty("string2"));
        Map mos = main.getManagedObjects(context.getName());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mos);
        ManagedObject mo = (ManagedObject)mos.get(TestAttachment.class.getName());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mo);
        Graph mosg = main.getDeepManagedObjects(context.getName());
        DeployerManagedObjectUnitTestCase.assertEquals((String)"MO Graph", (int)mosg.size(), (int)1);
        mos = (Map)mosg.getRootVertex().getData();
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mos);
        mo = (ManagedObject)mos.get(TestAttachment.class.getName());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mo);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString1", (Object)mo.getProperty("string1").getValue());
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString2", (Object)mo.getProperty("string2").getValue());
        mo.getProperty("string1").setValue((Serializable)((Object)"changedString1"));
        TestAttachment attachment = (TestAttachment)mo.getAttachment();
        MutableAttachments attachments = (MutableAttachments)context.getPredeterminedManagedObjects();
        attachments.addAttachment(TestAttachment.class, (Object)attachment);
        main.addDeployment(context);
        main.process();
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)TestManagedObjectDeployer.lastAttachment);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"changedString1", (Object)TestManagedObjectDeployer.lastAttachment.getProperty("string1"));
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString2", (Object)TestManagedObjectDeployer.lastAttachment.getProperty("string2"));
        mos = main.getManagedObjects(context.getName());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mos);
        mo = (ManagedObject)mos.get(TestAttachment.class.getName());
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)mo);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"changedString1", (Object)mo.getProperty("string1").getValue());
        DeployerManagedObjectUnitTestCase.assertEquals((Object)"initialString2", (Object)mo.getProperty("string2").getValue());
    }

    public void testDSMetaDataManagedObjectFactory() {
        ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
        ManagedObject mo = mof.createManagedObject(DSMetaData.class);
        Map propsMap = mo.getProperties();
        DeployerManagedObjectUnitTestCase.assertEquals((int)2, (int)propsMap.size());
        this.log.info((Object)("DSMetaData properties: " + propsMap));
        ManagedProperty displayName = (ManagedProperty)propsMap.get("display-name");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)displayName);
        DeployerManagedObjectUnitTestCase.assertEquals((String)"display name of DS deployment", (String)displayName.getDescription());
        DeployerManagedObjectUnitTestCase.assertEquals((Object)SimpleMetaType.STRING, (Object)displayName.getMetaType());
        ManagedProperty deployments = (ManagedProperty)propsMap.get("deployments");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)deployments);
        DeployerManagedObjectUnitTestCase.assertEquals((String)"The DS connection factories", (String)deployments.getDescription());
        CollectionMetaType deploymentsType = new CollectionMetaType(List.class.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)deploymentsType, (Object)deployments.getMetaType());
        CollectionValue value = (CollectionValue)CollectionValue.class.cast(deployments.getValue());
        CollectionMetaType valueType = value.getMetaType();
        DeployerManagedObjectUnitTestCase.assertEquals((Object)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Object)valueType.getElementType());
        DeployerManagedObjectUnitTestCase.assertEquals((int)1, (int)value.getSize());
        GenericValue localConnMOGV = (GenericValue)GenericValue.class.cast(value.getElements()[0]);
        ManagedObject localConnMO = (ManagedObject)ManagedObject.class.cast(localConnMOGV.getValue());
        DeployerManagedObjectUnitTestCase.assertEquals((String)ConnMetaData.class.getName(), (String)localConnMO.getName());
        propsMap = localConnMO.getProperties();
        DeployerManagedObjectUnitTestCase.assertEquals((int)10, (int)propsMap.size());
        this.log.info((Object)("ConnMetaData properties: " + propsMap));
        ManagedProperty dsType = (ManagedProperty)propsMap.get("datasource-type");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)dsType);
        Set dsTypeValues = dsType.getLegalValues();
        DeployerManagedObjectUnitTestCase.assertTrue((boolean)dsTypeValues.containsAll(AllowedDsTypes.values));
    }

    public void testDSMetaDataManagedObjectFactoryInit() {
        ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
        DSMetaData dsmd = new DSMetaData();
        LocalDataSourceMetaData ds = new LocalDataSourceMetaData();
        XADataSourceMetaData xads = new XADataSourceMetaData();
        ArrayList<ConnMetaData> deployments = new ArrayList<ConnMetaData>();
        deployments.add(ds);
        deployments.add(xads);
        dsmd.setDeployments(deployments);
        ManagedObject mo = mof.initManagedObject((Serializable)dsmd, null, null);
        Map propsMap = mo.getProperties();
        DeployerManagedObjectUnitTestCase.assertEquals((int)2, (int)propsMap.size());
        this.log.info((Object)("DSMetaData properties: " + propsMap));
        ManagedProperty displayName = (ManagedProperty)propsMap.get("display-name");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)displayName);
        DeployerManagedObjectUnitTestCase.assertEquals((String)"display name of DS deployment", (String)displayName.getDescription());
        DeployerManagedObjectUnitTestCase.assertEquals((Object)SimpleMetaType.STRING, (Object)displayName.getMetaType());
        ManagedProperty dsDeployments = (ManagedProperty)propsMap.get("deployments");
        DeployerManagedObjectUnitTestCase.assertNotNull(deployments);
        DeployerManagedObjectUnitTestCase.assertEquals((String)"The DS connection factories", (String)dsDeployments.getDescription());
        CollectionMetaType deploymentsType = new CollectionMetaType(List.class.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
        DeployerManagedObjectUnitTestCase.assertEquals((Object)deploymentsType, (Object)dsDeployments.getMetaType());
        CollectionValue value = (CollectionValue)CollectionValue.class.cast(dsDeployments.getValue());
        CollectionMetaType valueType = value.getMetaType();
        DeployerManagedObjectUnitTestCase.assertEquals((Object)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Object)valueType.getElementType());
        DeployerManagedObjectUnitTestCase.assertEquals((int)2, (int)value.getSize());
        ManagedObject localConnMO = null;
        ManagedObject xaConnMO = null;
        for (MetaValue md : value) {
            GenericValue tmpGV = (GenericValue)GenericValue.class.cast(md);
            ManagedObject tmpMO = (ManagedObject)ManagedObject.class.cast(tmpGV.getValue());
            if (tmpMO.getName().equals(LocalDataSourceMetaData.class.getName())) {
                localConnMO = tmpMO;
            }
            if (!tmpMO.getName().equals(XADataSourceMetaData.class.getName())) continue;
            xaConnMO = tmpMO;
        }
        DeployerManagedObjectUnitTestCase.assertNotNull(localConnMO);
        DeployerManagedObjectUnitTestCase.assertNotNull(xaConnMO);
        propsMap = localConnMO.getProperties();
        DeployerManagedObjectUnitTestCase.assertEquals((int)10, (int)propsMap.size());
        this.log.info((Object)("LocalDataSourceMetaData properties: " + propsMap));
        ManagedProperty dsType = (ManagedProperty)propsMap.get("datasource-type");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)dsType);
        Set dsTypeValues = dsType.getLegalValues();
        DeployerManagedObjectUnitTestCase.assertTrue((boolean)dsTypeValues.containsAll(AllowedDsTypes.values));
        propsMap = xaConnMO.getProperties();
        DeployerManagedObjectUnitTestCase.assertEquals((int)12, (int)propsMap.size());
        this.log.info((Object)("XADataSourceMetaData properties: " + propsMap));
        ManagedProperty xaDataSourceClass = (ManagedProperty)propsMap.get("xaDataSourceClass");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)xaDataSourceClass);
        ManagedProperty xaResourceTimeout = (ManagedProperty)propsMap.get("xaResourceTimeout");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)xaResourceTimeout);
        ManagedProperty secDomain = (ManagedProperty)propsMap.get("security-domain");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)secDomain);
        MetaType secDomainType = secDomain.getMetaType();
        DeployerManagedObjectUnitTestCase.assertEquals((Object)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Object)secDomainType);
        ManagedProperty jndiName = (ManagedProperty)propsMap.get("jndi-name");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)jndiName);
        ManagedProperty password = (ManagedProperty)propsMap.get("password");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)password);
        ManagedProperty connProperties = (ManagedProperty)propsMap.get("connection-properties");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)connProperties);
        ManagedProperty username = (ManagedProperty)propsMap.get("username");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)username);
        ManagedProperty maxSize = (ManagedProperty)propsMap.get("max-size");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)maxSize);
        ManagedProperty minSize = (ManagedProperty)propsMap.get("min-size");
        DeployerManagedObjectUnitTestCase.assertNotNull((Object)minSize);
        displayName.setValue((Serializable)((Object)"testDSMetaDataManagedObjectFactoryInit"));
        jndiName.setValue((Serializable)((Object)"java:TestDS"));
        password.setValue((Serializable)"password".toCharArray());
        username.setValue((Serializable)((Object)"username"));
        minSize.setValue((Serializable)new Integer(10));
        maxSize.setValue((Serializable)new Integer(100));
        Serializable attachment = xaConnMO.getAttachment();
        DeployerManagedObjectUnitTestCase.assertTrue((String)("attachment is a XADataSourceMetaData(" + attachment + ")"), (boolean)(attachment instanceof XADataSourceMetaData));
        XADataSourceMetaData xaDS = (XADataSourceMetaData)XADataSourceMetaData.class.cast(attachment);
        DeployerManagedObjectUnitTestCase.assertEquals((String)"jndiName", (String)"java:TestDS", (String)xaDS.getJndiName());
        DeployerManagedObjectUnitTestCase.assertEquals((String)"password", (String)"password", (String)new String(xaDS.getPassword()));
        DeployerManagedObjectUnitTestCase.assertEquals((String)"username", (String)"username", (String)xaDS.getUsername());
        DeployerManagedObjectUnitTestCase.assertEquals((String)"minSize", (int)10, (int)xaDS.getMinSize());
        DeployerManagedObjectUnitTestCase.assertEquals((String)"maxSize", (int)100, (int)xaDS.getMaxSize());
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer});
    }
}

