/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.scope.support;

import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.scope.support.TestClassAnnotation;
import org.jboss.test.deployers.scope.support.TestClassAspect;
import org.jboss.test.deployers.scope.support.TestComponentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestComponentCreator
extends AbstractRealDeployerWithInput<TestComponentMetaData> {
    AOPProxyFactory proxyFactory;

    public TestComponentCreator() {
        this.setDeploymentVisitor(new TestComponentMetaDataVisitor());
        this.setWantComponents(true);
        this.proxyFactory = new GeneratedAOPProxyFactory();
        AspectManager domain = AspectManager.instance();
        try {
            AdviceBinding binding = new AdviceBinding("execution(* @" + TestClassAnnotation.class.getName() + "->*(..))", null);
            binding.addInterceptorFactory((InterceptorFactory)new GenericInterceptorFactory(TestClassAspect.class));
            domain.addBinding(binding);
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up advices ", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestComponentMetaDataVisitor
    implements DeploymentVisitor<TestComponentMetaData> {
        public Class<TestComponentMetaData> getVisitorType() {
            return TestComponentMetaData.class;
        }

        public void deploy(DeploymentUnit unit, TestComponentMetaData deployment) throws DeploymentException {
            Object target;
            Class<?> deploymentClass = deployment.clazz;
            try {
                target = deploymentClass.newInstance();
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Error instantiating object", (Throwable)e);
            }
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            params.setTarget(target);
            params.setMetaData(unit.getMetaData());
            params.setMetaDataHasInstanceLevelData(true);
            Object proxy = TestComponentCreator.this.proxyFactory.createAdvisedProxy(params);
            unit.addAttachment("proxy", proxy);
        }

        public void undeploy(DeploymentUnit unit, TestComponentMetaData deployment) {
            unit.removeAttachment("proxy");
        }
    }
}

