/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.scope.test;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.plugins.deployers.DeployersImpl;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.scope.support.TestComponentDeployer;
import org.jboss.test.deployers.scope.support.TestComponentMetaData;
import org.jboss.test.deployers.scope.support.TestComponentMetaDataContainer;

public class DeployerScopeUnitTestCase
extends AbstractDeployerTest {
    private static final DeploymentFactory factory = new DeploymentFactory();
    private TestComponentDeployer deployer = new TestComponentDeployer();
    private BasicMetaDataRepository repository;
    private Set<ScopeKey> scopes = new HashSet<ScopeKey>();
    public static ScopeKey SCOPE_A = DeployerScopeUnitTestCase.createAppScope("A");
    public static ScopeKey SCOPE_AA = DeployerScopeUnitTestCase.createScope("A", "A");

    public static ScopeKey createAppScope(String app) {
        return new ScopeKey(CommonLevels.APPLICATION, (Object)app);
    }

    public static ScopeKey createDepScope(String dep) {
        return new ScopeKey(CommonLevels.DEPLOYMENT, (Object)dep);
    }

    public static ScopeKey createInstanceScope(String name) {
        return new ScopeKey(CommonLevels.INSTANCE, (Object)name);
    }

    public static ScopeKey createScope(String app, String dep) {
        ScopeKey result = ScopeKey.DEFAULT_SCOPE.clone();
        result.addScope(CommonLevels.APPLICATION, (Object)app);
        result.addScope(CommonLevels.DEPLOYMENT, (Object)dep);
        return result;
    }

    public static ScopeKey createComponentScope(String app, String dep, String comp) {
        ScopeKey result = DeployerScopeUnitTestCase.createScope(app, dep);
        result.addScope(CommonLevels.INSTANCE, (Object)comp);
        return result;
    }

    public static Test suite() {
        return new TestSuite(DeployerScopeUnitTestCase.class);
    }

    public DeployerScopeUnitTestCase(String name) {
        super(name);
    }

    public void testSimpleScope() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        main.addDeployment(a);
        main.process();
        DeploymentUnit unit = this.getDeploymentUnit(main, "A");
        this.assertScope(SCOPE_AA, SCOPE_A, unit);
        main.removeDeployment(a);
        main.process();
        this.assertNoScopes();
    }

    public void testSubDeploymentScope() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        factory.addContext((PredeterminedManagedObjectAttachments)a, "A1");
        factory.addContext((PredeterminedManagedObjectAttachments)a, "A2");
        main.addDeployment(a);
        main.process();
        DeploymentUnit unit = this.getDeploymentUnit(main, "A");
        this.assertScope(SCOPE_AA, SCOPE_A, unit);
        List children = unit.getChildren();
        DeployerScopeUnitTestCase.assertEquals((int)2, (int)children.size());
        for (DeploymentUnit child : children) {
            ScopeKey scope = DeployerScopeUnitTestCase.createScope("A", child.getName());
            ScopeKey mutable = DeployerScopeUnitTestCase.createDepScope(child.getName());
            this.assertScope(scope, mutable, child);
        }
        main.removeDeployment(a);
        main.process();
        this.assertNoScopes();
    }

    public void testSimpleComponents() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestComponentMetaData c1 = new TestComponentMetaData("C1");
        TestComponentMetaData c2 = new TestComponentMetaData("C2");
        TestComponentMetaDataContainer md = new TestComponentMetaDataContainer(c1, c2);
        DeployerScopeUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, md);
        main.addDeployment(a);
        main.process();
        DeploymentUnit unit = this.getDeploymentUnit(main, "A");
        this.assertScope(SCOPE_AA, SCOPE_A, unit);
        List components = unit.getComponents();
        DeployerScopeUnitTestCase.assertEquals((int)2, (int)components.size());
        for (DeploymentUnit component : components) {
            ScopeKey scope = DeployerScopeUnitTestCase.createComponentScope("A", "A", component.getName());
            ScopeKey mutable = DeployerScopeUnitTestCase.createInstanceScope(component.getName());
            this.assertScope(scope, mutable, component);
        }
        main.removeDeployment(a);
        main.process();
        this.assertNoScopes();
    }

    public void testSubDeploymentScopeWithComponents() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        ContextInfo a1 = factory.addContext((PredeterminedManagedObjectAttachments)a, "A1");
        TestComponentMetaData a1c1 = new TestComponentMetaData("A1C1");
        TestComponentMetaData a1c2 = new TestComponentMetaData("A1C2");
        TestComponentMetaDataContainer md1 = new TestComponentMetaDataContainer(a1c1, a1c2);
        DeployerScopeUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a1, md1);
        ContextInfo a2 = factory.addContext((PredeterminedManagedObjectAttachments)a, "A2");
        TestComponentMetaData a2c1 = new TestComponentMetaData("A2C1");
        TestComponentMetaData a2c2 = new TestComponentMetaData("A2C2");
        TestComponentMetaDataContainer md2 = new TestComponentMetaDataContainer(a2c1, a2c2);
        DeployerScopeUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a2, md2);
        main.addDeployment(a);
        main.process();
        DeploymentUnit unit = this.getDeploymentUnit(main, "A");
        this.assertScope(SCOPE_AA, SCOPE_A, unit);
        List children = unit.getChildren();
        DeployerScopeUnitTestCase.assertEquals((int)2, (int)children.size());
        for (DeploymentUnit child : children) {
            ScopeKey scope = DeployerScopeUnitTestCase.createScope("A", child.getName());
            ScopeKey mutable = DeployerScopeUnitTestCase.createDepScope(child.getName());
            this.assertScope(scope, mutable, child);
            List components = child.getComponents();
            DeployerScopeUnitTestCase.assertEquals((int)2, (int)components.size());
            for (DeploymentUnit component : components) {
                scope = DeployerScopeUnitTestCase.createComponentScope("A", child.getName(), component.getName());
                mutable = DeployerScopeUnitTestCase.createInstanceScope(component.getName());
                this.assertScope(scope, mutable, component);
            }
        }
        main.removeDeployment(a);
        main.process();
        this.assertNoScopes();
    }

    protected void assertScope(ScopeKey scope, ScopeKey mutable, DeploymentUnit unit) {
        this.scopes.add(scope);
        this.scopes.add(mutable);
        DeployerScopeUnitTestCase.assertEquals((Object)scope, (Object)unit.getScope());
        DeployerScopeUnitTestCase.assertEquals((Object)mutable, (Object)unit.getMutableScope());
        MetaData metaData = unit.getMetaData();
        DeployerScopeUnitTestCase.assertNotNull((String)("Should have metadata for " + unit.getName()), (Object)metaData);
        String expected = null;
        DeploymentUnit parent = unit.getParent();
        if (parent != null) {
            expected = parent.getName();
        }
        DeployerScopeUnitTestCase.assertEquals((Object)expected, (Object)metaData.getMetaData("test"));
        MutableMetaData mutableMetaData = unit.getMutableMetaData();
        mutableMetaData.addMetaData("test", (Object)unit.getName(), String.class);
        DeployerScopeUnitTestCase.assertEquals((Object)unit.getName(), (Object)metaData.getMetaData("test"));
    }

    protected void assertNoScopes() {
        for (ScopeKey scope : this.scopes) {
            DeployerScopeUnitTestCase.assertNull((String)(scope + " should have been removed"), (Object)this.repository.getMetaData(scope));
            DeployerScopeUnitTestCase.assertNull((String)(scope + " should have been removed"), (Object)this.repository.getMetaDataRetrieval(scope));
        }
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, TestComponentMetaDataContainer md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(TestComponentMetaDataContainer.class, (Object)md);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer});
    }

    protected Deployers createDeployers() {
        DeployersImpl deployers = (DeployersImpl)super.createDeployers();
        this.repository = new BasicMetaDataRepository();
        deployers.setRepository((MutableMetaDataRepository)this.repository);
        return deployers;
    }
}

