/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.scope.test;

import java.lang.annotation.Annotation;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.plugins.deployers.DeployersImpl;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.test.deployers.AbstractDeployerTest;
import org.jboss.test.deployers.scope.support.TestClassAnnotation;
import org.jboss.test.deployers.scope.support.TestClassAspect;
import org.jboss.test.deployers.scope.support.TestComponent1;
import org.jboss.test.deployers.scope.support.TestComponent2;
import org.jboss.test.deployers.scope.support.TestComponentCreator;
import org.jboss.test.deployers.scope.support.TestComponentDeployer;
import org.jboss.test.deployers.scope.support.TestComponentMetaData;
import org.jboss.test.deployers.scope.support.TestComponentMetaDataContainer;
import org.jboss.test.deployers.scope.support.TestComponentMetaDataRepositoryPopulator;

public class PopulateMetaDataRepositoryUnitTestCase
extends AbstractDeployerTest {
    private TestComponentDeployer deployer1 = new TestComponentDeployer();
    private TestComponentMetaDataRepositoryPopulator deployer2 = new TestComponentMetaDataRepositoryPopulator();
    private TestComponentCreator deployer3 = new TestComponentCreator();
    private BasicMetaDataRepository repository;

    public static Test suite() {
        return new TestSuite(PopulateMetaDataRepositoryUnitTestCase.class);
    }

    public PopulateMetaDataRepositoryUnitTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassAnnotation() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestComponentMetaData c = new TestComponentMetaData("C");
        c.clazz = TestComponent1.class;
        TestComponentMetaDataContainer md = new TestComponentMetaDataContainer(c);
        PopulateMetaDataRepositoryUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, md);
        main.addDeployment(a);
        try {
            main.process();
            main.checkComplete();
            DeploymentUnit unit = this.getDeploymentUnit(main, "A");
            List components = unit.getComponents();
            PopulateMetaDataRepositoryUnitTestCase.assertEquals((int)1, (int)components.size());
            DeploymentUnit component = (DeploymentUnit)components.get(0);
            TestComponent1 proxy = (TestComponent1)component.getAttachment("proxy", TestComponent1.class);
            TestClassAspect.classAnnotation = null;
            proxy.doSomething();
            TestClassAnnotation annotation = TestClassAspect.classAnnotation;
            PopulateMetaDataRepositoryUnitTestCase.assertNotNull((Object)annotation);
            PopulateMetaDataRepositoryUnitTestCase.assertEquals((String)"Class", (String)annotation.where());
        }
        finally {
            main.removeDeployment(a);
            main.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstanceAnnotation() throws Exception {
        DeployerClient main = this.getMainDeployer();
        Deployment a = this.createSimpleDeployment("A");
        TestComponentMetaData c = new TestComponentMetaData("C");
        c.clazz = TestComponent2.class;
        c.classAnnotations.add((Annotation)AnnotationCreator.createAnnotation((String)("@" + TestClassAnnotation.class.getName() + "(where=\"Instance\")"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        TestComponentMetaDataContainer md = new TestComponentMetaDataContainer(c);
        PopulateMetaDataRepositoryUnitTestCase.addMetaData((PredeterminedManagedObjectAttachments)a, md);
        main.addDeployment(a);
        try {
            main.process();
            main.checkComplete();
            DeploymentUnit unit = this.getDeploymentUnit(main, "A");
            List components = unit.getComponents();
            PopulateMetaDataRepositoryUnitTestCase.assertEquals((int)1, (int)components.size());
            DeploymentUnit component = (DeploymentUnit)components.get(0);
            TestComponent2 proxy = (TestComponent2)component.getAttachment("proxy", TestComponent2.class);
            TestClassAspect.classAnnotation = null;
            proxy.doSomething();
            TestClassAnnotation annotation = TestClassAspect.classAnnotation;
            PopulateMetaDataRepositoryUnitTestCase.assertNotNull((Object)annotation);
            PopulateMetaDataRepositoryUnitTestCase.assertEquals((String)"Instance", (String)annotation.where());
        }
        finally {
            main.removeDeployment(a);
            main.process();
        }
    }

    protected static void addMetaData(PredeterminedManagedObjectAttachments attachments, TestComponentMetaDataContainer md) {
        MutableAttachments mutable = (MutableAttachments)attachments.getPredeterminedManagedObjects();
        mutable.addAttachment(TestComponentMetaDataContainer.class, (Object)md);
    }

    protected DeployerClient getMainDeployer() {
        return this.createMainDeployer(new Deployer[]{this.deployer1, this.deployer2, this.deployer3});
    }

    protected Deployers createDeployers() {
        DeployersImpl deployers = (DeployersImpl)super.createDeployers();
        this.repository = new BasicMetaDataRepository();
        deployers.setRepository((MutableMetaDataRepository)this.repository);
        return deployers;
    }
}

