/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.version.test;

import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.deployers.structure.spi.classloading.VersionComparator;
import org.jboss.deployers.structure.spi.classloading.VersionComparatorRegistry;
import org.jboss.deployers.structure.spi.classloading.helpers.VersionImpl;
import org.jboss.test.BaseTestCase;
import org.jboss.test.deployers.structure.version.support.DVIVersionComparator;
import org.jboss.test.deployers.structure.version.support.DummyVersion;
import org.jboss.test.deployers.structure.version.support.DummyVersionComparator;

public abstract class AbstractVersionTest
extends BaseTestCase {
    protected AbstractVersionTest(String name) {
        super(name);
    }

    protected void registerVersionComparators() throws Exception {
        VersionComparatorRegistry registry = VersionComparatorRegistry.getInstance();
        DummyVersionComparator dummyVersionComparator = new DummyVersionComparator();
        DVIVersionComparator dviVersionComparator = new DVIVersionComparator();
        registry.registerVersionComparator(DummyVersion.class, (VersionComparator)dummyVersionComparator);
        registry.registerVersionComparator(DummyVersion.class, VersionImpl.class, (VersionComparator)dviVersionComparator);
    }

    protected void clearVersionComparators() throws Exception {
        VersionComparatorRegistry registry = VersionComparatorRegistry.getInstance();
        registry.removeVersionComparator(DummyVersion.class);
        AbstractVersionTest.assertNull((Object)registry.getComparator(DummyVersion.class, DummyVersion.class));
        registry.removeVersionComparator(DummyVersion.class, VersionImpl.class);
        AbstractVersionTest.assertNull((Object)registry.getComparator(DummyVersion.class, VersionImpl.class));
    }

    protected void assertFailVersion(int major, int minor, int micro, String qualifier) {
        try {
            VersionImpl version = new VersionImpl(major, minor, micro, qualifier);
            AbstractVersionTest.fail((String)("Should not be here: " + version));
        }
        catch (Exception e) {
            this.assertInstanceOf(e, IllegalArgumentException.class);
        }
    }

    protected void assertFailVersion(Version v1, Version v2) {
        try {
            AbstractVersionTest.assertNotNull((Object)v1);
            AbstractVersionTest.assertNotNull((Object)v2);
            v1.compareTo(v2);
            AbstractVersionTest.fail((String)"Should not be here.");
        }
        catch (Exception e) {
            this.assertInstanceOf(e, IllegalArgumentException.class);
        }
    }

    protected void assertGreater(Version v1, Version v2) {
        AbstractVersionTest.assertTrue((v1.compareTo(v2) > 0 ? 1 : 0) != 0);
    }

    protected void assertLess(Version v1, Version v2) {
        AbstractVersionTest.assertTrue((v1.compareTo(v2) < 0 ? 1 : 0) != 0);
    }

    protected void assertEquals(Version v1, Version v2) {
        AbstractVersionTest.assertTrue((v1.compareTo(v2) == 0 ? 1 : 0) != 0);
    }
}

