/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.version.test;

import junit.framework.Test;
import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.deployers.structure.spi.classloading.helpers.VersionImpl;
import org.jboss.test.deployers.structure.version.test.AbstractVersionTest;

public class VersionImplTestCase
extends AbstractVersionTest {
    public VersionImplTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return VersionImplTestCase.suite(VersionImplTestCase.class);
    }

    protected void assertVersion(VersionImpl version) {
        VersionImplTestCase.assertEquals((int)1, (int)version.getMajor());
        VersionImplTestCase.assertEquals((int)2, (int)version.getMinor());
        VersionImplTestCase.assertEquals((int)3, (int)version.getMicro());
        VersionImplTestCase.assertEquals((String)"CR1", (String)version.getQualifier());
        this.assertEquals((Version)new VersionImpl(1, 2, 3, "CR1"), (Version)version);
    }

    public void testSimpleVersion() throws Exception {
        this.assertVersion(new VersionImpl(1, 2, 3, "CR1"));
        this.assertVersion(VersionImpl.parseVersion((String)"1.2.3.CR1"));
        this.assertEquals(Version.DEFAULT_VERSION, (Version)VersionImpl.parseVersion(null));
        this.assertEquals((Version)new VersionImpl(1, 2, 3), (Version)VersionImpl.parseVersion((String)"1.2.3"));
    }

    public void testIllegalVersion() throws Exception {
        this.assertFailVersion(-1, 2, 3, "Beta10");
        this.assertFailVersion(1, -2, 3, "CR1");
        this.assertFailVersion(1, 2, -3, "CR2");
        this.assertFailVersion(1, 2, 3, "GA@");
    }

    public void testCompareVersion() throws Exception {
        VersionImpl v1 = new VersionImpl(1, 2, 3);
        VersionImpl v2 = new VersionImpl(1, 2, 4);
        this.assertLess((Version)v1, (Version)v2);
        this.assertGreater((Version)v2, (Version)v1);
        this.assertEquals((Version)v1, (Version)VersionImpl.parseVersion((String)"1.2.3"));
        VersionImpl v3 = new VersionImpl(1, 2, 3, "CR1");
        VersionImpl v4 = new VersionImpl(1, 2, 3, "CR2");
        this.assertLess((Version)v3, (Version)v4);
        this.assertGreater((Version)v4, (Version)v3);
        this.assertEquals((Version)v3, (Version)VersionImpl.parseVersion((String)"1.2.3.CR1"));
        VersionImpl v5 = new VersionImpl(1, 2, 3);
        VersionImpl v6 = new VersionImpl(1, 3, 0);
        this.assertLess((Version)v5, (Version)v6);
        this.assertGreater((Version)v6, (Version)v5);
        VersionImpl v7 = new VersionImpl(1, 2, 3);
        VersionImpl v8 = new VersionImpl(2, 0, 0);
        this.assertLess((Version)v7, (Version)v8);
        this.assertGreater((Version)v8, (Version)v7);
    }
}

