/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.helpers.ManagedObjectsWithTransientAttachmentsImpl;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentContextVisitor;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.DefaultDeploymentContextComparator;
import org.jboss.deployers.structure.spi.helpers.DeploymentResourceClassLoader;
import org.jboss.deployers.structure.spi.helpers.EmptyResourceLoader;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.deployers.structure.spi.scope.helpers.DefaultScopeBuilder;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentContext
extends ManagedObjectsWithTransientAttachmentsImpl
implements DeploymentContext {
    private static final long serialVersionUID = 7368360479461613969L;
    private static final Logger log = Logger.getLogger(AbstractDeploymentContext.class);
    private String name;
    private String simpleName;
    private String relativePath;
    private DeploymentState state;
    private Throwable problem;
    private Deployment deployment;
    private transient DeploymentUnit unit;
    private transient ClassLoader classLoader;
    private transient ClassLoaderFactory classLoaderFactory;
    private transient ClassLoader resourceClassLoader;
    private boolean deployed;
    private DeploymentContext parent;
    private Set<String> deploymentTypes = new CopyOnWriteArraySet<String>();
    private SortedSet<DeploymentContext> children;
    private List<DeploymentContext> components = new CopyOnWriteArrayList<DeploymentContext>();
    private int relativeOrder;
    private Comparator<DeploymentContext> comparator = DefaultDeploymentContextComparator.INSTANCE;
    private ScopeKey scope;
    private ScopeKey mutableScope;

    public static ScopeBuilder getScopeBuilder(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder != null) {
            return builder;
        }
        DeploymentContext parent = deploymentContext.getParent();
        if (parent != null) {
            return AbstractDeploymentContext.getScopeBuilder(parent);
        }
        return DefaultScopeBuilder.INSTANCE;
    }

    public static MutableMetaDataRepository getRepository(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        MutableMetaDataRepository repository = (MutableMetaDataRepository)deploymentContext.getTransientAttachments().getAttachment(MutableMetaDataRepository.class);
        if (repository != null) {
            return repository;
        }
        DeploymentContext parent = deploymentContext.getParent();
        if (parent == null) {
            return null;
        }
        return AbstractDeploymentContext.getRepository(parent);
    }

    public static void cleanupRepository(DeploymentContext deploymentContext) {
        ScopeKey scope;
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return;
        }
        try {
            scope = deploymentContext.getScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            scope = deploymentContext.getMutableScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MetaData getMetaData(DeploymentContext deploymentContext) {
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return null;
        }
        MetaData metaData = repository.getMetaData(deploymentContext.getScope());
        if (metaData == null) {
            AbstractDeploymentContext.initMetaDataRetrieval(repository, deploymentContext);
            metaData = repository.getMetaData(deploymentContext.getScope());
        }
        return metaData;
    }

    public static MutableMetaDataLoader getMutableMetaData(DeploymentContext deploymentContext) {
        MetaDataContext context;
        List locals;
        MutableMetaDataRepository repository = AbstractDeploymentContext.getRepository(deploymentContext);
        if (repository == null) {
            return null;
        }
        ScopeKey mutableScope = deploymentContext.getMutableScope();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(mutableScope);
        if (retrieval == null) {
            AbstractDeploymentContext.initMutableMetaDataRetrieval(repository, deploymentContext);
            retrieval = repository.getMetaDataRetrieval(mutableScope);
        }
        if (retrieval == null) {
            return null;
        }
        if (retrieval instanceof MutableMetaDataLoader) {
            return (MutableMetaDataLoader)retrieval;
        }
        if (retrieval instanceof MetaDataContext && (locals = (context = (MetaDataContext)retrieval).getLocalRetrievals()) != null) {
            for (MetaDataRetrieval local : locals) {
                if (!(local instanceof MutableMetaDataLoader)) continue;
                return (MutableMetaDataLoader)local;
            }
        }
        return null;
    }

    private static void initMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder == null) {
            builder = DefaultScopeBuilder.INSTANCE;
        }
        builder.initMetaDataRetrieval(repository, deploymentContext);
    }

    private static void initMutableMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
        if (builder == null) {
            builder = DefaultScopeBuilder.INSTANCE;
        }
        builder.initMutableMetaDataRetrieval(repository, deploymentContext);
    }

    public AbstractDeploymentContext() {
    }

    public AbstractDeploymentContext(String name, String relativePath) {
        this(name, name, relativePath);
    }

    public AbstractDeploymentContext(String name, String simpleName, String relativePath) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Null relative path");
        }
        this.name = name;
        this.simpleName = simpleName;
        if (simpleName == null) {
            this.simpleName = name;
        }
        this.relativePath = relativePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    @Override
    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    @Override
    public Comparator<DeploymentContext> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<DeploymentContext> comparator) {
        if (comparator == null) {
            comparator = DefaultDeploymentContextComparator.INSTANCE;
        }
        this.comparator = comparator;
    }

    @Override
    public Set<String> getTypes() {
        return this.deploymentTypes;
    }

    @Override
    public ScopeKey getScope() {
        if (this.scope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.scope = builder.getDeploymentScope(this);
        }
        return this.scope;
    }

    @Override
    public void setScope(ScopeKey scope) {
        this.scope = scope;
    }

    @Override
    public ScopeKey getMutableScope() {
        if (this.mutableScope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.mutableScope = builder.getMutableDeploymentScope(this);
        }
        return this.mutableScope;
    }

    @Override
    public void setMutableScope(ScopeKey mutableScope) {
        this.mutableScope = mutableScope;
    }

    @Override
    public MetaData getMetaData() {
        return AbstractDeploymentContext.getMetaData(this);
    }

    @Override
    public MutableMetaData getMutableMetaData() {
        return AbstractDeploymentContext.getMutableMetaData(this);
    }

    @Override
    public DeploymentState getState() {
        return this.state;
    }

    @Override
    public void setState(DeploymentState state) {
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.state = state;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public void setDeployment(Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.deployment = deployment;
        this.deployment.setTypes(this.getTypes());
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        if (this.unit == null) {
            this.unit = this.createDeploymentUnit();
        }
        return this.unit;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader != null) {
            log.trace((Object)("ClassLoader for " + this.name + " is " + classLoader));
        }
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return false;
        }
        try {
            cl = factory.createClassLoader(this);
            if (cl != null) {
                this.setClassLoader(cl);
                this.classLoaderFactory = factory;
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error creating classloader for " + this.getName()), (Throwable)t);
        }
        return true;
    }

    @Override
    public void removeClassLoader() {
        if (this.classLoaderFactory == null) {
            return;
        }
        try {
            this.classLoaderFactory.removeClassLoader(this);
        }
        catch (Throwable t) {
            log.warn((Object)("Error removing classloader for " + this.getName()), t);
        }
        this.classLoaderFactory = null;
        this.setClassLoader(null);
    }

    @Override
    public void removeClassLoader(ClassLoaderFactory factory) {
        if (this.classLoaderFactory == factory) {
            this.removeClassLoader();
        }
    }

    @Override
    public boolean isTopLevel() {
        return this.parent == null;
    }

    @Override
    public DeploymentContext getTopLevel() {
        DeploymentContext result = this;
        for (DeploymentContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result = parent;
        }
        return result;
    }

    @Override
    public DeploymentContext getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DeploymentContext parent) {
        if (parent != null && this.parent != null) {
            throw new IllegalStateException("Context already has a parent " + this.getName());
        }
        this.parent = parent;
    }

    @Override
    public List<DeploymentContext> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<DeploymentContext>(this.children);
    }

    @Override
    public void addChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        if (this.children == null) {
            this.children = new TreeSet<DeploymentContext>(this.comparator);
        }
        this.children.add(child);
    }

    @Override
    public boolean removeChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        if (this.children == null) {
            return false;
        }
        return this.children.remove(child);
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public List<DeploymentContext> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public void addComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.deployed();
        this.components.add(component);
        log.debug((Object)("Added component " + component.getName() + " to " + this.getName()));
    }

    @Override
    public boolean removeComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        List<DeploymentContext> componentComponents = component.getComponents();
        if (!componentComponents.isEmpty()) {
            log.warn((Object)("Removing component " + this.name + " which still has components " + componentComponents));
        }
        boolean result = this.components.remove(component);
        component.cleanup();
        if (result) {
            log.debug((Object)("Removed component " + component.getName() + " from " + this.getName()));
        }
        return result;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        if (this.resourceClassLoader != null) {
            return this.resourceClassLoader;
        }
        DeploymentResourceLoader loader = this.getResourceLoader();
        this.resourceClassLoader = new DeploymentResourceClassLoader(loader);
        return this.resourceClassLoader;
    }

    @Override
    public DeploymentResourceLoader getResourceLoader() {
        return EmptyResourceLoader.INSTANCE;
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        ControllerContext controllerContext = (ControllerContext)this.getTransientAttachments().getAttachment(ControllerContext.class);
        if (controllerContext != null) {
            return controllerContext.getDependencyInfo();
        }
        DeploymentContext parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Deployment ControllerContext has not been set");
        }
        return parent.getDependencyInfo();
    }

    @Override
    public void visit(DeploymentContextVisitor visitor) throws DeploymentException {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(this, visitor);
    }

    private void visit(DeploymentContext context, DeploymentContextVisitor visitor) throws DeploymentException {
        visitor.visit(context);
        try {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            DeploymentContext[] childContexts = children.toArray(new DeploymentContext[children.size()]);
            for (int i = 0; i < childContexts.length; ++i) {
                if (childContexts[i] == null) {
                    throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
                }
                try {
                    this.visit(childContexts[i], visitor);
                    continue;
                }
                catch (Throwable t) {
                    for (int j = i - 1; j >= 0; --j) {
                        this.visitError(childContexts[j], visitor, true);
                    }
                    throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + childContexts[i].getName()), (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            this.visitError(context, visitor, false);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + context.getName()), (Throwable)t);
        }
    }

    private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren) throws DeploymentException {
        if (visitChildren) {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            for (DeploymentContext child : children) {
                try {
                    this.visitError(child, visitor, true);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during visit error: " + child.getName()), t);
                }
            }
        }
        try {
            visitor.error(context);
        }
        catch (Throwable t) {
            log.warn((Object)("Error during visit error: " + context.getName()), t);
        }
    }

    @Override
    public Throwable getProblem() {
        return this.problem;
    }

    @Override
    public void setProblem(Throwable problem) {
        this.problem = problem;
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public void deployed() {
        this.deployed = true;
    }

    @Override
    public void cleanup() {
        AbstractDeploymentContext.cleanupRepository(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('{').append(this.name).append('}');
        return buffer.toString();
    }

    protected DeploymentUnit createDeploymentUnit() {
        return new AbstractDeploymentUnit(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = in.readUTF();
        this.simpleName = in.readUTF();
        this.relativePath = in.readUTF();
        this.state = (DeploymentState)in.readObject();
        this.problem = (Throwable)in.readObject();
        this.deployment = (Deployment)in.readObject();
        this.deployed = in.readBoolean();
        this.parent = (DeploymentContext)in.readObject();
        this.deploymentTypes = (Set)in.readObject();
        this.children = (SortedSet)in.readObject();
        this.components = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.name);
        out.writeUTF(this.simpleName);
        out.writeUTF(this.relativePath);
        out.writeObject(this.state);
        out.writeObject(this.problem);
        out.writeObject(this.deployment);
        out.writeBoolean(this.deployed);
        out.writeObject(this.parent);
        out.writeObject(this.deploymentTypes);
        out.writeObject(this.children);
        out.writeObject(this.components);
    }
}

