/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.deployers.structure.spi.StructureBuilder;

public class AbstractStructuralDeployers
implements StructuralDeployers {
    private StructureBuilder structureBuilder;

    public StructureBuilder getStructureBuilder() {
        return this.structureBuilder;
    }

    public void setStructureBuilder(StructureBuilder structureBuilder) {
        this.structureBuilder = structureBuilder;
    }

    public DeploymentContext determineStructure(Deployment deployment) throws DeploymentException {
        StructureBuilder builder = this.getStructureBuilder();
        if (builder == null) {
            throw new IllegalStateException("No structure builder has been configured");
        }
        Throwable problem = null;
        Attachments attachments = deployment.getPredeterminedManagedObjects();
        StructureMetaData structureMetaData = (StructureMetaData)attachments.getAttachment(StructureMetaData.class);
        if (structureMetaData == null) {
            structureMetaData = StructureMetaDataFactory.createStructureMetaData();
            try {
                this.determineStructure(deployment, structureMetaData);
            }
            catch (Throwable t) {
                problem = t;
            }
        }
        DeploymentContext result = this.structureBuilder.populateContext(deployment, structureMetaData);
        if (problem != null) {
            result.setState(DeploymentState.ERROR);
            result.setProblem(problem);
        }
        return result;
    }

    protected void determineStructure(Deployment deployment, StructureMetaData structure) throws Exception {
    }
}

