/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.guice.plugins;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.SourceProviders;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.guice.plugins.GuiceObject;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceInjectorFactory
implements Injector {
    private Kernel kernel;
    private Injector injector;
    private Set<String> objects;

    private GuiceInjectorFactory(Kernel kernel, Injector injector, Set<String> objects) {
        this.kernel = kernel;
        this.injector = injector;
        this.objects = objects;
    }

    public static Injector createInjector(final Kernel kernel, final GuiceObject ... guiceObjects) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel.");
        }
        final HashSet<String> objects = new HashSet<String>();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                KernelController controller = kernel.getController();
                ArrayList<Throwable> errors = null;
                for (GuiceObject gObject : guiceObjects) {
                    try {
                        String name = gObject.geName();
                        Object target = gObject.createObject(kernel, this.binder());
                        if (target == null) {
                            throw new IllegalArgumentException("Null target.");
                        }
                        String beanClassName = target.getClass().getName();
                        AbstractBeanMetaData beanMetaData = new AbstractBeanMetaData(name, beanClassName);
                        KernelControllerContext context = controller.install((BeanMetaData)beanMetaData, target);
                        objects.add(name);
                        controller.change((ControllerContext)context, ControllerState.INSTALLED);
                    }
                    catch (Throwable t) {
                        if (errors == null) {
                            errors = new ArrayList<Throwable>();
                        }
                        errors.add(t);
                    }
                }
                if (errors != null) {
                    throw new Error("Exception during Guice Objects installation: " + errors);
                }
            }
        }});
        return new GuiceInjectorFactory(kernel, injector, objects);
    }

    public void destroy() {
        KernelController controller = this.kernel.getController();
        for (String name : this.objects) {
            if (controller.getInstalledContext((Object)name) == null) continue;
            controller.uninstall((Object)name);
        }
        this.objects.clear();
        this.objects = null;
        this.kernel = null;
    }

    public void injectMembers(Object o) {
        this.injector.injectMembers(o);
    }

    public Map<Key<?>, Binding<?>> getBindings() {
        return this.injector.getBindings();
    }

    public <T> Binding<T> getBinding(Key<T> key) {
        return this.injector.getBinding(key);
    }

    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.injector.findBindingsByType(type);
    }

    public <T> Provider<T> getProvider(Key<T> key) {
        return this.injector.getProvider(key);
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.injector.getProvider(type);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    static {
        SourceProviders.skip(GuiceInjectorFactory.class);
    }
}

