/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelScopeInfo
extends AbstractScopeInfo {
    private BeanMetaData beanMetaData;

    public KernelScopeInfo(Object name, String className, BeanMetaData beanMetaData) {
        super(name, className);
        this.beanMetaData = beanMetaData;
    }

    public ScopeKey getScope() {
        Class<?> clazz;
        ClassLoader cl;
        ScopeKey key = super.getScope();
        Scope scope = key.getScope(CommonLevels.CLASS);
        if (scope == null) {
            return key;
        }
        Object qualifier = scope.getQualifier();
        if (qualifier instanceof Class) {
            return key;
        }
        String className = (String)qualifier;
        try {
            cl = Configurator.getClassLoader(this.beanMetaData);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting classloader for " + key, t);
        }
        try {
            clazz = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class: " + className + " for " + key, e);
        }
        key.addScope(new Scope(CommonLevels.CLASS, clazz));
        return key;
    }

    public void addMetaData(MutableMetaDataRepository repository, ControllerContext context, MemoryMetaDataLoader mutable) {
        if (!(context instanceof KernelControllerContext)) {
            return;
        }
        KernelControllerContext theContext = (KernelControllerContext)context;
        this.addClassAnnotations(mutable, theContext);
        this.addPropertyAnnotations(mutable, theContext);
    }

    private void addClassAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData != null) {
            ClassLoader cl;
            try {
                cl = Configurator.getClassLoader(beanMetaData);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting classloader for " + beanMetaData.getName(), t);
            }
            this.addAnnotations(cl, mutable, beanMetaData.getAnnotations());
        }
    }

    private void addPropertyAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        ClassLoader cl;
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData == null) {
            return;
        }
        Set properties = beanMetaData.getProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        try {
            cl = Configurator.getClassLoader(beanMetaData);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting classloader for metadata");
        }
        for (PropertyMetaData property : properties) {
            this.addPropertyAnnotations(cl, mutable, property, beanInfo);
        }
    }

    private void addPropertyAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, PropertyMetaData propertyMetaData, BeanInfo beanInfo) {
        FieldInfo fieldInfo;
        Set propertyAnnotations = propertyMetaData.getAnnotations();
        if (propertyAnnotations == null || propertyAnnotations.size() == 0) {
            return;
        }
        PropertyInfo propertyInfo = beanInfo.getProperty(propertyMetaData.getName());
        MethodInfo methodInfo = propertyInfo.getGetter();
        if (methodInfo != null) {
            this.addAnnotations(classloader, mutable, methodInfo, (Set<AnnotationMetaData>)propertyAnnotations);
        }
        if ((methodInfo = propertyInfo.getSetter()) != null) {
            this.addAnnotations(classloader, mutable, methodInfo, (Set<AnnotationMetaData>)propertyAnnotations);
        }
        if ((fieldInfo = propertyInfo.getFieldInfo()) != null) {
            this.addAnnotations(classloader, mutable, fieldInfo, (Set<AnnotationMetaData>)propertyAnnotations);
        }
    }

    private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, MethodInfo methodInfo, Set<AnnotationMetaData> annotations) {
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, (Object)methodInfo.getName());
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
        this.addAnnotations(classloader, loader, annotations);
        mutable.addComponentMetaDataRetrieval((Signature)new MethodSignature(methodInfo), (MetaDataRetrieval)loader);
    }

    private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, FieldInfo fieldInfo, Set<AnnotationMetaData> annotations) {
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, (Object)fieldInfo.getName());
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
        this.addAnnotations(classloader, loader, annotations);
        mutable.addComponentMetaDataRetrieval((Signature)new FieldSignature(fieldInfo), (MetaDataRetrieval)loader);
    }

    private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, Set<AnnotationMetaData> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        for (AnnotationMetaData annotation : annotations) {
            mutable.addAnnotation(annotation.getAnnotationInstance(classloader));
        }
    }
}

