/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.api.model;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.helpers.UnmodifiableBeanInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.helpers.UnmodifiableControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.helpers.UnmodifiableKernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

abstract class FromContextDelegate
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final FromContextDelegate NOOP = new NoopFromContext("noop");
    static final FromContextDelegate NAME = new NameFromContext("name");
    static final FromContextDelegate ALIASES = new AliasesFromContext("aliases");
    static final FromContextDelegate METADATA = new MetaDataFromContext("metadata");
    static final FromContextDelegate BEANINFO = new BeanInfoFromContext("beaninfo");
    static final FromContextDelegate SCOPE = new ScopeFromContext("scope");
    static final FromContextDelegate STATE = new StateFromContext("state");
    static final FromContextDelegate ID = new IdFromContext("id");
    static final FromContextDelegate CONTEXT = new ThisContext("context");
    protected final String fromString;
    private static Map<String, FromContextDelegate> values = new HashMap<String, FromContextDelegate>();

    protected FromContextDelegate(String fromString) {
        if (fromString == null) {
            throw new IllegalArgumentException("Null from string");
        }
        this.fromString = fromString;
    }

    protected void validate(ControllerContext context) {
    }

    public Object executeLookup(ControllerContext context) throws Throwable {
        this.validate(context);
        return this.internalExecute(context);
    }

    public abstract Object internalExecute(ControllerContext var1) throws Throwable;

    public String getFromString() {
        return this.fromString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FromContextDelegate)) {
            return false;
        }
        FromContextDelegate other = (FromContextDelegate)object;
        return this.fromString.equals(other.getFromString());
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.fromString);
    }

    protected int getHashCode() {
        return this.fromString.hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return values.get(this.fromString);
    }

    static {
        values.put(NOOP.getFromString(), NOOP);
        values.put(NAME.getFromString(), NAME);
        values.put(ALIASES.getFromString(), ALIASES);
        values.put(METADATA.getFromString(), METADATA);
        values.put(BEANINFO.getFromString(), BEANINFO);
        values.put(SCOPE.getFromString(), SCOPE);
        values.put(STATE.getFromString(), STATE);
        values.put(ID.getFromString(), ID);
        values.put(CONTEXT.getFromString(), CONTEXT);
    }

    private static class ThisContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public ThisContext(String fromString) {
            super(fromString);
        }

        public ControllerContext internalExecute(ControllerContext context) {
            if (context instanceof KernelControllerContext) {
                return new UnmodifiableKernelControllerContext((KernelControllerContext)context);
            }
            return new UnmodifiableControllerContext(context);
        }
    }

    private static class IdFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public IdFromContext(String fromString) {
            super(fromString);
        }

        public Object internalExecute(ControllerContext context) {
            return context.getName();
        }
    }

    private static class StateFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public StateFromContext(String fromString) {
            super(fromString);
        }

        public ControllerState internalExecute(ControllerContext context) {
            return context.getState();
        }
    }

    private static class ScopeFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public ScopeFromContext(String fromString) {
            super(fromString);
        }

        public ScopeKey internalExecute(ControllerContext context) {
            return context.getScopeInfo().getScope();
        }
    }

    private static class BeanInfoFromContext
    extends KernelFromContextDelegate {
        private static final long serialVersionUID = 1L;

        public BeanInfoFromContext(String fromString) {
            super(fromString);
        }

        public BeanInfo internalExecute(ControllerContext context) {
            BeanInfo info = ((KernelControllerContext)context).getBeanInfo();
            return info != null ? new UnmodifiableBeanInfo(info) : null;
        }
    }

    private static class MetaDataFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public MetaDataFromContext(String fromString) {
            super(fromString);
        }

        public MetaData internalExecute(ControllerContext context) {
            return context.getScopeInfo().getMetaData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AliasesFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public AliasesFromContext(String fromString) {
            super(fromString);
        }

        @Override
        public Set<Object> internalExecute(ControllerContext context) {
            Set aliases = context.getAliases();
            return aliases != null ? Collections.unmodifiableSet(aliases) : null;
        }
    }

    private static class NameFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public NameFromContext(String fromString) {
            super(fromString);
        }

        public Object internalExecute(ControllerContext context) {
            return context.getName();
        }
    }

    private static class NoopFromContext
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        public NoopFromContext(String fromString) {
            super(fromString);
        }

        public Object internalExecute(ControllerContext context) {
            throw new UnsupportedOperationException("Noop from context.");
        }
    }

    private static abstract class KernelFromContextDelegate
    extends FromContextDelegate {
        private static final long serialVersionUID = 1L;

        protected KernelFromContextDelegate(String fromString) {
            super(fromString);
        }

        protected void validate(ControllerContext context) {
            if (!(context instanceof KernelControllerContext)) {
                throw new UnsupportedOperationException("Cannot execute " + this.getFromString() + " on underlying context: " + context);
            }
        }
    }
}

