/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test;

import java.util.HashMap;
import java.util.Map;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.BaseTestCase;
import org.jboss.test.kernel.annotations.support.AfterInstallVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunAnnotationsTest
extends BaseTestCase {
    private KernelController controller;
    private Map<Class<?>, AfterInstallVerifier<?>> verifiers = new HashMap();

    protected AbstractRunAnnotationsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.controller = this.createController();
    }

    protected void tearDown() throws Exception {
        if (this.controller != null) {
            this.controller.shutdown();
        }
        this.controller = null;
        super.tearDown();
    }

    protected void runAnnotationsOnTarget(Object target) throws Throwable {
        this.runAnnotationsOnTarget(target, BeanAccessMode.STANDARD);
    }

    protected void runAnnotationsOnTarget(Object target, BeanAccessMode mode) throws Throwable {
        AbstractRunAnnotationsTest.assertNotNull((String)"Target is null", (Object)target);
        Class<?> clazz = target.getClass();
        this.runAnnotations(clazz, target, mode);
    }

    protected void runAnnotationsOnClass(Class<?> clazz) throws Throwable {
        this.runAnnotationsOnClass(clazz, BeanAccessMode.STANDARD);
    }

    protected void runAnnotationsOnClass(Class<?> clazz, BeanAccessMode mode) throws Throwable {
        this.runAnnotations(clazz, null, mode);
    }

    protected <T> void runAnnotations(Class<T> clazz, T target) throws Throwable {
        this.runAnnotations(clazz, target, BeanAccessMode.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void runAnnotations(Class<T> clazz, T target, BeanAccessMode mode) throws Throwable {
        KernelController controller = this.getController();
        String className = clazz.getName();
        String name = target != null ? target.toString() : className + System.currentTimeMillis();
        AbstractBeanMetaData beanMetaData = new AbstractBeanMetaData(name, className);
        beanMetaData.setAccessMode(mode);
        try {
            KernelControllerContext context = controller.install((BeanMetaData)beanMetaData, target);
            this.checkContextState(context);
            if (target == null) {
                target = clazz.cast(context.getTarget());
            }
            this.doTestAfterInstall(clazz, target);
        }
        finally {
            controller.uninstall((Object)name);
        }
    }

    protected void checkContextState(KernelControllerContext context) {
        AbstractRunAnnotationsTest.assertEquals((Object)ControllerState.INSTALLED, (Object)context.getState());
    }

    protected <T> void addVerifier(AfterInstallVerifier<T> verifier) {
        this.verifiers.put(verifier.getTargetClass(), verifier);
    }

    protected void removeVerifier(Class<?> clazz) {
        this.verifiers.remove(clazz);
    }

    protected <T> void doTestAfterInstall(Class<T> clazz, T target) {
        AfterInstallVerifier<?> verifier = this.verifiers.get(clazz);
        if (verifier != null) {
            verifier.verify(target);
        } else {
            this.doTestAfterInstall(target);
        }
    }

    protected void doTestAfterInstall(Object target) {
        this.doTestAfterInstall();
    }

    protected void doTestAfterInstall() {
    }

    protected KernelController createController() throws Exception {
        KernelConfig config = this.createKernelConfig();
        BasicBootstrap bootstrap = config != null ? new BasicBootstrap(config) : new BasicBootstrap();
        bootstrap.run();
        Kernel kernel = bootstrap.getKernel();
        return kernel.getController();
    }

    protected KernelConfig createKernelConfig() {
        return null;
    }

    protected KernelController getController() {
        return this.controller;
    }
}

