/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.BeanRepository;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanRepository;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class CallbackTestCase
extends OldAbstractKernelDependencyTest {
    public CallbackTestCase(String name) throws Throwable {
        super(name);
    }

    public CallbackTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public static Test suite() {
        return CallbackTestCase.suite(CallbackTestCase.class);
    }

    public void testCallbackCorrectOrder() throws Throwable {
        this.callbackCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        this.assertEmpty(repository.getBeans());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean);
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)1, (int)repository.getBeans().size());
        CallbackTestCase.assertTrue((bean == repository.getBeans().get(0) ? 1 : 0) != 0);
    }

    protected void callbackCorrectOrder() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    public void testCallbackWrongOrder() throws Throwable {
        this.callbackWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        List<SimpleBean> beans = repository.getBeans();
        CallbackTestCase.assertFalse((boolean)beans.isEmpty());
        CallbackTestCase.assertEquals((int)1, (int)beans.size());
        CallbackTestCase.assertTrue((bean == beans.get(0) ? 1 : 0) != 0);
    }

    protected void callbackWrongOrder() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    public void testCallbackReinstall() throws Throwable {
        this.callbackReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        this.assertEmpty(repository.getBeans());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean);
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)1, (int)repository.getBeans().size());
        CallbackTestCase.assertTrue((bean == repository.getBeans().get(0) ? 1 : 0) != 0);
        this.assertUninstall("Name1");
        CallbackTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        this.assertEmpty(repository.getBeans());
        context1 = this.assertInstall(0, "Name1");
        repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)1, (int)repository.getBeans().size());
        CallbackTestCase.assertTrue((bean == repository.getBeans().get(0) ? 1 : 0) != 0);
        this.assertUninstall("Name2");
        CallbackTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        this.assertEmpty(repository.getBeans());
    }

    protected void callbackReinstall() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    public void testCardinalityCallbackCorrectOrder() throws Throwable {
        boolean first;
        this.callbackCardinalityCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.START);
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        this.assertEmpty(repository.getBeans());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean1);
        this.assertEmpty(repository.getBeans());
        ControllerContext context3 = this.assertInstall(2, "Name3");
        SimpleBean bean2 = (SimpleBean)context3.getTarget();
        CallbackTestCase.assertNotNull((Object)bean2);
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)2, (int)repository.getBeans().size());
        boolean bl = first = bean1 == repository.getBeans().get(0);
        if (first) {
            CallbackTestCase.assertTrue((bean2 == repository.getBeans().get(1) ? 1 : 0) != 0);
        } else {
            CallbackTestCase.assertTrue((bean2 == repository.getBeans().get(0) ? 1 : 0) != 0);
        }
    }

    protected void callbackCardinalityCorrectOrder() throws Throwable {
        AbstractBeanMetaData repository = this.buildRepository(Cardinality.createUnlimitedCardinality((int)2));
        this.buildMetaData((BeanMetaData)repository);
    }

    public void testCardinalityCallbackWrongOrder() throws Throwable {
        boolean first;
        this.callbackCardinalityWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean1);
        ControllerContext context3 = this.assertInstall(2, "Name3");
        SimpleBean bean2 = (SimpleBean)context3.getTarget();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)2, (int)repository.getBeans().size());
        boolean bl = first = bean1 == repository.getBeans().get(0);
        if (first) {
            CallbackTestCase.assertTrue((bean2 == repository.getBeans().get(1) ? 1 : 0) != 0);
        } else {
            CallbackTestCase.assertTrue((bean2 == repository.getBeans().get(0) ? 1 : 0) != 0);
        }
    }

    protected void callbackCardinalityWrongOrder() throws Throwable {
        AbstractBeanMetaData repository = this.buildRepository(Cardinality.createUnlimitedCardinality((int)2));
        this.buildMetaData((BeanMetaData)repository);
    }

    public void testCardinalityCallbackReinstall() throws Throwable {
        this.callbackCardinalityReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.START);
        BeanRepository repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        this.assertEmpty(repository.getBeans());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context2.getTarget();
        CallbackTestCase.assertNotNull((Object)bean1);
        this.assertEmpty(repository.getBeans());
        ControllerContext context3 = this.assertInstall(2, "Name3");
        SimpleBean bean2 = (SimpleBean)context3.getTarget();
        CallbackTestCase.assertNotNull((Object)bean2);
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)2, (int)repository.getBeans().size());
        this.assertUninstall("Name1");
        CallbackTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        this.assertEmpty(repository.getBeans());
        context1 = this.assertInstall(0, "Name1");
        repository = (BeanRepository)context1.getTarget();
        CallbackTestCase.assertNotNull((Object)repository);
        CallbackTestCase.assertFalse((boolean)repository.getBeans().isEmpty());
        CallbackTestCase.assertEquals((int)2, (int)repository.getBeans().size());
        this.assertUninstall("Name2");
        CallbackTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        CallbackTestCase.assertEquals((Object)ControllerState.START, (Object)context1.getState());
        this.assertEmpty(repository.getBeans());
        this.assertInstall(1, "Name2");
        CallbackTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        CallbackTestCase.assertEquals((int)2, (int)repository.getBeans().size());
        this.assertUninstall("Name3");
        CallbackTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context3.getState());
        CallbackTestCase.assertEquals((Object)ControllerState.START, (Object)context1.getState());
        this.assertEmpty(repository.getBeans());
    }

    protected void callbackCardinalityReinstall() throws Throwable {
        AbstractBeanMetaData repository = this.buildRepository(Cardinality.createUnlimitedCardinality((int)2));
        this.buildMetaData((BeanMetaData)repository);
    }

    protected void buildMetaData(BeanMetaData repository) {
        this.setBeanMetaDatas(new BeanMetaData[]{repository, new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName()), new AbstractBeanMetaData("Name3", SimpleBeanImpl.class.getName())});
    }

    protected AbstractBeanMetaData buildRepository() {
        return this.buildRepository(null);
    }

    protected AbstractBeanMetaData buildRepository(Cardinality cardinality) {
        AbstractBeanMetaData repository = new AbstractBeanMetaData("Name1", SimpleBeanRepository.class.getName());
        ArrayList<InstallCallbackMetaData> installs = new ArrayList<InstallCallbackMetaData>();
        repository.setInstallCallbacks(installs);
        InstallCallbackMetaData install = new InstallCallbackMetaData();
        install.setMethodName("addSimpleBean");
        if (cardinality != null) {
            install.setCardinality(cardinality);
        }
        installs.add(install);
        ArrayList<UninstallCallbackMetaData> unstalls = new ArrayList<UninstallCallbackMetaData>();
        repository.setUninstallCallbacks(unstalls);
        UninstallCallbackMetaData uninstall = new UninstallCallbackMetaData();
        uninstall.setMethodName("removeSimpleBean");
        unstalls.add(uninstall);
        return repository;
    }
}

