/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.deployment.support.container.Bean1Type;
import org.jboss.test.kernel.deployment.support.container.Bean2Type;
import org.jboss.test.kernel.deployment.support.container.BeanContainer;
import org.jboss.test.kernel.deployment.support.container.BeanPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerUsageTestCase
extends AbstractKernelTest {
    private Kernel kernel;
    private BasicXMLDeployer deployer;

    public static Test suite() {
        return BeanContainerUsageTestCase.suite(BeanContainerUsageTestCase.class);
    }

    public BeanContainerUsageTestCase(String name) {
        super(name);
    }

    public void testDependencyInjectionOfBean() throws Throwable {
        this.bootstrap();
        this.getBean("BeanContainer1Type");
        BeanPool pool1 = (BeanPool)this.getBean("Bean1TypePool");
        BeanContainer container2 = (BeanContainer)this.getBean("BeanContainer2Type");
        Bean2Type bean21 = (Bean2Type)container2.getBean();
        this.getLog().debug((Object)("bean21: " + bean21));
        Bean1Type bean11 = bean21.getBean1();
        BeanContainerUsageTestCase.assertEquals((int)0, (int)pool1.size());
        this.getLog().debug((Object)("bean11: " + bean11));
        BeanContainerUsageTestCase.assertNotNull((Object)bean11);
        Bean2Type bean22 = (Bean2Type)container2.getBean();
        this.getLog().debug((Object)("bean22: " + bean22));
        BeanContainerUsageTestCase.assertTrue((bean22 != bean21 ? 1 : 0) != 0);
        Bean1Type bean12 = bean22.getBean1();
        this.getLog().debug((Object)("bean12: " + bean12));
        BeanContainerUsageTestCase.assertNotNull((Object)bean12);
        BeanContainerUsageTestCase.assertTrue((bean12 != bean11 ? 1 : 0) != 0);
        Bean2Type bean23 = (Bean2Type)container2.getBean();
        this.getLog().debug((Object)("bean23: " + bean23));
        Bean1Type bean13Injected = bean23.getBean1();
        this.getLog().debug((Object)("bean13Injected: " + bean13Injected));
        BeanContainerUsageTestCase.assertNotNull((Object)bean13Injected);
        this.deployer.shutdown();
    }

    public void testDependencyInjectionOfBeanWithMismatchedPoolSizes() throws Throwable {
        this.bootstrap();
        BeanContainer container2 = (BeanContainer)this.getBean("BeanContainer2Type");
        try {
            BeanContainerUsageTestCase.fail((String)("Should not have been able to create a Bean2Type: " + container2.getBean()));
        }
        catch (IllegalStateException e) {
            this.getLog().info((Object)"Saw expected IllegalStateException");
        }
        this.deployer.shutdown();
    }

    protected KernelDeployment getDeploymentForDependencyInjectionOfBean() {
        return null;
    }

    @Override
    protected Kernel bootstrap() throws Throwable {
        this.kernel = super.bootstrap();
        this.deployer = new BasicXMLDeployer(this.kernel, ControllerMode.AUTOMATIC);
        String testName = "getDeploymentFor" + this.getName().substring(4);
        KernelDeployment deployment = null;
        try {
            Method getDeployment = ((Object)((Object)this)).getClass().getDeclaredMethod(testName, null);
            deployment = (KernelDeployment)getDeployment.invoke((Object)this, null);
        }
        catch (NoSuchMethodException e) {
            this.getLog().debug((Object)("Ignoring: " + e));
        }
        if (deployment == null) {
            String xmlName = ((Object)((Object)this)).getClass().getName() + "_" + super.getName();
            xmlName = xmlName.replace('.', '/') + ".xml";
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(xmlName);
            if (url != null) {
                this.deployer.deploy(url);
            } else {
                this.getLog().debug((Object)("No test specific deployment " + xmlName));
            }
        } else {
            this.deployer.deploy(deployment);
        }
        this.deployer.validate();
        return this.kernel;
    }

    protected void shutdown() {
        this.deployer.shutdown();
    }

    protected void assertNoBeansExist() {
        KernelController controller = this.kernel.getController();
        ControllerStateModel states = controller.getStates();
        int beanCount = 0;
        for (ControllerState s : states) {
            Set ctxs = controller.getContextsByState(s);
            beanCount += ctxs.size();
        }
        BeanContainerUsageTestCase.assertEquals((int)0, (int)beanCount);
    }

    protected void assertBeansExist(Set<String> names) {
        HashSet<String> unexpectedBeanNames = new HashSet<String>();
        KernelController controller = this.kernel.getController();
        ControllerStateModel states = controller.getStates();
        for (ControllerState s : states) {
            Set ctxs = controller.getContextsByState(s);
            for (ControllerContext ctx : ctxs) {
                String name = ctx.getName().toString();
                if (names.contains(name)) continue;
                unexpectedBeanNames.add(name);
            }
        }
        BeanContainerUsageTestCase.assertEquals(Collections.emptySet(), unexpectedBeanNames);
    }

    protected Object getBean(Object name) {
        KernelControllerContext context = this.getControllerContext(name, ControllerState.INSTALLED);
        return context.getTarget();
    }

    protected KernelControllerContext getControllerContext(Object name, ControllerState state) {
        KernelController controller = this.kernel.getController();
        KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
        if (context == null) {
            this.getLog().error((Object)("Bean not found " + name + " at state " + state));
            ControllerStateModel states = controller.getStates();
            for (ControllerState s : states) {
                this.getLog().info((Object)(s + ": " + controller.getContextsByState(s)));
            }
            throw new IllegalStateException("Bean not found " + name + " at state " + state);
        }
        return context;
    }
}

