/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.plugins.AbstractAliasMetaData;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.CloneUtil;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.MutableLifecycleHolder;
import org.jboss.beans.metadata.plugins.NestedBeanHandler;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.spi.AliasMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(properties=ManagementProperties.EXPLICIT)
@XmlRootElement(name="bean")
@XmlType(name="beanType", propOrder={"aliasMetaData", "annotations", "classLoader", "constructor", "properties", "create", "start", "stop", "destroy", "depends", "demands", "supplies", "installs", "uninstalls", "installCallbacks", "uninstallCallbacks"})
public class AbstractBeanMetaData
extends AbstractFeatureMetaData
implements BeanMetaData,
BeanMetaDataFactory,
MutableLifecycleHolder,
Serializable {
    private static final long serialVersionUID = 4L;
    protected String bean;
    protected String name;
    protected Set<Object> aliases;
    protected Set<AliasMetaData> aliasMetaData;
    protected String parent;
    protected boolean isAbstract;
    protected AutowireType autowireType;
    protected ControllerMode mode;
    protected ErrorHandlingMode errorHandlingMode;
    protected BeanAccessMode accessMode;
    protected boolean autowireCandidate = true;
    private Set<PropertyMetaData> properties;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected Set<DemandMetaData> demands;
    protected Set<SupplyMetaData> supplies;
    protected Set<DependencyMetaData> depends;
    protected List<InstallMetaData> installs;
    protected List<InstallMetaData> uninstalls;
    protected List<CallbackMetaData> installCallbacks;
    protected List<CallbackMetaData> uninstallCallbacks;
    protected transient ControllerContext context;

    public AbstractBeanMetaData() {
    }

    public AbstractBeanMetaData(String bean) {
        this.bean = bean;
    }

    public AbstractBeanMetaData(String name, String bean) {
        this.name = name;
        this.bean = bean;
    }

    @Override
    public List<BeanMetaData> getBeans() {
        NestedBeanHandler handler = this.createNestedBeanHandler();
        return handler.checkForNestedBeans();
    }

    protected NestedBeanHandler createNestedBeanHandler() {
        return new NestedBeanHandler(this);
    }

    @Override
    public String getBean() {
        return this.bean;
    }

    @XmlAttribute(name="class")
    public void setBean(String bean) {
        this.bean = bean;
        this.flushJBossObjectCache();
    }

    public PropertyMetaData getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (PropertyMetaData prop : this.properties) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    public void addProperty(PropertyMetaData property) {
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        if (this.properties == null) {
            this.properties = new HashSet<PropertyMetaData>();
        }
        this.properties.add(property);
        this.flushJBossObjectCache();
    }

    @ManagementProperty(managed=true)
    @XmlElement(name="property", type=AbstractPropertyMetaData.class)
    public void setProperties(Set<PropertyMetaData> properties) {
        this.properties = properties;
        this.flushJBossObjectCache();
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    @Override
    @XmlElement(name="classloader", type=AbstractClassLoaderMetaData.class)
    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    @XmlElement(name="constructor", type=AbstractConstructorMetaData.class)
    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    @XmlElement(name="demand", type=AbstractDemandMetaData.class)
    public void setDemands(Set<DemandMetaData> demands) {
        this.demands = demands;
        this.flushJBossObjectCache();
    }

    @XmlElement(name="supply", type=AbstractSupplyMetaData.class)
    public void setSupplies(Set<SupplyMetaData> supplies) {
        this.supplies = supplies;
        this.flushJBossObjectCache();
    }

    @XmlElement(name="depends", type=AbstractDependencyMetaData.class)
    public void setDepends(Set<DependencyMetaData> depends) {
        this.depends = depends;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @XmlAttribute
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public Set<Object> getAliases() {
        return this.aliases;
    }

    @XmlTransient
    public void setAliases(Set<Object> aliases) {
        this.aliases = aliases;
    }

    public Set<AliasMetaData> getAliasMetaData() {
        return this.aliasMetaData;
    }

    @XmlElement(name="alias", type=AbstractAliasMetaData.class)
    public void setAliasMetaData(Set<AliasMetaData> aliases) {
        this.aliasMetaData = aliases;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @XmlAttribute
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @XmlAttribute
    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    @Override
    public AutowireType getAutowireType() {
        return this.autowireType;
    }

    @XmlAttribute(name="autowire-type")
    public void setAutowireType(AutowireType autowireType) {
        this.autowireType = autowireType;
    }

    @Override
    public ControllerMode getMode() {
        return this.mode;
    }

    @Override
    @XmlAttribute
    public void setMode(ControllerMode mode) {
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    @Override
    public ErrorHandlingMode getErrorHandlingMode() {
        return this.errorHandlingMode;
    }

    @XmlAttribute(name="error-handling")
    public void setErrorHandlingMode(ErrorHandlingMode errorHandlingMode) {
        this.errorHandlingMode = errorHandlingMode;
    }

    @Override
    public BeanAccessMode getAccessMode() {
        return this.accessMode;
    }

    @XmlAttribute(name="access-mode")
    public void setAccessMode(BeanAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    @XmlAttribute(name="autowire-candidate")
    public void setAutowireCandidate(boolean autowireCandidate) {
        this.autowireCandidate = autowireCandidate;
    }

    @Override
    public Set<PropertyMetaData> getProperties() {
        return this.properties;
    }

    @Override
    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    @Override
    public LifecycleMetaData getCreate() {
        return this.create;
    }

    @Override
    @XmlElement(name="create", type=AbstractLifecycleMetaData.class)
    public void setCreate(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            lifecycle.setState(ControllerState.CREATE);
        }
        this.create = lifecycle;
    }

    @Override
    public LifecycleMetaData getStart() {
        return this.start;
    }

    @Override
    @XmlElement(name="start", type=AbstractLifecycleMetaData.class)
    public void setStart(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            lifecycle.setState(ControllerState.START);
        }
        this.start = lifecycle;
    }

    @Override
    public LifecycleMetaData getStop() {
        return this.stop;
    }

    @Override
    @XmlElement(name="stop", type=AbstractLifecycleMetaData.class)
    public void setStop(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            lifecycle.setState(ControllerState.START);
        }
        this.stop = lifecycle;
    }

    @Override
    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    @Override
    @XmlElement(name="destroy", type=AbstractLifecycleMetaData.class)
    public void setDestroy(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            lifecycle.setState(ControllerState.CREATE);
        }
        this.destroy = lifecycle;
    }

    @Override
    public Set<DemandMetaData> getDemands() {
        return this.demands;
    }

    @Override
    public Set<SupplyMetaData> getSupplies() {
        return this.supplies;
    }

    @Override
    public Set<DependencyMetaData> getDepends() {
        return this.depends;
    }

    @Override
    public List<InstallMetaData> getInstalls() {
        return this.installs;
    }

    @XmlElement(name="install", type=AbstractInstallMetaData.class)
    public void setInstalls(List<InstallMetaData> installs) {
        this.installs = installs;
        this.flushJBossObjectCache();
    }

    @Override
    public List<InstallMetaData> getUninstalls() {
        return this.uninstalls;
    }

    @XmlElement(name="uninstall", type=AbstractInstallMetaData.class)
    public void setUninstalls(List<InstallMetaData> uninstalls) {
        this.uninstalls = uninstalls;
        this.flushJBossObjectCache();
    }

    @Override
    public List<CallbackMetaData> getInstallCallbacks() {
        return this.installCallbacks;
    }

    @XmlElement(name="incallback", type=InstallCallbackMetaData.class)
    public void setInstallCallbacks(List<CallbackMetaData> installCallbacks) {
        this.installCallbacks = installCallbacks;
        this.flushJBossObjectCache();
    }

    @Override
    public List<CallbackMetaData> getUninstallCallbacks() {
        return this.uninstallCallbacks;
    }

    @XmlElement(name="uncallback", type=UninstallCallbackMetaData.class)
    public void setUninstallCallbacks(List<CallbackMetaData> uninstallCallbacks) {
        this.uninstallCallbacks = uninstallCallbacks;
        this.flushJBossObjectCache();
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        boolean isInnerBean;
        KernelControllerContext ctx;
        if (this.getBean() == null && !this.isAbstract() && this.getParent() == null) {
            ConstructorMetaData constructor = this.getConstructor();
            if (constructor == null) {
                throw new IllegalArgumentException("Bean should have a class attribute or a constructor element.");
            }
            if (constructor.getFactoryMethod() == null) {
                if (constructor.getValue() == null) {
                    throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have either a factoryMethod attribute or embedded value.");
                }
            } else if (constructor.getFactory() == null && constructor.getFactoryClass() == null) {
                throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have one of a factoryClass attribute or a factory element, or embedded value.");
            }
        }
        if ((ctx = visitor.getControllerContext()).getBeanMetaData() == this) {
            this.context = ctx;
        }
        boolean bl = isInnerBean = !visitor.visitorNodeStack().isEmpty();
        if (isInnerBean) {
            Object name = ctx.getName();
            Object iDependOn = this.getUnderlyingValue();
            ControllerState whenRequired = visitor.getContextState();
            AbstractDependencyItem di = new AbstractDependencyItem(name, iDependOn, whenRequired, ControllerState.INSTALLED);
            visitor.addDependency((DependencyItem)di);
        }
        if (this.create != null && this.create.getMethodName() == null) {
            this.create.setMethodName("create");
        }
        if (this.start != null && this.start.getMethodName() == null) {
            this.start.setMethodName("start");
        }
        if (this.stop != null && this.stop.getMethodName() == null) {
            this.stop.setMethodName("stop");
        }
        if (this.destroy != null && this.destroy.getMethodName() == null) {
            this.destroy.setMethodName("destroy");
        }
        super.initialVisit(visitor);
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.classLoader != null && this.classLoader.getClassLoader() != this) {
            children.add(this.classLoader);
        }
        if (this.constructor != null) {
            children.add(this.constructor);
        }
        if (this.properties != null) {
            children.addAll(this.properties);
        }
        if (this.create != null) {
            children.add(this.create);
        }
        if (this.start != null) {
            children.add(this.start);
        }
        if (this.stop != null) {
            children.add(this.stop);
        }
        if (this.destroy != null) {
            children.add(this.destroy);
        }
        if (this.demands != null) {
            children.addAll(this.demands);
        }
        if (this.supplies != null) {
            children.addAll(this.supplies);
        }
        if (this.depends != null) {
            children.addAll(this.depends);
        }
        if (this.installs != null) {
            children.addAll(this.installs);
        }
        if (this.uninstalls != null) {
            children.addAll(this.uninstalls);
        }
        if (this.installCallbacks != null) {
            children.addAll(this.installCallbacks);
        }
        if (this.uninstallCallbacks != null) {
            children.addAll(this.uninstallCallbacks);
        }
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        throw new IllegalArgumentException("Cannot determine inject class type: " + this);
    }

    @Override
    public Object getUnderlyingValue() {
        return this.name;
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        if (this.context == null) {
            throw new IllegalStateException("Context has not been set: " + this);
        }
        Controller controller = this.context.getController();
        ControllerContext lookup = controller.getInstalledContext((Object)this.name);
        if (lookup == null || lookup.getTarget() == null) {
            if (info == null && this.classLoader != null && this.classLoader.getClassLoader() == this) {
                return cl;
            }
            throw new IllegalArgumentException("Bean not yet installed: " + this.name);
        }
        Object target = lookup.getTarget();
        if (info != null && !info.getType().isAssignableFrom(target.getClass())) {
            throw new ClassCastException(target + " is not a " + info);
        }
        return target;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.aliases != null) {
            buffer.append(" aliases=").append(this.aliases);
        }
        buffer.append(" bean=").append(this.bean);
        buffer.append(" properties=");
        JBossObject.list((JBossStringBuilder)buffer, this.properties);
        if (this.classLoader != null && this.classLoader.getClassLoader() != this) {
            buffer.append(" classLoader=").append((Object)this.classLoader);
        }
        buffer.append(" constructor=").append((Object)this.constructor);
        buffer.append(" autowireCandidate=").append(this.autowireCandidate);
        if (this.create != null) {
            buffer.append(" create=").append((Object)this.create);
        }
        if (this.start != null) {
            buffer.append(" start=").append((Object)this.start);
        }
        if (this.stop != null) {
            buffer.append(" stop=").append((Object)this.stop);
        }
        if (this.destroy != null) {
            buffer.append(" destroy=").append((Object)this.destroy);
        }
        if (this.demands != null) {
            buffer.append(" demands=");
            JBossObject.list((JBossStringBuilder)buffer, this.demands);
        }
        super.toString(buffer);
        if (this.supplies != null) {
            buffer.append(" supplies=");
            JBossObject.list((JBossStringBuilder)buffer, this.supplies);
        }
        if (this.depends != null) {
            buffer.append(" depends=");
            JBossObject.list((JBossStringBuilder)buffer, this.depends);
        }
        if (this.installs != null) {
            buffer.append(" installs=");
            JBossObject.list((JBossStringBuilder)buffer, this.installs);
        }
        if (this.uninstalls != null) {
            buffer.append(" uninstalls=");
            JBossObject.list((JBossStringBuilder)buffer, this.uninstalls);
        }
        if (this.installCallbacks != null) {
            buffer.append(" installCallbacks=");
            JBossObject.list((JBossStringBuilder)buffer, this.installCallbacks);
        }
        if (this.uninstallCallbacks != null) {
            buffer.append(" uninstallCallbacks=");
            JBossObject.list((JBossStringBuilder)buffer, this.uninstallCallbacks);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.bean);
        buffer.append('/');
        buffer.append(this.name);
    }

    @Override
    public AbstractBeanMetaData clone() {
        AbstractBeanMetaData clone = (AbstractBeanMetaData)super.clone();
        this.doClone(clone);
        return clone;
    }

    protected void doClone(AbstractBeanMetaData clone) {
        super.doClone(clone);
        if (this.aliases != null) {
            clone.setAliases(new HashSet<Object>(this.aliases));
        }
        clone.setAliasMetaData(CloneUtil.cloneCollection(this.aliasMetaData, HashSet.class, AliasMetaData.class));
        clone.setClassLoader(CloneUtil.cloneObject(this.classLoader, ClassLoaderMetaData.class));
        clone.setConstructor(CloneUtil.cloneObject(this.constructor, ConstructorMetaData.class));
        clone.setCreate(CloneUtil.cloneObject(this.create, LifecycleMetaData.class));
        clone.setDemands(CloneUtil.cloneCollection(this.demands, HashSet.class, DemandMetaData.class));
        clone.setDepends(CloneUtil.cloneCollection(this.depends, HashSet.class, DependencyMetaData.class));
        clone.setDestroy(CloneUtil.cloneObject(this.destroy, LifecycleMetaData.class));
        clone.setInstallCallbacks(CloneUtil.cloneCollection(this.installCallbacks, ArrayList.class, CallbackMetaData.class));
        clone.setInstalls(CloneUtil.cloneCollection(this.installs, ArrayList.class, InstallMetaData.class));
        clone.setProperties(CloneUtil.cloneCollection(this.properties, HashSet.class, PropertyMetaData.class));
        clone.setStart(CloneUtil.cloneObject(this.start, LifecycleMetaData.class));
        clone.setStop(CloneUtil.cloneObject(this.stop, LifecycleMetaData.class));
        clone.setSupplies(CloneUtil.cloneCollection(this.supplies, HashSet.class, SupplyMetaData.class));
        clone.setUninstallCallbacks(CloneUtil.cloneCollection(this.uninstallCallbacks, ArrayList.class, CallbackMetaData.class));
        clone.setUninstalls(CloneUtil.cloneCollection(this.uninstalls, ArrayList.class, InstallMetaData.class));
    }
}

